/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.emi;

import com.google.common.collect.Maps;
import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.FluidEmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.runtime.EmiDrawContext;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageScreenBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IFilterSlot;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.SetGhostSlotPayload;
import net.p3pp3rf1y.sophisticatedcore.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.PumpUpgradeTab;
import net.p3pp3rf1y.sophisticatedcore.util.CapabilityHelper;

public class EmiStorageGhostDragDropHandler<T extends StorageScreenBase<?>>
implements EmiDragDropHandler<T> {
    private final BiFunction<T, EmiIngredient, Map<Bounds, Consumer<EmiIngredient>>> bounds = (screen, ingredient) -> {
        HashMap map = Maps.newHashMap();
        if (ingredient.getEmiStacks().isEmpty()) {
            return map;
        }
        class_1799 ghostStack = ((EmiStack)ingredient.getEmiStacks().getFirst()).getItemStack();
        if (!ghostStack.method_7960()) {
            FluidStack fluidStack = CapabilityHelper.getFromFluidHandler(ghostStack, fluidHandler -> Optional.ofNullable(StorageUtil.findExtractableContent((Storage)fluidHandler, null)).map(FluidStack::new).orElse(FluidStack.EMPTY), FluidStack.EMPTY);
            if (!fluidStack.isEmpty()) {
                screen.getUpgradeSettingsControl().getOpenTab().filter(tab -> tab instanceof PumpUpgradeTab.Advanced).map(PumpUpgradeTab.Advanced.class::cast).ifPresent(pumpUpgradeTab -> this.addFluidTargets((PumpUpgradeTab.Advanced)pumpUpgradeTab, fluidStack, map));
            }
            ((StorageContainerMenuBase)screen.method_17577()).getOpenContainer().ifPresent(c -> c.getSlots().forEach(s -> {
                if (s instanceof IFilterSlot && s.method_7680(ghostStack)) {
                    map.put(new Bounds(screen.getLeftX() + s.field_7873, screen.getTopY() + s.field_7872, 18, 18), i -> PacketDistributor.sendToServer(new SetGhostSlotPayload(ghostStack, s.field_7874)));
                }
            }));
        } else if (ingredient instanceof FluidEmiStack) {
            FluidEmiStack fluidStack = (FluidEmiStack)ingredient;
            screen.getUpgradeSettingsControl().getOpenTab().filter(tab -> tab instanceof PumpUpgradeTab.Advanced).map(PumpUpgradeTab.Advanced.class::cast).ifPresent(pumpUpgradeTab -> {
                class_3611 fluid = (class_3611)fluidStack.getKeyOfType(class_3611.class);
                this.addFluidTargets((PumpUpgradeTab.Advanced)pumpUpgradeTab, new FluidStack(fluid, 1L), map);
            });
        }
        return map;
    };

    public boolean dropStack(T screen, EmiIngredient stack, int x, int y) {
        Map<Bounds, Consumer<EmiIngredient>> bounds = this.bounds.apply(screen, stack);
        for (Bounds b : bounds.keySet()) {
            if (!b.contains(x, y)) continue;
            bounds.get(b).accept(stack);
            return true;
        }
        return false;
    }

    public void render(T screen, EmiIngredient dragged, class_332 draw, int mouseX, int mouseY, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap((class_332)draw);
        for (Bounds b : this.bounds.apply(screen, dragged).keySet()) {
            context.fill(b.x(), b.y(), b.width(), b.height(), -2010989773);
        }
    }

    private void addFluidTargets(PumpUpgradeTab.Advanced pumpUpgradeTab, FluidStack ghostFluid, Map<Bounds, Consumer<EmiIngredient>> map) {
        List<Position> slotTopLeftPositions = pumpUpgradeTab.getFluidFilterControl().getSlotTopLeftPositions();
        AtomicInteger slot = new AtomicInteger();
        slot.set(0);
        while (slot.get() < slotTopLeftPositions.size()) {
            Position position = slotTopLeftPositions.get(slot.get());
            int slotIndex = slot.get();
            map.put(new Bounds(position.x(), position.y(), 17, 17), ingredient -> pumpUpgradeTab.getFluidFilterControl().setFluid(slotIndex, ghostFluid));
            slot.incrementAndGet();
        }
    }
}

