/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.misc.globe.GlobeData;
import net.mehvahdjukaar.supplementaries.common.utils.Credits;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.class_1043;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;

public class GlobeManager {
    private static final Map<String, TextureInstance> TEXTURE_CACHE = Maps.newHashMap();
    private static final HashMap<class_2960, IntList> DIMENSION_COLOR_MAP = new HashMap();
    private static final IntList SEPIA_COLORS = new IntArrayList();
    private static final Map<String, Pair<Model, class_2960>> NAME_CACHE = new HashMap<String, Pair<Model, class_2960>>();
    private static final Map<String, Float> MODEL_ID_MAP = new HashMap<String, Float>();
    public static final List<class_2960> TEXTURES = new ArrayList<class_2960>();

    public static void refreshTextures() {
        TEXTURE_CACHE.clear();
    }

    public static class_1921 getRenderType(class_1937 world, boolean sepia) {
        return GlobeManager.getTextureInstance((class_1937)world, (boolean)sepia).renderType;
    }

    private static TextureInstance getTextureInstance(class_1937 world, boolean sepia) {
        return TEXTURE_CACHE.computeIfAbsent(GlobeManager.getTextureId(world, sepia), i -> new TextureInstance(world, sepia));
    }

    private static String getTextureId(class_1937 level, boolean sepia) {
        Object id = level.method_27983().method_29177().method_12832();
        if (sepia) {
            id = (String)id + "_sepia";
        }
        return id;
    }

    public static void refreshColorsAndTextures(class_3300 manager) {
        GlobeManager.recomputeCache();
        DIMENSION_COLOR_MAP.clear();
        int targetColors = 13;
        for (class_2960 res : manager.method_14488("textures/entity/globes/palettes", r -> r.method_12832().endsWith(".png")).keySet()) {
            List l = SpriteUtils.parsePaletteStrip((class_3300)manager, (class_2960)res, (int)targetColors);
            String name = res.method_12832();
            if ((name = name.substring(name.lastIndexOf("/") + 1).replace(".png", "")).equals("sepia")) {
                SEPIA_COLORS.clear();
                SEPIA_COLORS.addAll((Collection)l);
                continue;
            }
            DIMENSION_COLOR_MAP.put(class_2960.method_12829((String)name.replace(".", ":")), (IntList)new IntArrayList((Collection)l));
        }
        if (DIMENSION_COLOR_MAP.isEmpty()) {
            Supplementaries.LOGGER.error("Could not find any globe palette in textures/entity/globes/palettes");
        }
        GlobeManager.refreshTextures();
    }

    public static void recomputeCache() {
        NAME_CACHE.clear();
        for (Type type : Type.values()) {
            Model model = type == Type.FLAT ? Model.FLAT : Model.GLOBE;
            Pair pair = Pair.of((Object)((Object)model), (Object)type.texture);
            if (type.transKeyWord != null && !type.transKeyWord.getString().equals("")) {
                NAME_CACHE.put(type.transKeyWord.getString().toLowerCase(Locale.ROOT), (Pair<Model, class_2960>)pair);
            }
            for (String s : type.keyWords) {
                if (s.equals("")) continue;
                NAME_CACHE.put(s, (Pair<Model, class_2960>)pair);
            }
        }
        for (Map.Entry entry : Credits.INSTANCE.globes().entrySet()) {
            class_2960 path = (class_2960)entry.getValue();
            Model model = Model.GLOBE;
            if (path.method_12832().contains("globe_wais")) {
                model = Model.SNOW;
            }
            NAME_CACHE.put((String)entry.getKey(), (Pair<Model, class_2960>)Pair.of((Object)((Object)model), (Object)path));
        }
        TEXTURES.clear();
        NAME_CACHE.values().forEach(o -> {
            if (!TEXTURES.contains(o.getSecond())) {
                TEXTURES.add((class_2960)o.getSecond());
            }
        });
        Collections.sort(TEXTURES);
        MODEL_ID_MAP.clear();
        NAME_CACHE.forEach((key, value) -> MODEL_ID_MAP.put((String)key, Float.valueOf(TEXTURES.indexOf(value.getSecond()))));
    }

    @Nullable
    public static Pair<Model, class_2960> getModelAndTexture(String text) {
        return NAME_CACHE.get(text.toLowerCase(Locale.ROOT));
    }

    public static Float getTextureID(String text) {
        return MODEL_ID_MAP.getOrDefault(text.toLowerCase(Locale.ROOT), Float.valueOf(Float.NEGATIVE_INFINITY));
    }

    private static class TextureInstance
    implements AutoCloseable {
        private final class_2960 textureLocation;
        private final class_1043 texture;
        private final class_1921 renderType;
        private final class_2960 dimensionId;
        private final boolean sepia;

        private TextureInstance(class_1937 world, boolean sepia) {
            this.sepia = sepia;
            this.dimensionId = world.method_27983().method_29177();
            RenderUtil.setDynamicTexturesToUseMipmap((boolean)true);
            this.texture = new class_1043(32, 16, false);
            RenderUtil.setDynamicTexturesToUseMipmap((boolean)false);
            this.updateTexture(world);
            this.textureLocation = class_310.method_1551().method_1531().method_4617("globe/" + this.dimensionId.toString().replace(":", "_"), this.texture);
            this.renderType = RenderUtil.getEntitySolidMipmapRenderType((class_2960)this.textureLocation);
        }

        private void updateTexture(class_1937 world) {
            GlobeData data = GlobeData.get(world);
            if (data == null) {
                return;
            }
            byte[][] pixels = data.getPixels();
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 32; ++j) {
                    this.texture.method_4525().method_4305(j, i, -13061505);
                }
            }
            for (int y = 0; y < pixels.length; ++y) {
                for (int x = 0; x < pixels[y].length; ++x) {
                    this.texture.method_4525().method_4305(y, x, TextureInstance.getRGBA(pixels[y][x], this.dimensionId, this.sepia));
                }
            }
            RenderUtil.setDynamicTexturesToUseMipmap((boolean)true);
            this.texture.method_4524();
            RenderUtil.setDynamicTexturesToUseMipmap((boolean)false);
        }

        @Override
        public void close() {
            this.texture.close();
            class_310.method_1551().method_1531().method_4615(this.textureLocation);
        }

        private static int getRGBA(byte b, class_2960 dimension, boolean sepia) {
            if (sepia) {
                return SEPIA_COLORS.getInt((int)b);
            }
            IntList l = DIMENSION_COLOR_MAP.getOrDefault(dimension, DIMENSION_COLOR_MAP.get(class_2960.method_60656((String)"overworld")));
            if (l != null) {
                return l.getInt((int)b);
            }
            return 1;
        }
    }

    public static enum Type {
        FLAT(new String[]{"flat", "flat earth"}, (class_2561)class_2561.method_43471((String)"globe.supplementaries.flat"), ModTextures.GLOBE_FLAT_TEXTURE),
        MOON(new String[]{"moon", "luna", "selene", "cynthia"}, (class_2561)class_2561.method_43471((String)"globe.supplementaries.moon"), ModTextures.GLOBE_MOON_TEXTURE),
        EARTH(new String[]{"earth", "terra", "gaia", "gaea", "tierra", "tellus", "terre"}, (class_2561)class_2561.method_43471((String)"globe.supplementaries.earth"), ModTextures.GLOBE_TEXTURE),
        SUN(new String[]{"sun", "sol", "helios"}, (class_2561)class_2561.method_43471((String)"globe.supplementaries.sun"), ModTextures.GLOBE_SUN_TEXTURE);

        private final String[] keyWords;
        private final class_2561 transKeyWord;
        private final class_2960 texture;

        private Type(String[] key, class_2561 tr, class_2960 res) {
            this.keyWords = key;
            this.transKeyWord = tr;
            this.texture = res;
        }

        public class_2960 getTexture() {
            return this.texture;
        }
    }

    public static enum Model {
        GLOBE,
        FLAT,
        SNOW,
        SHEARED;

    }
}

