/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.cannon;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.mehvahdjukaar.supplementaries.client.cannon.CannonController;
import net.mehvahdjukaar.supplementaries.client.cannon.ShootingMode;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_9080;
import net.minecraft.class_9779;

public class CannonChargeHud
implements class_9080.class_9081 {
    public static final CannonChargeHud INSTANCE = new CannonChargeHud();
    protected final class_310 mc = class_310.method_1551();

    protected CannonChargeHud() {
    }

    public void render(class_332 graphics, class_9779 deltaTracker) {
        if (!this.mc.field_1690.field_1842 && CannonController.isActive()) {
            this.setupOverlayRenderState();
            CannonBlockTile cannon = CannonController.cannon;
            int screenWidth = graphics.method_51421();
            int screenHeight = graphics.method_51443();
            this.renderHotBar(graphics, screenWidth, screenHeight, cannon);
            CannonChargeHud.renderCrossHair(graphics, screenWidth, screenHeight);
            this.renderBar(graphics, screenWidth, screenHeight, cannon, deltaTracker.method_60637(false));
            CannonChargeHud.renderTrajectoryIcons(graphics, screenWidth, screenHeight);
        }
    }

    private static void renderTrajectoryIcons(class_332 graphics, int screenWidth, int screenHeight) {
        int iconLeft = screenWidth / 2 + 96;
        int iconTop = screenHeight - 22;
        int iconW = 14;
        class_2960 tr = switch (CannonController.shootingMode.ordinal()) {
            case 0 -> ModTextures.CANNON_TRAJECTORY_0_SPRITE;
            case 1 -> ModTextures.CANNON_TRAJECTORY_1_SPRITE;
            default -> ModTextures.CANNON_TRAJECTORY_2_SPRITE;
        };
        graphics.method_52706(tr, iconLeft, iconTop, iconW, iconW);
        iconLeft = screenWidth / 2 - 110;
        class_2960 tr2 = CannonController.showsTrajectory ? ModTextures.CANNON_TRAJECTORY_SHOWN_SPRITE : ModTextures.CANNON_TRAJECTORY_HIDDEN_SPRITE;
        graphics.method_52706(tr2, iconLeft, iconTop, iconW, iconW);
    }

    private void renderHotBar(class_332 graphics, int screenWidth, int screenHeight, CannonBlockTile cannon) {
        int left = screenWidth / 2 - 91;
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, -90.0f);
        graphics.method_52706(ModTextures.CANNON_HOTBAR_SPRITE, left, screenHeight - 22, 182, 22);
        graphics.method_51448().method_22909();
        class_746 player = class_310.method_1551().field_1724;
        int yPos = screenHeight - 16 - 3;
        this.renderSlot(graphics, left + 1 + 47 + 2, yPos, (class_1657)player, cannon.getProjectile(), 1);
        this.renderSlot(graphics, left + 1 + 113 + 2, yPos, (class_1657)player, cannon.getFuel(), 1);
    }

    private void renderBar(class_332 graphics, int screenWidth, int screenHeight, CannonBlockTile cannon, float partialTicks) {
        int xpBarLeft = screenWidth / 2 - 91;
        float c = 1.0f - cannon.getCooldownAnimation(partialTicks);
        int k = (int)(c * 183.0f);
        int xpBarTop = screenHeight - 32 + 3;
        graphics.method_52706(ModTextures.CANNON_CHARGE_BACKGROUND_SPRITE, xpBarLeft, xpBarTop, 182, 5);
        float f = cannon.getFiringAnimation(partialTicks);
        float min = 0.7f;
        if (f > 0.0f) {
            f = 1.0f - f;
            float red = f * 0.4f + min;
            float green = min - f * 0.4f * min;
            float blue = min;
            RenderSystem.setShaderColor((float)red, (float)green, (float)(min - f * blue), (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)min, (float)min, (float)min, (float)1.0f);
        }
        graphics.method_52708(ModTextures.CANNON_CHARGE_PROGRESS_SPRITE, 183, 5, 0, 0, xpBarLeft, xpBarTop, k, 5);
        byte power = CannonController.cannon.getPowerLevel();
        int color = switch (power) {
            case 2 -> 0xFFAA00;
            case 3 -> 0xFF8800;
            case 4 -> 0xFF6600;
            default -> 0xFFCC00;
        };
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String s = String.valueOf(power);
        int i1 = (screenWidth - this.mc.field_1772.method_1727(s)) / 2;
        int j1 = screenHeight - 31 - 4;
        graphics.method_51433(this.mc.field_1772, s, i1 + 1, j1, 0, false);
        graphics.method_51433(this.mc.field_1772, s, i1 - 1, j1, 0, false);
        graphics.method_51433(this.mc.field_1772, s, i1, j1 + 1, 0, false);
        graphics.method_51433(this.mc.field_1772, s, i1, j1 - 1, 0, false);
        graphics.method_51433(this.mc.field_1772, s, i1, j1, color, false);
    }

    private static void renderCrossHair(class_332 graphics, int screenWidth, int screenHeight) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, -90.0f);
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        int w = 9;
        class_2960 hitType = CannonController.shootingMode == ShootingMode.STRAIGHT ? ModTextures.CANNON_CROSSHAIR_AIM_SPRITE : (CannonController.trajectory == null || CannonController.trajectory.miss() ? ModTextures.CANNON_CROSSHAIR_MISS_SPRITE : ModTextures.CANNON_CROSSHAIR_HIT_SPRITE);
        graphics.method_52706(hitType, (screenWidth - w) / 2, (screenHeight - w) / 2, w, w);
        RenderSystem.defaultBlendFunc();
        graphics.method_51448().method_22909();
    }

    public void setupOverlayRenderState() {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(class_757::method_34542);
    }

    private void renderSlot(class_332 guiGraphics, int x, int y, class_1657 player, class_1799 itemStack, int seed) {
        if (!itemStack.method_7960()) {
            guiGraphics.method_51423((class_1309)player, itemStack, x, y, seed);
            guiGraphics.method_51431(this.mc.field_1772, itemStack, x, y);
        }
    }
}

