/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.client.hud.fabric.SelectableContainerItemHudImpl;
import net.mehvahdjukaar.supplementaries.common.items.SelectableContainerItem;
import net.mehvahdjukaar.supplementaries.common.items.components.SelectableContainerContent;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundCycleSelectableContainerItemPacket;
import net.mehvahdjukaar.supplementaries.common.utils.IQuiverPlayer;
import net.mehvahdjukaar.supplementaries.common.utils.SlotReference;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_8710;
import net.minecraft.class_9080;
import net.minecraft.class_9779;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SelectableContainerItemHud
implements class_9080.class_9081 {
    public static SelectableContainerItemHud INSTANCE = SelectableContainerItemHud.makeInstance();
    protected final class_310 mc;
    @Nullable
    private SelectableContainerItem<?, ?> itemUsed;
    private SlotReference stackSlot;
    private boolean usingKey = false;
    private double lastCumulativeMouseDx = 0.0;

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SelectableContainerItemHud makeInstance() {
        return SelectableContainerItemHudImpl.makeInstance();
    }

    protected SelectableContainerItemHud(class_310 minecraft) {
        this.mc = minecraft;
    }

    public boolean isActive() {
        return this.itemUsed != null;
    }

    public boolean isUsingKey() {
        return this.itemUsed != null && this.usingKey;
    }

    public boolean isUsingItem() {
        return this.itemUsed != null && !this.usingKey;
    }

    public void setUsingItem(SlotReference slot, class_1309 player) {
        SelectableContainerItem selectable;
        this.stackSlot = slot;
        class_1792 class_17922 = slot.getItem(player);
        this.itemUsed = class_17922 instanceof SelectableContainerItem ? (selectable = (SelectableContainerItem)class_17922) : null;
    }

    public void setUsingKeybind(SlotReference slot, class_1657 player) {
        this.setUsingItem(slot, (class_1309)player);
        this.usingKey = this.itemUsed != null;
    }

    private void closeHud() {
        this.itemUsed = null;
        this.usingKey = false;
        this.stackSlot = SlotReference.EMPTY;
    }

    public boolean onMouseScrolled(double scrollDelta) {
        if (this.itemUsed != null) {
            int amount = scrollDelta > 0.0 ? -1 : 1;
            this.sendCycle(amount);
            return true;
        }
        return false;
    }

    public void ohMouseMoved(double deltaX) {
        if (this.itemUsed != null && ClientConfigs.Items.QUIVER_MOUSE_MOVEMENT.get().booleanValue()) {
            class_746 player;
            double scale = (Double)this.mc.field_1690.method_42495().method_41753() * 0.02;
            int oldI = (int)(this.lastCumulativeMouseDx * scale);
            this.lastCumulativeMouseDx += deltaX;
            int slotsMoved = (int)(this.lastCumulativeMouseDx * scale) - oldI;
            if (slotsMoved != 0 && (player = this.mc.field_1724) != null) {
                this.sendCycle(slotsMoved);
            }
        }
    }

    private void sendCycle(int slotsMoved) {
        class_1799 stack = this.getItemUsed();
        if (!stack.method_7960() && this.itemUsed != null) {
            NetworkHelper.sendToServer((class_8710)new ServerBoundCycleSelectableContainerItemPacket(slotsMoved, this.stackSlot));
            this.itemUsed.modify(stack, m -> {
                m.cycle(slotsMoved);
                return true;
            });
        }
    }

    private void sendSetSlot(int number) {
        class_1799 stack = this.getItemUsed();
        if (!stack.method_7960() && this.itemUsed != null) {
            NetworkHelper.sendToServer((class_8710)new ServerBoundCycleSelectableContainerItemPacket(number, this.stackSlot, true));
            this.itemUsed.modify(stack, m -> {
                m.setSelectedSlot(number);
                return true;
            });
        }
    }

    public boolean onKeyPressed(int key, int action, int modifiers) {
        if (this.itemUsed == null) {
            return false;
        }
        if (action != 1) {
            return false;
        }
        switch (key) {
            case 263: {
                this.sendCycle(-1);
                return true;
            }
            case 262: {
                this.sendCycle(1);
                return true;
            }
        }
        int number = key - 48;
        if (number >= 1 && number <= 9) {
            if (number <= this.itemUsed.getMaxSlots()) {
                this.sendSetSlot(number - 1);
            }
            return true;
        }
        return false;
    }

    @NotNull
    private class_1799 getItemUsed() {
        class_746 player = this.mc.field_1724;
        if (this.itemUsed == null) {
            return class_1799.field_8037;
        }
        class_1799 stack = this.stackSlot.get((class_1309)player);
        if (!stack.method_31574(this.itemUsed)) {
            return class_1799.field_8037;
        }
        return stack;
    }

    public void render(class_332 graphics, class_9779 arg2) {
        class_1792 class_17922;
        boolean keyDown;
        if (this.itemUsed == null) {
            return;
        }
        if (!(this.mc.method_1560() instanceof IQuiverPlayer)) {
            this.closeHud();
            return;
        }
        if (this.isUsingKey() && !ClientRegistry.QUIVER_KEYBIND.method_1415() && !(keyDown = class_3675.method_15987((long)this.mc.method_22683().method_4490(), (int)ClientRegistry.QUIVER_KEYBIND.field_1655.method_1444()))) {
            this.closeHud();
            return;
        }
        class_1799 stack = this.getItemUsed();
        if (stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof SelectableContainerItem)) {
            this.closeHud();
            return;
        }
        SelectableContainerItem sc = (SelectableContainerItem)class_17922;
        SelectableContainerContent data = (SelectableContainerContent)stack.method_57824(sc.getComponentType());
        if (data == null) {
            this.closeHud();
            return;
        }
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        int selected = data.getSelectedSlot();
        List<class_1799> items = data.getContentUnsafe();
        int slots = items.size();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int centerX = graphics.method_51421() / 2;
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, -90.0f);
        int uWidth = slots * 20 + 2;
        int px = uWidth / 2;
        int py = graphics.method_51443() / 2 - 40;
        graphics.method_52708(ModTextures.SELECTABLE_ITEM_BAR, 182, 22, 0, 0, centerX - (px += ClientConfigs.Items.QUIVER_GUI_X.get().intValue()), py += ClientConfigs.Items.QUIVER_GUI_Y.get().intValue(), uWidth - 1, 22);
        graphics.method_52708(ModTextures.SELECTABLE_ITEM_BAR, 182, 22, 181, 0, centerX + px - 1, py, 1, 22);
        graphics.method_52706(ModTextures.SELECTABLE_ITEM_OVERLAY, centerX - px - 1 + selected * 20, py - 1, 24, 24);
        poseStack.method_22909();
        int i1 = 1;
        for (int i = 0; i < slots; ++i) {
            int kx = centerX - px + 3 + i * 20;
            this.renderSlot(graphics, kx, py + 3, items.get(i), i1++, this.mc.field_1772);
        }
        RenderSystem.disableBlend();
        class_1799 selectedArrow = items.get(selected);
        if (!selectedArrow.method_7960()) {
            this.drawHighlight(graphics, graphics.method_51421(), py, selectedArrow);
        }
        poseStack.method_22909();
    }

    private void renderSlot(class_332 graphics, int pX, int pY, class_1799 pStack, int seed, class_327 font) {
        if (!pStack.method_7960()) {
            graphics.method_51428(pStack, pX, pY, seed);
            RenderSystem.setShader(class_757::method_34540);
            graphics.method_51431(font, pStack, pX, pY);
        }
    }

    protected abstract void drawHighlight(class_332 var1, int var2, int var3, class_1799 var4);
}

