/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.client.SpriteCoordinateUnExpander;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BookPileBlock;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.BookType;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.PlaceableBookManager;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.mehvahdjukaar.supplementaries.integration.EnchantRedesignCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1751;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class BookPileBlockTile
extends ItemDisplayTile
implements IExtraModelDataProvider {
    public final boolean horizontal;
    private float enchantPower = 0.0f;
    public final BooksList booksVisuals = new BooksList();
    public static final ModelDataKey<BooksList> BOOKS_KEY = ModBlockProperties.BOOKS_KEY;
    private static final class_5819 rand = class_5819.method_43047();
    public static final List<String> DEFAULT_COLORS = List.of("brown", "orange", "yellow", "red", "green", "lime", "cyan", "blue", "purple");

    public BookPileBlockTile(class_2338 pos, class_2680 state) {
        this(pos, state, false);
    }

    public BookPileBlockTile(class_2338 pos, class_2680 state, boolean horizontal) {
        super(ModRegistry.BOOK_PILE_TILE.get(), pos, state, 4);
        this.horizontal = horizontal;
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        builder.with(BOOKS_KEY, (Object)this.booksVisuals);
    }

    private void displayRandomColoredBooks(int i, class_7225.class_7874 provider) {
        for (int j = 0; j < i; ++j) {
            int r = rand.method_43048(10);
            class_1792 it = r < 2 ? class_1802.field_8598 : (r < 3 ? class_1802.field_8674 : class_1802.field_8529);
            List<BookType> col = ((PlaceableBookManager)((Object)PlaceableBookManager.INSTANCES.get(provider))).getForItem(it.method_7854(), this.horizontal);
            this.booksVisuals.add(new VisualBook(it.method_7854(), this.field_11867, j, col, null, (class_7225.class_7874)this.field_11863.method_30349(), this.horizontal));
        }
    }

    public void method_11007(class_2487 compound, class_7225.class_7874 registries) {
        super.method_11007(compound, registries);
        compound.method_10548("EnchantPower", this.enchantPower);
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.enchantPower = tag.method_10583("EnchantPower");
        if (this.field_11863 != null && this.field_11863.field_9236) {
            this.requestModelReload();
        }
    }

    public void method_5447(int slot, class_1799 stack) {
        super.method_5447(slot, stack);
        int b = (int)this.method_11282().stream().filter(i -> !i.method_7960()).count();
        if (b != (Integer)this.method_11010().method_11654((class_2769)BookPileBlock.BOOKS) && b == 0) {
            if (this.field_12037 == null) {
                this.field_11863.method_8650(this.field_11867, false);
            } else {
                return;
            }
        }
        this.enchantPower = 0.0f;
        for (int i2 = 0; i2 < 4; ++i2) {
            class_1799 itemStack = this.method_5438(i2);
            if (itemStack.method_7960()) continue;
            class_1792 item = itemStack.method_7909();
            this.enchantPower = CompatHandler.QUARK && CompatObjects.TOME.get() == item ? (float)((double)this.enchantPower + CommonConfigs.Tweaks.BOOK_POWER.get() / 4.0 * 2.0) : (item == class_1802.field_8598 ? (float)((double)this.enchantPower + CommonConfigs.Tweaks.ENCHANTED_BOOK_POWER.get() / 4.0) : (float)((double)this.enchantPower + CommonConfigs.Tweaks.BOOK_POWER.get() / 4.0));
        }
    }

    public void updateTileOnInventoryChanged() {
        super.updateTileOnInventoryChanged();
    }

    private void consolidateBookPile() {
        boolean prevEmpty = false;
        for (int i = 0; i < 4; ++i) {
            class_1799 it = this.method_5438(i);
            if (it.method_7960()) {
                prevEmpty = true;
                continue;
            }
            if (!prevEmpty) continue;
            this.method_11282().set(i - 1, (Object)it);
            this.method_11282().set(i, (Object)class_1799.field_8037);
        }
    }

    public void updateClientVisualsOnLoad() {
        this.booksVisuals.clear();
    }

    public float getEnchantPower() {
        return this.enchantPower;
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"block.supplementaries.book_pile");
    }

    public boolean method_49104(class_1263 container, int i, class_1799 itemStack) {
        return false;
    }

    public boolean method_5437(int index, class_1799 stack) {
        return false;
    }

    public boolean method_17489(class_1657 player) {
        return false;
    }

    @Nullable
    public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
        return null;
    }

    public record BooksList(List<VisualBook> books) {
        public BooksList() {
            this(new ArrayList<VisualBook>());
        }

        public void add(VisualBook visualBook) {
            this.books.add(visualBook);
        }

        public void add(int i, VisualBook visualBook) {
            this.books.add(i, visualBook);
        }

        public void clear() {
            this.books.clear();
        }

        public boolean isEmpty() {
            return this.books.isEmpty();
        }

        public VisualBook get(int i) {
            return this.books.get(i);
        }

        public int size() {
            return this.books.size();
        }
    }

    public static class VisualBook {
        private final float yAngle;
        private final BookType type;
        private final class_1799 stack;

        public VisualBook(class_1799 bookStack, class_2338 pos, int index, List<BookType> colors, @Nullable BookType lastColor, class_7225.class_7874 provider, boolean isHorizontal) {
            PlaceableBookManager bookReg = (PlaceableBookManager)((Object)PlaceableBookManager.INSTANCES.get(provider));
            this.stack = bookStack;
            Random rand = new Random(pos.method_10087(2).method_10063());
            for (int j = 0; j < index; ++j) {
                rand.nextInt();
            }
            class_1792 item = bookStack.method_7909();
            this.yAngle = (float)((double)rand.nextInt(32) * Math.PI / 16.0);
            if (item instanceof class_1751) {
                if (lastColor == null) {
                    if (colors.isEmpty()) {
                        Supplementaries.error();
                        this.type = bookReg.getByName(class_2960.method_60654((String)"brown"));
                        return;
                    }
                    this.type = colors.get(rand.nextInt(colors.size()));
                } else {
                    List<BookType> c = colors.stream().filter(b -> b.looksGoodNextTo(lastColor)).toList();
                    if (c.isEmpty()) {
                        Supplementaries.error();
                        this.type = lastColor;
                    } else {
                        this.type = c.get(rand.nextInt(c.size()));
                    }
                }
                colors.remove(this.type);
            } else {
                List<BookType> possibleTypes = bookReg.getForItem(bookStack, isHorizontal);
                if (possibleTypes.isEmpty()) {
                    Supplementaries.error();
                    this.type = bookReg.getByName(class_2960.method_60654((String)"brown"));
                    return;
                }
                this.type = possibleTypes.get(rand.nextInt(possibleTypes.size()));
            }
        }

        public class_4588 getBuilder(class_4597 buffer) {
            if (this.type.hasGlint() && ClientConfigs.Tweaks.BOOK_GLINT.get().booleanValue()) {
                class_4588 foilBuilder = null;
                if (CompatHandler.ENCHANTEDBOOKREDESIGN) {
                    foilBuilder = EnchantRedesignCompat.getBookColoredFoil(this.stack, buffer);
                }
                if (foilBuilder == null) {
                    foilBuilder = new SpriteCoordinateUnExpander(buffer.getBuffer(class_1921.method_23591()), ModMaterials.BOOK_GLINT_MATERIAL.method_24148());
                }
                return foilBuilder;
            }
            return null;
        }

        public float getAngle() {
            return this.yAngle;
        }

        public BookType getType() {
            return this.type;
        }
    }
}

