/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.LongStream;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5632;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9299;

public class BlackboardData
implements class_5632,
class_9299 {
    private static final class_2561 WAXED_TOOLTIP = class_2561.method_43471((String)"message.supplementaries.blackboard").method_27692(class_124.field_1080);
    public static final Codec<BlackboardData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG_STREAM.fieldOf("values").xmap(LongStream::toArray, Arrays::stream).forGetter(v -> v.values), (App)Codec.BOOL.fieldOf("glow").forGetter(v -> v.glow), (App)Codec.BOOL.fieldOf("waxed").forGetter(v -> v.waxed)).apply((Applicative)instance, BlackboardData::new));
    public static final class_9139<class_9129, long[]> LONG_ARRAY = new class_9139<class_9129, long[]>(){

        public long[] decode(class_9129 buffer) {
            int size = buffer.readByte();
            long[] values = new long[size];
            for (int i = 0; i < size; ++i) {
                values[i] = buffer.readLong();
            }
            return values;
        }

        public void encode(class_9129 buffer, long[] value) {
            buffer.method_52997(value.length);
            for (long l : value) {
                buffer.method_52974(l);
            }
        }
    };
    public static final class_9139<class_9129, BlackboardData> STREAM_CODEC = class_9139.method_56436(LONG_ARRAY, data -> data.values, (class_9139)class_9135.field_48547, data -> data.glow, (class_9139)class_9135.field_48547, data -> data.waxed, BlackboardData::new);
    public static final BlackboardData DEFAULT = new BlackboardData(new long[16], false, false);
    private final long[] values;
    private final boolean glow;
    private final boolean waxed;

    BlackboardData(long[] packed, boolean glowing, boolean waxed) {
        this.values = packed;
        this.glow = glowing;
        this.waxed = waxed;
    }

    public static BlackboardData pack(byte[][] pixels, boolean glowing, boolean waxed) {
        return new BlackboardData(BlackboardData.packPixels(pixels), glowing, waxed);
    }

    public static BlackboardData of(long[] packPixels, boolean glowing, boolean waxed) {
        return new BlackboardData(packPixels, glowing, waxed);
    }

    public boolean equals(Object another) {
        if (another == this) {
            return true;
        }
        if (another == null) {
            return false;
        }
        if (another.getClass() != this.getClass()) {
            return false;
        }
        BlackboardData key = (BlackboardData)another;
        return Arrays.equals(this.values, key.values) && this.glow == key.glow;
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> tooltipAdder, class_1836 tooltipFlag) {
        if (this.waxed) {
            tooltipAdder.accept(WAXED_TOOLTIP);
        }
    }

    public byte[][] unpackPixels() {
        return BlackboardData.unpackPixels(this.values);
    }

    public boolean waxed() {
        return this.waxed;
    }

    public boolean isGlow() {
        return this.glow;
    }

    public static long[] packPixels(byte[][] pixels) {
        long[] packed = new long[pixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            long l = 0L;
            for (int j = 0; j < pixels[i].length; ++j) {
                l |= (long)(pixels[i][j] & 0xF) << j * 4;
            }
            packed[i] = l;
        }
        return packed;
    }

    public static byte[][] unpackPixels(long[] packed) {
        byte[][] bytes = new byte[16][16];
        for (int i = 0; i < packed.length; ++i) {
            for (int j = 0; j < 16; ++j) {
                bytes[i][j] = (byte)(packed[i] >> j * 4 & 0xFL);
            }
        }
        return bytes;
    }

    public static long[] unpackPixelsFromStringWhiteOnly(String packed) {
        long[] unpacked = new long[16];
        char[] chars = packed.toCharArray();
        int j = 0;
        int i = 0;
        while (i + 3 < chars.length) {
            long l = 0L;
            char c = chars[i];
            for (int k = 0; k < 4; ++k) {
                l |= (long)((c >> k & 1) << 4 * k);
            }
            char c2 = chars[i + 1];
            for (int k = 0; k < 4; ++k) {
                l |= (long)(c2 >> k & 1) << 16 + 4 * k;
            }
            char c3 = chars[i + 2];
            for (int k = 0; k < 4; ++k) {
                l |= (long)(c3 >> k & 1) << 32 + 4 * k;
            }
            char c4 = chars[i + 3];
            for (int k = 0; k < 4; ++k) {
                l |= (long)(c4 >> k & 1) << 48 + 4 * k;
            }
            unpacked[j] = l;
            ++j;
            i += 4;
        }
        return unpacked;
    }

    public static String packPixelsToStringWhiteOnly(long[] packed) {
        StringBuilder builder = new StringBuilder();
        for (long l : packed) {
            char c = '\u0000';
            for (int k = 0; k < 4; ++k) {
                byte h = (byte)(l >> 4 * k & 1L);
                c = (char)(c | h << k);
            }
            char c1 = '\u0000';
            for (int k = 0; k < 4; ++k) {
                byte h = (byte)(l >> 16 + 4 * k & 1L);
                c1 = (char)(c1 | h << k);
            }
            char c2 = '\u0000';
            for (int k = 0; k < 4; ++k) {
                byte h = (byte)(l >> 32 + 4 * k & 1L);
                c2 = (char)(c2 | h << k);
            }
            char c3 = '\u0000';
            for (int k = 0; k < 4; ++k) {
                byte h = (byte)(l >> 48 + 4 * k & 1L);
                c3 = (char)(c3 | h << k);
            }
            builder.append(c).append(c1).append(c2).append(c3);
        }
        return builder.toString();
    }

    public boolean isEmpty() {
        return false;
    }
}

