/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.mob_container;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.CapturedMobInstance;
import net.mehvahdjukaar.supplementaries.api.ICatchableMob;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.BucketHelper;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.CapturedMobHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1420;
import net.minecraft.class_1422;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3612;
import net.minecraft.class_4019;
import net.minecraft.class_4844;
import net.minecraft.class_5699;
import net.minecraft.class_5761;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7298;
import net.minecraft.class_9062;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobContainer {
    private final float width;
    private final float height;
    private final boolean isAquarium;
    @Nullable
    private MobData data;
    @Nullable
    private CapturedMobInstance<?> mobInstance;
    private ICatchableMob mobProperties;
    private boolean needsInitialization = false;

    public MobContainer(float width, float height, boolean isAquarium) {
        this.width = width;
        this.height = height;
        this.isAquarium = isAquarium;
    }

    public MobContainer makeCopy() {
        MobContainer container = new MobContainer(this.width, this.height, this.isAquarium);
        container.setData(this.data);
        return container;
    }

    public class_2487 save(class_2487 tag, class_7225.class_7874 registries) {
        if (this.data != null) {
            Object object;
            class_6903 ops = registries.method_57093((DynamicOps)class_2509.field_11560);
            RecordBuilder mapBuilder = ops.mapBuilder();
            MobData.CODEC.encode((Object)this.data, (DynamicOps)ops, mapBuilder);
            DataResult newTag = mapBuilder.build((Object)tag);
            if (newTag.isSuccess() && (object = newTag.getOrThrow()) instanceof class_2487) {
                class_2487 ct = (class_2487)object;
                tag.method_10543(ct);
            }
        }
        return tag;
    }

    public void load(class_2487 tag, class_7225.class_7874 registries) {
        class_6903 ops = registries.method_57093((DynamicOps)class_2509.field_11560);
        ops.getMap((Object)tag).ifSuccess(map -> MobData.CODEC.decode((DynamicOps)ops, map).ifSuccess(this::setData));
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public boolean isAquarium() {
        return this.isAquarium;
    }

    public void setData(@Nullable MobData data) {
        this.data = data;
        this.needsInitialization = true;
    }

    private void initializeEntity(class_1937 level, @Nullable class_2338 pos) {
        this.needsInitialization = false;
        if (this.data != null) {
            MobData mobData = this.data;
            if (mobData instanceof MobData.Bucket) {
                MobData.Bucket bucketData = (MobData.Bucket)mobData;
                type = BucketHelper.getEntityTypeFromBucket(bucketData.filledBucket.method_7909());
                this.mobProperties = CapturedMobHandler.getInstance((class_7225.class_7874)level.method_30349()).getDataCap(type, true);
            } else {
                MobData.Entity entityData;
                class_1297 entity;
                type = this.data;
                if (type instanceof MobData.Entity && (entity = MobContainer.createStaticMob(entityData = (MobData.Entity)type, level, pos == null ? class_2338.field_10980 : pos)) != null) {
                    this.mobProperties = CapturedMobHandler.getInstance(level).getCatchableMobCapOrDefault(entity);
                    this.mobInstance = this.mobProperties.createCapturedMobInstance(entity, this.width, this.height);
                    if (pos != null) {
                        this.mobInstance.onContainerWaterlogged(level.method_8316(pos).method_15772() != class_3612.field_15906, this.width, this.height);
                        if (!level.field_9236) {
                            this.updateLightLevel(level, pos);
                        }
                    }
                }
            }
        }
    }

    public void updateLightLevel(class_1937 level, class_2338 pos) {
        int light = 0;
        if (level != null && !level.field_9236 && this.data != null) {
            class_2680 state;
            if (this.mobProperties != null) {
                light = this.mobProperties.getLightLevel(level, pos);
            }
            if ((Integer)(state = level.method_8320(pos)).method_11654((class_2769)ModBlockProperties.LIGHT_LEVEL_0_15) != light) {
                level.method_8652(pos, (class_2680)state.method_11657((class_2769)ModBlockProperties.LIGHT_LEVEL_0_15, (Comparable)Integer.valueOf(light)), 22);
            }
        }
    }

    @Nullable
    public static class_1297 createStaticMob(MobData.Entity data, @NotNull class_1937 world, class_2338 pos) {
        class_1297 entity = null;
        if (data != null) {
            entity = MobContainer.createEntityFromNBT(data.mobTag, data.uuid, world);
            if (entity == null) {
                return null;
            }
            double px = (double)pos.method_10263() + entity.method_23317();
            double py = (double)pos.method_10264() + entity.method_23318();
            double pz = (double)pos.method_10260() + entity.method_23321();
            entity.method_5814(px, py, pz);
            entity.field_6038 = px;
            entity.field_5971 = py;
            entity.field_5989 = pz;
            entity.field_6014 = px;
            entity.field_6036 = py;
            entity.field_5969 = pz;
        }
        return entity;
    }

    @Nullable
    public static class_1297 createEntityFromNBT(class_2487 tag, @Nullable UUID id, class_1937 world) {
        if (tag != null && tag.method_10545("id")) {
            class_1297 entity = class_1299.method_17842((class_2487)tag, (class_1937)world, o -> o);
            if (id != null && entity != null) {
                entity.method_5826(id);
                if (entity.method_16914()) {
                    entity.method_5665(entity.method_5797());
                }
            }
            return entity;
        }
        return null;
    }

    public boolean interactWithBucket(class_1799 stack, class_1937 world, class_2338 pos, @Nullable class_1657 player, class_1268 hand) {
        class_1792 item = stack.method_7909();
        class_1799 returnStack = class_1799.field_8037;
        if (this.isEmpty()) {
            if (BucketHelper.isFishBucket(item)) {
                world.method_8396(null, pos, class_3417.field_14912, class_3419.field_15245, 1.0f, 1.0f);
                returnStack = new class_1799((class_1935)class_1802.field_8550);
                class_1299<?> type = BucketHelper.getEntityTypeFromBucket(stack.method_7909());
                ICatchableMob cap = CapturedMobHandler.getInstance(world).getDataCap(type, true);
                Optional<class_6880<SoftFluid>> f = cap.getForceFluid();
                if (stack.method_7960()) {
                    Supplementaries.LOGGER.error("Bucket error 3: name none, bucket {}", (Object)stack);
                }
                MobData.Bucket data = new MobData.Bucket(Optional.empty(), stack.method_7972(), cap.getFishTextureIndex(), f);
                this.setData(data);
            }
        } else if (item == class_1802.field_8550) {
            class_1799 bucket;
            Object temp;
            MobData cap = this.data;
            if (cap instanceof MobData.Bucket) {
                MobData.Bucket bucketData = (MobData.Bucket)cap;
                world.method_8396(null, pos, class_3417.field_14568, class_3419.field_15245, 1.0f, 1.0f);
                returnStack = bucketData.filledBucket.method_7972();
                this.setData(null);
            } else if (this.data instanceof MobData.Entity && this.mobInstance != null && (temp = this.mobInstance.getEntityForRenderer()) != null && !(bucket = BucketHelper.getBucketFromEntity(temp)).method_7960()) {
                world.method_8396(null, pos, class_3417.field_14568, class_3419.field_15245, 1.0f, 1.0f);
                returnStack = bucket.method_7972();
                this.setData(null);
            }
        }
        if (!returnStack.method_7960()) {
            if (player != null) {
                player.method_7259(class_3468.field_15372.method_14956((Object)item));
                if (!player.method_7337()) {
                    Utils.swapItem((class_1657)player, (class_1268)hand, (class_1799)returnStack);
                }
            }
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.data == null;
    }

    public void tick(class_1937 pLevel, class_2338 pPos) {
        MobData mobData;
        if (this.needsInitialization) {
            this.initializeEntity(pLevel, pPos);
        }
        if (this.mobInstance != null && (mobData = this.data) instanceof MobData.Entity) {
            MobData.Entity entityData = (MobData.Entity)mobData;
            this.mobInstance.containerTick(pLevel, pPos, entityData.scale, entityData.mobTag);
        }
    }

    public class_9062 onInteract(class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 stack) {
        MobData mobData;
        if (this.mobInstance != null && (mobData = this.data) instanceof MobData.Entity) {
            MobData.Entity entityData = (MobData.Entity)mobData;
            return this.mobInstance.onPlayerInteract(world, pos, player, hand, stack, entityData.mobTag);
        }
        return class_9062.field_47731;
    }

    @Nullable
    public MobData getData() {
        return this.data;
    }

    @Nullable
    public class_1297 getDisplayedMob(class_1937 level, @Nullable class_2338 pos) {
        if (this.needsInitialization) {
            this.initializeEntity(level, pos);
        }
        if (this.mobInstance != null) {
            return this.mobInstance.getEntityForRenderer();
        }
        return null;
    }

    public Optional<class_6880<SoftFluid>> shouldRenderWithFluid() {
        if (this.data == null || !this.isAquarium || this.mobProperties == null) {
            return Optional.empty();
        }
        return this.mobProperties.getForceFluid();
    }

    public boolean captureEntity(class_1297 mob, class_1799 bucketStack) {
        MobData newData;
        String name = mob.method_5477().getString();
        ICatchableMob cap = CapturedMobHandler.getInstance(mob.method_37908()).getCatchableMobCapOrDefault(mob);
        if (this.isAquarium && !bucketStack.method_7960() && cap.renderAs2DFish()) {
            Optional<class_6880<SoftFluid>> f = cap.getForceFluid();
            if (bucketStack.method_7960()) {
                Supplementaries.LOGGER.error("Bucket error 2: name {}, bucket {}", (Object)name, (Object)bucketStack);
            }
            newData = new MobData.Bucket(Optional.of(name), bucketStack, cap.getFishTextureIndex(), f);
        } else {
            Pair<Float, Float> dimensions = MobContainer.calculateMobDimensionsForContainer(mob, this.width, this.height, this.isAquarium);
            float scale = ((Float)dimensions.getLeft()).floatValue();
            float yOffset = ((Float)dimensions.getRight()).floatValue();
            class_2487 mobTag = MobContainer.prepareMobTagForContainer(mob, yOffset);
            if (mobTag == null) {
                return false;
            }
            UUID id = mob.method_5667();
            newData = new MobData.Entity(name, mobTag, scale, id);
        }
        this.setData(newData);
        return true;
    }

    @Nullable
    private static class_2487 prepareMobTagForContainer(class_1297 entity, double yOffset) {
        class_1308 mob;
        double px = 0.5;
        double py = yOffset + 1.0E-4;
        double pz = 0.5;
        entity.method_5814(px, py, pz);
        entity.field_6038 = px;
        entity.field_5971 = py;
        entity.field_5989 = pz;
        if (entity.method_5765()) {
            entity.method_5854().method_5772();
        }
        if (entity instanceof class_1308 && !((mob = (class_1308)entity) instanceof class_7298) && entity instanceof class_5761) {
            mob.method_5971();
        }
        if (entity instanceof class_5761) {
            class_5761 bucketable = (class_5761)entity;
            bucketable.method_6454(true);
        }
        if (entity instanceof class_1309) {
            class_1309 le = (class_1309)entity;
            le.field_6259 = 0.0f;
            le.field_6241 = 0.0f;
            le.field_42108.method_48567(0.0f);
            le.field_42108.method_48568(-le.field_42108.method_48569(), 1.0f);
            le.field_42108.method_48567(0.0f);
            le.field_6254 = 0;
            le.field_6235 = 0;
            le.field_6251 = 0.0f;
        }
        entity.method_36456(0.0f);
        entity.field_5982 = 0.0f;
        entity.field_6004 = 0.0f;
        entity.method_36457(0.0f);
        entity.method_5646();
        entity.field_6008 = 0;
        if (entity instanceof class_1420) {
            class_1420 bat = (class_1420)entity;
            bat.method_6449(true);
        }
        if (entity instanceof class_4019) {
            class_4019 fox = (class_4019)entity;
            fox.method_18302(true);
        }
        if (entity instanceof class_1422) {
            class_1422 abstractFish = (class_1422)entity;
            abstractFish.method_6454(true);
        }
        class_2487 mobTag = new class_2487();
        entity.method_5662(mobTag);
        if (mobTag.method_33133()) {
            Supplementaries.LOGGER.error("failed to capture entity " + String.valueOf(entity) + "Something went wrong :/");
            return null;
        }
        mobTag.method_10551("Passengers");
        mobTag.method_10551("Leash");
        mobTag.method_10551("UUID");
        if (mobTag.method_10545("FromBucket")) {
            mobTag.method_10556("FromBucket", true);
        }
        if (mobTag.method_10545("FromPot")) {
            mobTag.method_10556("FromPot", true);
        }
        return mobTag;
    }

    public static Pair<Float, Float> calculateMobDimensionsForContainer(class_1297 mob, float blockW, float blockH, boolean waterlogged) {
        float yOffset;
        String name;
        class_1309 livingEntity;
        ICatchableMob cap = CapturedMobHandler.getInstance(mob.method_37908()).getCatchableMobCapOrDefault(mob);
        float babyScale = 1.0f;
        if (mob instanceof class_1309 && (livingEntity = (class_1309)mob).method_6109()) {
            babyScale = mob instanceof class_1646 ? 1.125f : (mob instanceof class_1296 ? 2.0f : 1.125f);
        }
        float scale = 1.0f;
        float w = mob.method_17681() * babyScale;
        float h = mob.method_17682() * babyScale;
        boolean isAir = cap.shouldHover(mob, waterlogged);
        float aW = w + cap.getHitBoxWidthIncrement(mob);
        float aH = h + cap.getHitBoxHeightIncrement(mob);
        float margin = 0.125f;
        float yMargin = 0.0625f;
        float maxH = blockH - 2.0f * (isAir ? margin : yMargin);
        float maxW = blockW - 2.0f * margin;
        if (aW > maxW || aH > maxH) {
            scale = aW - maxW > aH - maxH ? maxW / aW : maxH / aH;
        }
        if ((name = Utils.getID((class_1299)mob.method_5864()).toString()).equals("iceandfire:fire_dragon") || name.equals("iceandfire:ice_dragon") || name.equals("iceandfire:lightning_dragon")) {
            scale *= 0.45f;
        }
        float f = yOffset = isAir ? blockH / 2.0f - aH * scale / 2.0f : yMargin;
        if (mob instanceof class_1420) {
            yOffset *= 1.5f;
        }
        return new ImmutablePair((Object)Float.valueOf(scale), (Object)Float.valueOf(yOffset));
    }

    public void clear() {
        this.setData(null);
    }

    public static abstract class MobData {
        public static final MapCodec<MobData> CODEC = MapCodec.recursive((String)"mobData", s -> Codec.mapEither((MapCodec)Bucket.CODEC.fieldOf("MobHolder"), (MapCodec)Entity.CODEC.fieldOf("BucketHolder")).xmap(Either::unwrap, e -> e instanceof Bucket ? Either.left((Object)((Bucket)e)) : Either.right((Object)((Entity)e))));
        public static final class_9139<class_9129, MobData> STREAM_CODEC = class_9139.method_58024(s -> class_9135.method_57995(Bucket.STREAM_CODEC, Entity.STREAM_CODEC).method_56432(Either::unwrap, e -> {
            Either either;
            if (e instanceof Bucket) {
                Bucket b = (Bucket)e;
                either = Either.left((Object)b);
            } else {
                either = Either.right((Object)((Entity)e));
            }
            return either;
        }));
        protected final String name;
        protected final int fishTexture;
        @Nullable
        protected final class_6880<SoftFluid> visualFluid;

        private MobData(String name, int fishTexture, @Nullable class_6880<SoftFluid> fluidID) {
            this.name = name;
            this.fishTexture = fishTexture;
            this.visualFluid = fluidID;
        }

        public boolean is2DFish() {
            return this.fishTexture != 0;
        }

        public int getFishTexture() {
            return this.fishTexture;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        @Nullable
        public class_6880<SoftFluid> getVisualFluid() {
            return this.visualFluid;
        }

        public static class Bucket
        extends MobData {
            public static final Codec<Bucket> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("Name").forGetter(b -> Optional.ofNullable(b.name)), (App)class_1799.field_24671.fieldOf("Bucket").forGetter(b -> b.filledBucket), (App)class_5699.field_33441.optionalFieldOf("FishTexture", (Object)0).forGetter(MobData::getFishTexture), (App)SoftFluid.HOLDER_CODEC.optionalFieldOf("Fluid").forGetter(b -> Optional.ofNullable(b.visualFluid))).apply((Applicative)instance, Bucket::new)).validate(b -> {
                if (b.filledBucket.method_7960()) {
                    return DataResult.error(() -> "Bucket item cannot be empty");
                }
                return DataResult.success((Object)b);
            });
            public static final class_9139<class_9129, Bucket> STREAM_CODEC = class_9139.method_56905((class_9139)class_9135.method_56382((class_9139)class_9135.field_48554), b -> Optional.ofNullable(b.name), (class_9139)class_1799.field_48349, b -> b.filledBucket, (class_9139)class_9135.field_48550, MobData::getFishTexture, (class_9139)class_9135.method_56382((class_9139)SoftFluid.STREAM_CODEC), b -> Optional.ofNullable(b.visualFluid), Bucket::new);
            private final class_1799 filledBucket;

            protected Bucket(Optional<String> name, class_1799 filledBucket, int fishTexture, Optional<class_6880<SoftFluid>> fluidId) {
                super(Bucket.getDefaultName(name, filledBucket), fishTexture, (class_6880<SoftFluid>)((class_6880)fluidId.orElse(null)));
                this.filledBucket = filledBucket;
            }

            private static String getDefaultName(Optional<String> name, class_1799 filledBucket) {
                if (name.isEmpty()) {
                    class_1299<?> type = BucketHelper.getEntityTypeFromBucket(filledBucket.method_7909());
                    return type == null ? "Mob" : type.method_5882();
                }
                return name.get();
            }

            public class_1799 getBucket() {
                return this.filledBucket;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Bucket bucket = (Bucket)o;
                return Objects.equals(this.filledBucket, bucket.filledBucket);
            }

            public int hashCode() {
                return Objects.hashCode(this.filledBucket);
            }
        }

        public static class Entity
        extends MobData {
            public static final Codec<Entity> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("Name").forGetter(MobData::getName), (App)class_5699.field_33441.optionalFieldOf("FishTexture", (Object)0).forGetter(MobData::getFishTexture), (App)SoftFluid.HOLDER_CODEC.optionalFieldOf("Fluid").forGetter(e -> Optional.ofNullable(e.visualFluid)), (App)class_2487.field_25128.fieldOf("EntityData").forGetter(e -> e.mobTag), (App)Codec.FLOAT.fieldOf("Scale").forGetter(Entity::getScale), (App)class_4844.field_25122.fieldOf("UUID").forGetter(e -> e.uuid)).apply((Applicative)instance, Entity::new));
            public static final class_9139<class_9129, Entity> STREAM_CODEC = class_9139.method_58025((class_9139)class_9135.field_48554, MobData::getName, (class_9139)class_9135.field_48550, MobData::getFishTexture, (class_9139)class_9135.method_56382((class_9139)SoftFluid.STREAM_CODEC), e -> Optional.ofNullable(e.visualFluid), (class_9139)class_9135.field_48556, e -> e.mobTag, (class_9139)class_9135.field_48552, Entity::getScale, (class_9139)class_4844.field_48453, e -> e.uuid, Entity::new);
            private final class_2487 mobTag;
            private final float scale;
            @Nullable
            private final UUID uuid;

            protected Entity(String name, class_2487 tag, float scale, UUID uuid) {
                this(name, 0, Optional.empty(), tag, scale, uuid);
            }

            protected Entity(String name, int fishTexture, Optional<class_6880<SoftFluid>> visualFluid, class_2487 tag, float scale, UUID uuid) {
                super(name, fishTexture, (class_6880<SoftFluid>)((class_6880)visualFluid.orElse(null)));
                this.mobTag = tag;
                this.scale = scale;
                this.uuid = uuid;
            }

            public MobData copyWithNewUUID(UUID newUUID) {
                return new Entity(this.name, this.fishTexture, Optional.ofNullable(this.visualFluid), this.mobTag, this.scale, newUUID);
            }

            public float getScale() {
                return this.scale;
            }

            public class_2487 getTag() {
                return this.mobTag;
            }

            @Nullable
            public UUID getUuid() {
                return this.uuid;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Entity entity = (Entity)o;
                return Float.compare(this.scale, entity.scale) == 0 && Objects.equals(this.mobTag, entity.mobTag) && Objects.equals(this.uuid, entity.uuid);
            }

            public int hashCode() {
                return Objects.hash(this.mobTag, Float.valueOf(this.scale), this.uuid);
            }
        }
    }
}

