/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.tclayer.mixin;

import com.google.gson.JsonObject;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.logging.LogUtils;
import dev.emi.trinkets.api.TrinketEnums;
import dev.emi.trinkets.compat.WrappingTrinketsUtils;
import dev.emi.trinkets.data.SlotLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.tclayer.TCLayer;
import io.wispforest.tclayer.compat.config.SlotIdRedirect;
import it.unimi.dsi.fastutil.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SlotTypeLoader.class}, priority=1100)
public abstract class SlotTypeLoaderMixin {
    @Unique
    private final Logger LOGGER = LogUtils.getLogger();
    @Unique
    private final class_2960 EMPTY_TEXTURE = class_2960.method_60655((String)"trinkets", (String)"gui/slots/empty.png");

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="INVOKE", target="Ljava/util/HashMap;<init>()V", shift=At.Shift.AFTER, ordinal=2)})
    private void injectTrinketSpecificSlots(Map<class_2960, JsonObject> data, class_3300 resourceManager, class_3695 profiler, CallbackInfo ci, @Local(name={"builders"}) HashMap<String, SlotTypeLoader.SlotBuilder> builders) {
        Map<String, Pair<String, Integer>> redirects = SlotIdRedirect.getMap(TCLayer.CONFIG.slotIdRedirects());
        for (Map.Entry<String, SlotLoader.GroupData> groupDataEntry : SlotLoader.INSTANCE.getSlots().entrySet()) {
            String groupName = groupDataEntry.getKey();
            SlotLoader.GroupData groupData = groupDataEntry.getValue();
            Map<String, SlotLoader.SlotData> slots = groupData.slots;
            for (Map.Entry<String, SlotLoader.SlotData> entry : slots.entrySet()) {
                SlotTypeLoader.SlotBuilder builder;
                Pair<String, Integer> redirect = redirects.get(groupName + "/" + entry.getKey());
                String accessoryType = redirect != null ? (String)redirect.key() : WrappingTrinketsUtils.trinketsToAccessories_Slot(Optional.of(groupName), entry.getKey());
                SlotLoader.SlotData slotData = entry.getValue();
                if (builders.containsKey(accessoryType)) {
                    builder = builders.get(accessoryType);
                    Integer slotsCurrentSize = builder.baseAmount;
                    if (slotsCurrentSize != null && slotData.amount > slotsCurrentSize) {
                        builder.amount(slotData.amount);
                    }
                    if (redirect != null) {
                        builder.addAmount(((Integer)redirect.right()).intValue());
                    }
                } else {
                    builder = new SlotTypeLoader.SlotBuilder(accessoryType);
                    if (slotData.amount != -1) {
                        builder.amount(slotData.amount);
                    }
                    builder.order(Integer.valueOf(slotData.order));
                    class_2960 icon = class_2960.method_60654((String)slotData.icon);
                    if (!icon.equals((Object)this.EMPTY_TEXTURE)) {
                        builder.icon(icon);
                    }
                    builder.dropRule(TrinketEnums.convert(TrinketEnums.DropRule.valueOf(slotData.dropRule)));
                    builder.alternativeTranslation("trinkets.slot." + groupDataEntry.getKey() + "." + entry.getKey());
                    builders.put(accessoryType, builder);
                }
                for (String validatorPredicate : slotData.validatorPredicates) {
                    class_2960 location = class_2960.method_12829((String)validatorPredicate);
                    if (location == null) continue;
                    builder.validator(WrappingTrinketsUtils.trinketsToAccessories_Validators(location));
                }
            }
        }
    }
}

