/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client;

import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.client.ClientLifecycleEvents;
import io.wispforest.accessories.client.gui.ScreenVariantSelectionScreen;
import io.wispforest.accessories.client.gui.components.ComponentUtils;
import io.wispforest.accessories.compat.config.ScreenType;
import io.wispforest.accessories.compat.config.client.ExtendedConfigScreen;
import io.wispforest.accessories.compat.config.client.Structured;
import io.wispforest.accessories.compat.config.client.components.StructListOptionContainer;
import io.wispforest.accessories.compat.config.client.components.StructOptionContainer;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.impl.PlayerEquipControl;
import io.wispforest.accessories.menu.AccessoriesMenuVariant;
import io.wispforest.accessories.mixin.owo.ConfigWrapperAccessor;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.holder.HolderProperty;
import io.wispforest.accessories.networking.holder.SyncHolderChange;
import io.wispforest.accessories.networking.server.ScreenOpen;
import io.wispforest.endec.impl.ReflectiveEndecBuilder;
import io.wispforest.owo.config.ui.ConfigScreenProviders;
import io.wispforest.owo.config.ui.OptionComponentFactory;
import io.wispforest.owo.config.ui.component.OptionValueProvider;
import io.wispforest.owo.config.ui.component.SearchAnchorComponent;
import io.wispforest.owo.shader.GlProgram;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.layers.Layers;
import io.wispforest.owo.util.NumberReflection;
import io.wispforest.owo.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1041;
import net.minecraft.class_1058;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1761;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_5944;
import net.minecraft.class_746;
import org.joml.Vector2i;

public class AccessoriesClient {
    public static class_304 OPEN_SCREEN = null;
    public static final class_2960 BLIT_SHADER_ID = Accessories.of("fish");
    public static class_5944 BLIT_SHADER;
    public static GlProgram SPECTRUM_PROGRAM;
    public static final Event<WindowResizeCallback> WINDOW_RESIZE_CALLBACK_EVENT;
    public static boolean IS_PLAYER_INVISIBLE;
    private static boolean displayUnusedSlotWarning;

    public static void initConfigStuff() {
        ConfigScreenProviders.register((String)"accessories", ExtendedConfigScreen.buildFunc(Accessories.config(), (config, factoryRegister) -> {
            factoryRegister.registerFactory(option -> {
                Field field = option.backingField().field();
                if (field.getType() != List.class) {
                    return false;
                }
                Class listType = ReflectionUtils.getTypeArgument((Type)field.getGenericType(), (int)0);
                if (listType == null) {
                    return false;
                }
                return String.class != listType && !NumberReflection.isNumberType((Class)listType);
            }, (uiModel, option) -> {
                StructListOptionContainer layout = new StructListOptionContainer(uiModel, option);
                return new OptionComponentFactory.Result(layout, layout);
            });
            ReflectiveEndecBuilder builder = ((ConfigWrapperAccessor)config).accessories$builder();
            factoryRegister.registerFactory(option -> option.backingField().field().isAnnotationPresent(Structured.class), (model, option) -> {
                Structured annotationData = option.backingField().field().getAnnotation(Structured.class);
                class_5250 title = class_2561.method_43471((String)("text.config." + option.configName() + ".option." + option.key().asString()));
                FlowLayout titleLayout = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
                titleLayout.padding(Insets.of((int)5, (int)5, (int)5, (int)0));
                title = title.method_27661().method_27692(class_124.field_1073);
                titleLayout.child((Component)Components.label((class_2561)title));
                StructOptionContainer component = StructOptionContainer.of(model, option, builder, annotationData.sideBySide());
                titleLayout.child((Component)new SearchAnchorComponent((ParentComponent)titleLayout, option.key(), new Supplier[]{() -> class_1074.method_4662((String)("text.config." + option.configName() + ".option." + option.key().asString()), (Object[])new Object[0]), () -> component.parsedValue().toString()}));
                FlowLayout mainLayout = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
                mainLayout.child((Component)titleLayout).child((Component)component);
                return new OptionComponentFactory.Result((Component)mainLayout, (OptionValueProvider)component);
            });
        }));
        Accessories.config().clientOptions.subscribeToEquipControl(value -> AccessoriesClient.attemptAction(holder -> {
            if (holder.equipControl() == value) {
                return;
            }
            AccessoriesNetworking.sendToServer(SyncHolderChange.of(HolderProperty.EQUIP_CONTROL, value));
        }));
        Accessories.config().screenOptions.subscribeToShowUnusedSlots(value -> AccessoriesClient.attemptAction(holder -> {
            if (holder.showUnusedSlots() == value.booleanValue()) {
                return;
            }
            AccessoriesNetworking.sendToServer(SyncHolderChange.of(HolderProperty.UNUSED_PROP, value));
        }));
    }

    public static void init() {
        ClientLifecycleEvents.END_DATA_PACK_RELOAD.register((client, success) -> {
            if (!success) {
                return;
            }
            AccessoriesRendererRegistry.onReload();
        });
        SPECTRUM_PROGRAM = new GlProgram(Accessories.of("spectrum_position_tex"), class_290.field_1575);
        AccessoriesClient.initLayer();
    }

    private static void attemptAction(Consumer<AccessoriesHolder> consumer) {
        class_746 currentPlayer = class_310.method_1551().field_1724;
        if (currentPlayer == null || class_310.method_1551().field_1687 == null) {
            return;
        }
        AccessoriesHolder holder = currentPlayer.accessoriesHolder();
        if (holder != null) {
            consumer.accept(holder);
        }
    }

    public static void initalConfigDataSync() {
        class_746 currentPlayer = class_310.method_1551().field_1724;
        if (currentPlayer == null || class_310.method_1551().field_1687 == null) {
            return;
        }
        AccessoriesHolder holder = currentPlayer.accessoriesHolder();
        if (holder == null) {
            return;
        }
        PlayerEquipControl equipControl = Accessories.config().clientOptions.equipControl();
        if (holder.equipControl() != equipControl) {
            AccessoriesNetworking.sendToServer(SyncHolderChange.of(HolderProperty.EQUIP_CONTROL, equipControl));
        }
        boolean showUnusedSlots = Accessories.config().screenOptions.showUnusedSlots();
        if (holder.showUnusedSlots() != showUnusedSlots) {
            AccessoriesNetworking.sendToServer(SyncHolderChange.of(HolderProperty.UNUSED_PROP, showUnusedSlots));
        }
    }

    public static boolean attemptToOpenScreen() {
        return AccessoriesClient.attemptToOpenScreen(false);
    }

    public static boolean attemptToOpenScreen(boolean targetingLookingEntity) {
        return AccessoriesClient.attemptToOpenScreen(targetingLookingEntity, Accessories.config().screenOptions.selectedScreenType());
    }

    private static boolean attemptToOpenScreen(boolean targetingLookingEntity, ScreenType screenType) {
        class_746 player = class_310.method_1551().field_1724;
        AccessoriesMenuVariant selectedVariant = AccessoriesMenuVariant.getVariant(screenType);
        if (targetingLookingEntity) {
            class_1309 living;
            class_3966 entityHitResult;
            class_1297 class_12972;
            boolean bl;
            class_239 result = class_1675.method_49998((class_1297)player, e -> e instanceof class_1309, (double)player.method_55755());
            boolean bl2 = bl = !(result instanceof class_3966) || !((class_12972 = (entityHitResult = (class_3966)result).method_17782()) instanceof class_1309) || EntitySlotLoader.getEntitySlots(living = (class_1309)class_12972).isEmpty();
            if (bl) {
                return false;
            }
        } else {
            Collection<SlotType> slots = AccessoriesAPI.getUsedSlotsFor((class_1657)player);
            AccessoriesHolder holder = player.accessoriesHolder();
            if (holder == null) {
                return false;
            }
            if (slots.isEmpty() && !holder.showUnusedSlots() && !displayUnusedSlotWarning && !Accessories.config().clientOptions.disableEmptySlotScreenError()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"[Accessories]: No Used Slots found by any mod directly, the screen will show empty unless a item is found to implement slots!"), false);
                displayUnusedSlotWarning = true;
            }
        }
        if (selectedVariant != null) {
            AccessoriesNetworking.sendToServer(ScreenOpen.of(targetingLookingEntity, selectedVariant));
        } else {
            class_310.method_1551().method_1507((class_437)new ScreenVariantSelectionScreen(variant -> AccessoriesNetworking.sendToServer(ScreenOpen.of(targetingLookingEntity, variant))));
        }
        return true;
    }

    public static void initLayer() {
        Layers.add(Containers::verticalFlow, instance -> {
            boolean creativeScreen = instance.screen instanceof class_481;
            ((FlowLayout)instance.adapter.rootComponent).allowOverflow(true);
            Vector2i offset = creativeScreen ? Accessories.config().screenOptions.creativeInventoryButtonOffset() : Accessories.config().screenOptions.inventoryButtonOffset();
            ButtonComponent button = (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)""), btn -> AccessoriesClient.attemptToOpenScreen()).renderer((context, btn, delta) -> {
                ButtonComponent.Renderer.VANILLA.draw(context, btn, delta);
                context.push();
                class_2960 groupIcon = Accessories.of("gui/group/misc");
                class_1058 textureAtlasSprite = (class_1058)class_310.method_1551().method_1549(class_2960.method_60656((String)"textures/atlas/gui.png")).apply(groupIcon);
                Color color = Color.BLACK.interpolate(Color.WHITE, 0.4f);
                RenderSystem.depthMask((boolean)false);
                context.method_48465(btn.x() + 2, btn.y() + 2, 2, ((Sizing)btn.horizontalSizing().get()).value - 4, ((Sizing)btn.verticalSizing().get()).value - 4, textureAtlasSprite, color.red(), color.green(), color.blue(), 1.0f);
                RenderSystem.depthMask((boolean)true);
                context.pop();
            }).tooltip((class_2561)class_2561.method_43471((String)Accessories.translationKey("open.screen"))).margins(Insets.of((int)1, (int)0, (int)0, (int)1)).sizing(Sizing.fixed((int)(creativeScreen ? 8 : 12)));
            if (creativeScreen) {
                ComponentUtils.CreativeScreenExtension extension = (ComponentUtils.CreativeScreenExtension)instance.screen;
                button.field_22764 = extension.getTab().method_47312().equals((Object)class_1761.class_7916.field_41053);
                extension.getEvent().register(tab -> {
                    button.field_22764 = tab.method_47312().equals((Object)class_1761.class_7916.field_41053);
                });
            }
            ((FlowLayout)instance.adapter.rootComponent).child((Component)button);
            instance.alignComponentToHandledScreenCoordinates((Component)button, offset.x, offset.y);
        }, (Class[])new Class[]{class_490.class, class_481.class});
    }

    static {
        WINDOW_RESIZE_CALLBACK_EVENT = EventFactory.createArrayBacked(WindowResizeCallback.class, callbacks -> (client, window) -> {
            for (WindowResizeCallback callback : callbacks) {
                callback.onResized(client, window);
            }
        });
        IS_PLAYER_INVISIBLE = false;
        displayUnusedSlotWarning = false;
    }

    public static interface WindowResizeCallback {
        public void onResized(class_310 var1, class_1041 var2);
    }
}

