/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.menu.variants;

import com.mojang.datafixers.util.Pair;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.api.menu.AccessoriesBasedSlot;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.SlotTypeReference;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.menu.AccessoriesArmorSlot;
import io.wispforest.accessories.menu.AccessoriesInternalSlot;
import io.wispforest.accessories.menu.AccessoriesMenuData;
import io.wispforest.accessories.menu.AccessoriesMenuTypes;
import io.wispforest.accessories.menu.ArmorSlotTypes;
import io.wispforest.accessories.menu.SlotAccessContainer;
import io.wispforest.accessories.menu.SlotTypeAccessible;
import io.wispforest.accessories.menu.networking.ToggledSlots;
import io.wispforest.accessories.menu.variants.AccessoriesMenuBase;
import io.wispforest.owo.client.screens.SlotGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1501;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1816;
import net.minecraft.class_2960;
import net.minecraft.class_9692;
import org.jetbrains.annotations.Nullable;

public class AccessoriesExperimentalMenu
extends AccessoriesMenuBase {
    private final Set<SlotType> usedSlots = new HashSet<SlotType>();
    private final Set<SlotGroup> selectedGroups = new HashSet<SlotGroup>();
    private final List<AccessoriesBasedSlot> accessoriesSpecificSlots = new ArrayList<AccessoriesBasedSlot>();
    private int addedArmorSlots = 0;
    private int startingAccessoriesSlot = 0;
    private boolean includeSaddle = false;

    public static AccessoriesExperimentalMenu of(int containerId, class_1661 inventory, AccessoriesMenuData data) {
        class_1309 targetEntity = data.targetEntityId().map(i -> {
            class_1309 livingEntity;
            class_1297 patt0$temp = inventory.field_7546.method_37908().method_8469(i.intValue());
            return patt0$temp instanceof class_1309 ? (livingEntity = (class_1309)patt0$temp) : null;
        }).orElse(null);
        return new AccessoriesExperimentalMenu(containerId, inventory, targetEntity);
    }

    public AccessoriesExperimentalMenu(int containerId, final class_1661 inventory, @Nullable class_1309 targetEntity) {
        super(AccessoriesMenuTypes.EXPERIMENTAL_MENU, containerId, inventory, targetEntity);
        class_1309 accessoryTarget = targetEntity != null ? targetEntity : this.owner;
        AccessoriesCapability capability = AccessoriesCapability.get(accessoryTarget);
        if (capability == null) {
            return;
        }
        this.updateUsedSlots();
        SlotGenerator.begin(x$0 -> this.method_7621((class_1735)x$0), (int)-300, (int)-300).playerInventory(inventory);
        this.method_7621(new class_1735(this, (class_1263)inventory, 40, -300, -300){

            public void method_48931(class_1799 itemStack, class_1799 itemStack2) {
                inventory.field_7546.method_6116(class_1304.field_6171, itemStack2, itemStack);
                super.method_48931(itemStack, itemStack2);
            }

            public Pair<class_2960, class_2960> method_7679() {
                return Pair.of((Object)class_1723.field_21668, (Object)class_1723.field_21673);
            }
        });
        class_1263 saddleInv = SlotAccessContainer.ofSaddleSlot(accessoryTarget);
        if (saddleInv != null) {
            this.includeSaddle = true;
            final String iconPath = targetEntity instanceof class_1501 ? "container/horse/llama_armor_slot" : "container/horse/saddle_slot";
            this.method_7621(new class_1735(this, saddleInv, 0, -300, -300){

                public boolean method_7680(class_1799 stack) {
                    return stack.method_7909() instanceof class_1816 && super.method_7680(stack);
                }

                public Pair<class_2960, class_2960> method_7679() {
                    return Pair.of((Object)ArmorSlotTypes.SPRITE_ATLAS_LOCATION, (Object)class_2960.method_60656((String)iconPath));
                }
            });
        }
        this.startingAccessoriesSlot = this.field_7761.size();
        Map<String, AccessoriesContainer> containers = capability.getContainers();
        ArrayList<class_1304> validEquipmentSlots = new ArrayList<class_1304>();
        for (class_1304 value : class_1304.values()) {
            SlotTypeReference armorRef;
            if (!accessoryTarget.method_56991(value) || (armorRef = ArmorSlotTypes.getReferenceFromSlot(value)) == null || containers.get(armorRef.slotName()) == null) continue;
            validEquipmentSlots.add(value);
        }
        for (class_1304 equipmentSlot : validEquipmentSlots.reversed()) {
            if (!this.addArmorSlot(equipmentSlot, accessoryTarget, ArmorSlotTypes.getReferenceFromSlot(equipmentSlot), containers)) continue;
            this.addedArmorSlots += 2;
        }
        Map<SlotGroup, List<SlotType>> validGroupData = SlotGroupLoader.getValidGroups(accessoryTarget);
        List slotTypes = validGroupData.values().stream().flatMap(Collection::stream).toList();
        for (SlotType slot : slotTypes) {
            AccessoriesContainer accessoryContainer = containers.get(slot.name());
            if (accessoryContainer == null || accessoryContainer.slotType() == null) continue;
            for (int i = 0; i < accessoryContainer.getSize(); ++i) {
                AccessoriesInternalSlot cosmeticSlot = new AccessoriesInternalSlot(accessoryContainer, true, i, -300, -300).useCosmeticIcon(false);
                this.method_7621(cosmeticSlot);
                this.accessoriesSpecificSlots.add(cosmeticSlot);
                AccessoriesInternalSlot baseSlot = new AccessoriesInternalSlot(accessoryContainer, false, i, -300, -300);
                this.method_7621(baseSlot);
                this.accessoriesSpecificSlots.add(baseSlot);
            }
        }
        ToggledSlots.initMenu((class_1703)this);
    }

    private boolean addArmorSlot(class_1304 equipmentSlot, class_1309 targetEntity, SlotTypeReference armorReference, Map<String, AccessoriesContainer> containers) {
        final it.unimi.dsi.fastutil.Pair<class_2960, class_2960> location = ArmorSlotTypes.getEmptyTexture(equipmentSlot, targetEntity);
        AccessoriesContainer armorContainer = containers.get(armorReference.slotName());
        if (armorContainer == null) {
            return false;
        }
        class_9692 armorSlot = new AccessoriesArmorSlot(armorContainer, SlotAccessContainer.ofArmor(equipmentSlot, targetEntity), targetEntity, equipmentSlot, 0, -300, -300, location != null ? (class_2960)location.second() : null).setAtlasLocation(location != null ? (class_2960)location.first() : null);
        this.method_7621((class_1735)armorSlot);
        AccessoriesInternalSlot cosmeticSlot = new AccessoriesInternalSlot(this, armorContainer, true, 0, -300, -300){

            @Override
            @Nullable
            public Pair<class_2960, class_2960> method_7679() {
                if (location == null) {
                    return null;
                }
                class_2960 atlasLocation = (class_2960)location.first();
                if (atlasLocation == null) {
                    atlasLocation = class_2960.method_60656((String)"textures/atlas/blocks.png");
                }
                return Pair.of((Object)atlasLocation, (Object)((class_2960)location.second()));
            }
        };
        this.method_7621(cosmeticSlot);
        return true;
    }

    public final class_1309 targetEntityDefaulted() {
        class_1309 targetEntity = this.targetEntity();
        return targetEntity != null ? targetEntity : this.owner();
    }

    public int startingAccessoriesSlot() {
        return this.startingAccessoriesSlot;
    }

    public List<AccessoriesBasedSlot> getAccessoriesSlots() {
        return this.accessoriesSpecificSlots;
    }

    public List<class_1735> getVisibleAccessoriesSlots() {
        ArrayList<class_1735> filteredList = new ArrayList<class_1735>();
        Map<SlotGroup, List<SlotType>> groups = SlotGroupLoader.getValidGroups(this.targetEntityDefaulted());
        Set<SlotType> usedSlots = this.getUsedSlots();
        if (usedSlots != null) {
            groups.forEach((group, groupSlots) -> {
                if (groupSlots.stream().noneMatch(usedSlots::contains)) {
                    this.removeSelectedGroup((SlotGroup)group);
                }
            });
        }
        List selectedGroupedSlots = SlotGroupLoader.getValidGroups(this.targetEntityDefaulted()).entrySet().stream().filter(entry -> this.selectedGroups.isEmpty() || this.selectedGroups.contains(entry.getKey())).flatMap(entry -> ((List)entry.getValue()).stream()).toList();
        for (int i = 0; i < this.accessoriesSpecificSlots.size() / 2; ++i) {
            boolean isVisible;
            int cosmetic = i * 2;
            int accessory = cosmetic + 1;
            AccessoriesBasedSlot cosmeticSlot = this.accessoriesSpecificSlots.get(cosmetic);
            AccessoriesBasedSlot accessorySlot = this.accessoriesSpecificSlots.get(accessory);
            SlotType slotType = accessorySlot.slotType();
            boolean bl = isVisible = !(!this.usedSlots.isEmpty() && !this.usedSlots.contains(slotType) || !selectedGroupedSlots.isEmpty() && !selectedGroupedSlots.contains(slotType));
            if (!isVisible) continue;
            filteredList.add(cosmeticSlot);
            filteredList.add(accessorySlot);
        }
        return filteredList;
    }

    @Nullable
    public Set<SlotType> getUsedSlots() {
        return this.areUnusedSlotsShown() ? null : this.usedSlots;
    }

    public void updateUsedSlots() {
        this.usedSlots.clear();
        if (!this.areUnusedSlotsShown()) {
            Collection<SlotType> currentlyUsedSlots = AccessoriesAPI.getUsedSlotsFor((class_1309)(this.targetEntity != null ? this.targetEntity : this.owner), (class_1263)this.owner.method_31548());
            if (!currentlyUsedSlots.isEmpty()) {
                this.usedSlots.addAll(currentlyUsedSlots);
            } else {
                this.usedSlots.add(null);
            }
        }
    }

    public Set<SlotGroup> usedGroups() {
        Stream<Object> groups = SlotGroupLoader.getValidGroups(this.targetEntityDefaulted()).entrySet().stream();
        Set<SlotType> usedSlots = this.getUsedSlots();
        groups = groups.filter(entry -> {
            Set groupSlots = ((List)entry.getValue()).stream().filter(slotType -> {
                if (UniqueSlotHandling.isUniqueSlot(slotType.name())) {
                    return false;
                }
                AccessoriesCapability capability = this.targetEntityDefaulted().accessoriesCapability();
                if (capability == null) {
                    return false;
                }
                AccessoriesContainer container = capability.getContainer((SlotType)slotType);
                if (container == null) {
                    return false;
                }
                return container.getSize() > 0;
            }).collect(Collectors.toSet());
            if (groupSlots.isEmpty()) return false;
            if (usedSlots == null) return true;
            if (!groupSlots.stream().anyMatch(usedSlots::contains)) return false;
            return true;
        });
        return groups.map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Set<SlotGroup> selectedGroups() {
        return this.selectedGroups;
    }

    public boolean isGroupSelected(SlotGroup slotGroup) {
        return this.selectedGroups.contains(slotGroup);
    }

    public void addSelectedGroup(SlotGroup slotGroup) {
        this.selectedGroups.add(slotGroup);
        if (this.selectedGroups.containsAll(this.usedGroups())) {
            this.selectedGroups.clear();
        }
    }

    public void removeSelectedGroup(SlotGroup slotGroup) {
        this.selectedGroups.remove(slotGroup);
    }

    public int addedArmorSlots() {
        return this.addedArmorSlots;
    }

    public boolean includeSaddle() {
        return this.includeSaddle;
    }

    public boolean areUnusedSlotsShown() {
        return Optional.ofNullable(AccessoriesHolder.get((class_1309)this.owner)).map(AccessoriesHolder::showUnusedSlots).orElse(false);
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (!slot.method_7681()) {
            return class_1799.field_8037;
        }
        class_1799 itemStack2 = slot.method_7677();
        class_1799 itemStack = itemStack2.method_7972();
        class_1304 equipmentSlot = player.method_32326(itemStack);
        int bottomEquipmentIndex = 8 - (equipmentSlot.method_5927() + 1) * 2;
        int topEquipmentIndex = bottomEquipmentIndex + 1;
        int upperInventorySize = this.startingAccessoriesSlot;
        if (index == 0) {
            if (!this.method_7616(itemStack2, 5, 41, true)) {
                return class_1799.field_8037;
            }
            slot.method_7670(itemStack2, itemStack);
        } else if (index >= 1 && index < 5) {
            if (!this.method_7616(itemStack2, 5, 41, false)) {
                return class_1799.field_8037;
            }
        } else if (index >= upperInventorySize) {
            if (!this.method_7616(itemStack2, 5, 41, false)) {
                return class_1799.field_8037;
            }
        } else if (!(equipmentSlot.method_5925() != class_1304.class_1305.field_6178 || ((class_1735)this.field_7761.get(42 + bottomEquipmentIndex)).method_7681() && ((class_1735)this.field_7761.get(42 + topEquipmentIndex)).method_7681())) {
            if (!this.method_7616(itemStack2, 42 + bottomEquipmentIndex, 42 + topEquipmentIndex + 1, false)) {
                return class_1799.field_8037;
            }
        } else if (equipmentSlot == class_1304.field_6171 && !((class_1735)this.field_7761.get(45)).method_7681()) {
            if (!this.method_7616(itemStack2, 41, 42, false)) {
                return class_1799.field_8037;
            }
        } else {
            boolean changeOccured = false;
            if (this.canMoveToAccessorySlot(itemStack2, this.targetEntityDefaulted())) {
                this.method_7616(itemStack2, upperInventorySize, this.field_7761.size(), false);
                if (itemStack2.method_7947() != itemStack.method_7947() || itemStack2.method_7960()) {
                    changeOccured = true;
                }
            }
            if (!changeOccured && (index >= 5 && index < 32 ? !this.method_7616(itemStack2, 32, 41, false) : index >= 32 && index < 41 && !this.method_7616(itemStack2, 5, 32, false))) {
                return class_1799.field_8037;
            }
        }
        if (itemStack2.method_7947() == itemStack.method_7947()) {
            return class_1799.field_8037;
        }
        if (itemStack2.method_7960()) {
            slot.method_48931(class_1799.field_8037, itemStack);
        } else {
            slot.method_7668();
        }
        if (itemStack2.method_7947() == itemStack.method_7947()) {
            return class_1799.field_8037;
        }
        slot.method_7667(player, itemStack2);
        if (index == 0) {
            player.method_7328(itemStack2, false);
        }
        return itemStack;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    protected boolean canMoveToAccessorySlot(class_1799 stack, class_1309 living) {
        AccessoriesCapability capability = living.accessoriesCapability();
        if (capability == null) {
            return false;
        }
        Collection<SlotType> validSlotTypes = AccessoriesAPI.getStackSlotTypes(living, stack);
        for (class_1735 slot : this.field_7761.subList(this.startingAccessoriesSlot, this.field_7761.size())) {
            SlotTypeAccessible accessible;
            if (!(slot instanceof SlotTypeAccessible) || !validSlotTypes.contains((accessible = (SlotTypeAccessible)slot).slotType())) continue;
            return true;
        }
        return false;
    }

    protected boolean method_7616(class_1799 stack, int startIndex, int endIndex, boolean reverseDirection) {
        int j;
        class_1799 itemStack;
        class_1735 slot;
        int i;
        boolean bl = false;
        int n = i = reverseDirection ? endIndex - 1 : startIndex;
        if (stack.method_7946()) {
            while (!stack.method_7960() && (reverseDirection ? i >= startIndex : i < endIndex)) {
                slot = (class_1735)this.field_7761.get(i);
                if (slot.method_7682() && !(itemStack = slot.method_7677()).method_7960() && class_1799.method_31577((class_1799)stack, (class_1799)itemStack)) {
                    int k;
                    j = itemStack.method_7947() + stack.method_7947();
                    if (j <= (k = slot.method_7676(itemStack))) {
                        stack.method_7939(0);
                        itemStack.method_7939(j);
                        slot.method_7668();
                        bl = true;
                    } else if (itemStack.method_7947() < k) {
                        stack.method_7934(k - itemStack.method_7947());
                        itemStack.method_7939(k);
                        slot.method_7668();
                        bl = true;
                    }
                }
                i += reverseDirection ? -1 : 1;
            }
        }
        if (!stack.method_7960()) {
            int n2 = i = reverseDirection ? endIndex - 1 : startIndex;
            while (reverseDirection ? i >= startIndex : i < endIndex) {
                slot = (class_1735)this.field_7761.get(i);
                if (slot.method_7682() && (itemStack = slot.method_7677()).method_7960() && slot.method_7680(stack)) {
                    j = slot.method_7676(stack);
                    slot.method_53512(stack.method_7971(Math.min(stack.method_7947(), j)));
                    slot.method_7668();
                    bl = true;
                    break;
                }
                i += reverseDirection ? -1 : 1;
            }
        }
        return bl;
    }

    public void method_7610(int stateId, List<class_1799> items, class_1799 carried) {
        for (int i = 0; i < items.size(); ++i) {
            class_1735 slot = this.method_7611(i);
            if (slot instanceof SlotTypeAccessible) continue;
            slot.method_7673(items.get(i));
        }
        super.method_7610(stateId, List.of(), carried);
    }
}

