/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.entity;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.levelz.access.ServerPlayerSyncAccess;
import net.levelz.init.EntityInit;
import net.levelz.network.packet.OrbPacket;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3231;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_5575;

public class LevelExperienceOrbEntity
extends class_1297 {
    private int orbAge;
    private int health = 5;
    private int amount;
    private int pickingCount = 1;
    private class_1657 target;
    private Map<Integer, Integer> clumpedMap;

    public LevelExperienceOrbEntity(class_1937 world, double x, double y, double z, int amount) {
        this(EntityInit.LEVEL_EXPERIENCE_ORB, world);
        this.method_5814(x, y, z);
        this.method_36456((float)(this.field_5974.method_43058() * 360.0));
        this.method_18800((this.field_5974.method_43058() * (double)0.2f - (double)0.1f) * 2.0, this.field_5974.method_43058() * 0.2 * 2.0, (this.field_5974.method_43058() * (double)0.2f - (double)0.1f) * 2.0);
        this.amount = amount;
    }

    public LevelExperienceOrbEntity(class_1299<? extends LevelExperienceOrbEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    protected void method_5693(class_2945.class_9222 builder) {
    }

    public void method_5773() {
        super.method_5773();
        this.field_6014 = this.method_23317();
        this.field_6036 = this.method_23318();
        this.field_5969 = this.method_23321();
        if (this.method_5777(class_3486.field_15517)) {
            this.applyWaterMovement();
        } else if (!this.method_5740()) {
            this.method_18799(this.method_18798().method_1031(0.0, -0.03, 0.0));
        }
        if (this.method_37908().method_8316(this.method_24515()).method_15767(class_3486.field_15518)) {
            this.method_18800((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f, 0.2f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f);
        }
        if (!this.method_37908().method_18026(this.method_5829())) {
            this.method_5632(this.method_23317(), (this.method_5829().field_1322 + this.method_5829().field_1325) / 2.0, this.method_23321());
        }
        if (this.field_6012 % 20 == 1) {
            this.expensiveUpdate();
        }
        if (this.target != null && (this.target.method_7325() || this.target.method_29504())) {
            this.target = null;
        }
        if (this.target != null) {
            double d;
            class_243 vec3d = new class_243(this.target.method_23317() - this.method_23317(), this.target.method_23318() + (double)this.target.method_5751() / 2.0 - this.method_23318(), this.target.method_23321() - this.method_23321());
            double d2 = vec3d.method_1027();
            if (d < 64.0) {
                double e = 1.0 - Math.sqrt(d2) / 8.0;
                this.method_18799(this.method_18798().method_1019(vec3d.method_1029().method_1021(e * e * 0.1)));
            }
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
        float vec3d2 = 0.98f;
        if (this.method_24828()) {
            vec3d2 = this.method_37908().method_8320(this.method_24515().method_10074()).method_26204().method_9499() * 0.98f;
        }
        this.method_18799(this.method_18798().method_18805((double)vec3d2, 0.98, (double)vec3d2));
        if (this.method_24828()) {
            this.method_18799(this.method_18798().method_18805(1.0, -0.9, 1.0));
        }
        ++this.orbAge;
        if (this.orbAge >= 6000) {
            this.method_31472();
        }
    }

    private void expensiveUpdate() {
        if (this.target == null || this.target.method_5858((class_1297)this) > 64.0) {
            this.target = this.method_37908().method_18460((class_1297)this, 8.0);
        }
        if (this.method_37908() instanceof class_3218) {
            List list = this.method_37908().method_18023(class_5575.method_31795(LevelExperienceOrbEntity.class), this.method_5829().method_1014(0.5), this::isMergeable);
            for (LevelExperienceOrbEntity experienceOrbEntity : list) {
                this.merge(experienceOrbEntity);
            }
        }
    }

    public static void spawn(class_3218 world, class_243 pos, int amount) {
        while (amount > 0) {
            int i = LevelExperienceOrbEntity.roundToOrbSize(amount);
            amount -= i;
            if (LevelExperienceOrbEntity.wasMergedIntoExistingOrb(world, pos, i)) continue;
            world.method_8649((class_1297)new LevelExperienceOrbEntity((class_1937)world, pos.method_10216(), pos.method_10214(), pos.method_10215(), i));
        }
    }

    private static boolean wasMergedIntoExistingOrb(class_3218 world, class_243 pos, int amount) {
        class_238 box = class_238.method_30048((class_243)pos, (double)1.0, (double)1.0, (double)1.0);
        int i = world.method_8409().method_43048(40);
        List list = world.method_18023(class_5575.method_31795(LevelExperienceOrbEntity.class), box, orb -> LevelExperienceOrbEntity.isMergeable(orb, i, amount));
        if (!list.isEmpty()) {
            LevelExperienceOrbEntity experienceOrbEntity = (LevelExperienceOrbEntity)((Object)list.get(0));
            Map<Integer, Integer> clumpedMap = experienceOrbEntity.getClumpedMap();
            experienceOrbEntity.setClumpedMap(Stream.of(clumpedMap, Collections.singletonMap(amount, 1)).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum)));
            experienceOrbEntity.pickingCount = clumpedMap.values().stream().reduce(Integer::sum).orElse(1);
            experienceOrbEntity.orbAge = 0;
            return true;
        }
        return false;
    }

    private boolean isMergeable(LevelExperienceOrbEntity other) {
        return other.method_5805() && other != this;
    }

    private static boolean isMergeable(LevelExperienceOrbEntity orb, int seed, int amount) {
        return orb.method_5805();
    }

    private void merge(LevelExperienceOrbEntity other) {
        Map<Integer, Integer> otherMap = other.getClumpedMap();
        this.setClumpedMap(Stream.of(this.getClumpedMap(), otherMap).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum)));
        this.pickingCount = this.getClumpedMap().values().stream().reduce(Integer::sum).orElse(1);
        this.orbAge = Math.min(this.orbAge, other.orbAge);
        other.method_31472();
    }

    private void applyWaterMovement() {
        class_243 vec3d = this.method_18798();
        this.method_18800(vec3d.field_1352 * (double)0.99f, Math.min(vec3d.field_1351 + (double)5.0E-4f, (double)0.06f), vec3d.field_1350 * (double)0.99f);
    }

    protected void method_5746() {
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        if (this.method_37908().method_8608()) {
            return true;
        }
        this.method_5785();
        this.health = (int)((float)this.health - amount);
        if (this.health <= 0) {
            this.method_31472();
        }
        return true;
    }

    public void method_5652(class_2487 nbt) {
        nbt.method_10575("Health", (short)this.health);
        nbt.method_10575("Age", (short)this.orbAge);
        nbt.method_10575("Value", (short)this.amount);
        nbt.method_10569("Count", this.pickingCount);
        class_2487 map = new class_2487();
        this.getClumpedMap().forEach((value, count) -> map.method_10569("" + value, count.intValue()));
        nbt.method_10566("clumpedMap", (class_2520)map);
    }

    public void method_5749(class_2487 nbt) {
        this.health = nbt.method_10568("Health");
        this.orbAge = nbt.method_10568("Age");
        this.amount = nbt.method_10568("Value");
        this.pickingCount = Math.max(nbt.method_10550("Count"), 1);
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        if (nbt.method_10545("clumpedMap")) {
            class_2487 clumpedMap = nbt.method_10562("clumpedMap");
            for (String s : clumpedMap.method_10541()) {
                map.put(Integer.parseInt(s), clumpedMap.method_10550(s));
            }
        } else {
            map.put(this.amount, this.pickingCount);
        }
        this.setClumpedMap(map);
    }

    public void method_5694(class_1657 player) {
        if (!this.method_37908().method_8608() && player.field_7504 == 0 && this.orbAge > 20) {
            player.field_7504 = 2;
            player.method_6103((class_1297)this, 1);
            this.getClumpedMap().forEach((value, amount) -> ((ServerPlayerSyncAccess)player).addLevelExperience(value * amount));
            this.method_31472();
        }
    }

    public int getExperienceAmount() {
        return this.amount;
    }

    public int getOrbSize() {
        if (this.amount >= 2477) {
            return 10;
        }
        if (this.amount >= 1237) {
            return 9;
        }
        if (this.amount >= 617) {
            return 8;
        }
        if (this.amount >= 307) {
            return 7;
        }
        if (this.amount >= 149) {
            return 6;
        }
        if (this.amount >= 73) {
            return 5;
        }
        if (this.amount >= 37) {
            return 4;
        }
        if (this.amount >= 17) {
            return 3;
        }
        if (this.amount >= 7) {
            return 2;
        }
        if (this.amount >= 3) {
            return 1;
        }
        return 0;
    }

    public static int roundToOrbSize(int value) {
        if (value >= 2477) {
            return 2477;
        }
        if (value >= 1237) {
            return 1237;
        }
        if (value >= 617) {
            return 617;
        }
        if (value >= 307) {
            return 307;
        }
        if (value >= 149) {
            return 149;
        }
        if (value >= 73) {
            return 73;
        }
        if (value >= 37) {
            return 37;
        }
        if (value >= 17) {
            return 17;
        }
        if (value >= 7) {
            return 7;
        }
        if (value >= 3) {
            return 3;
        }
        return 1;
    }

    public boolean method_5732() {
        return false;
    }

    public class_2596<class_2602> method_18002(class_3231 entityTrackerEntry) {
        return new OrbPacket(this, entityTrackerEntry);
    }

    public class_3419 method_5634() {
        return class_3419.field_15256;
    }

    private Map<Integer, Integer> getClumpedMap() {
        if (this.clumpedMap == null) {
            this.clumpedMap = new HashMap<Integer, Integer>();
            this.clumpedMap.put(this.amount, 1);
        }
        return this.clumpedMap;
    }

    private void setClumpedMap(Map<Integer, Integer> map) {
        this.clumpedMap = map;
        this.amount = this.getClumpedMap().entrySet().stream().map(entry -> (Integer)entry.getKey() * (Integer)entry.getValue()).reduce(Integer::sum).orElse(1);
    }
}

