/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.mixin.entity;

import net.levelz.access.LevelManagerAccess;
import net.levelz.access.MobEntityAccess;
import net.levelz.access.PlayerDropAccess;
import net.levelz.entity.LevelExperienceOrbEntity;
import net.levelz.init.ConfigInit;
import net.levelz.level.LevelManager;
import net.levelz.util.BonusHelper;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    @Shadow
    protected int field_6238;
    @Shadow
    @Nullable
    protected class_1657 field_6258;

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @ModifyVariable(method={"modifyAppliedDamage"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/enchantment/EnchantmentHelper;getProtectionAmount(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/entity/damage/DamageSource;)F", shift=At.Shift.AFTER), ordinal=1)
    private float modifyAppliedDamageMixin(float original, class_1282 source, float amount) {
        LivingEntityMixin livingEntityMixin;
        if (source.method_49708(class_8111.field_42345) && (livingEntityMixin = this) instanceof class_1657) {
            class_1657 playerEntity = (class_1657)livingEntityMixin;
            return original + BonusHelper.fallDamageReductionBonus(playerEntity);
        }
        return original;
    }

    @ModifyVariable(method={"tryUseTotem"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/entity/LivingEntity;getStackInHand(Lnet/minecraft/util/Hand;)Lnet/minecraft/item/ItemStack;", ordinal=0))
    private class_1799 tryUseTotemMixin(class_1799 original) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657) {
            class_1657 playerEntity = (class_1657)livingEntityMixin;
            if (original.method_31574(class_1802.field_8288)) {
                if (playerEntity.method_7337()) {
                    return original;
                }
                LevelManager levelManager = ((LevelManagerAccess)playerEntity).getLevelManager();
                if (!levelManager.hasRequiredItemLevel(original.method_7909())) {
                    return class_1799.field_8037;
                }
            }
        }
        return original;
    }

    @Inject(method={"tryUseTotem"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/util/Hand;values()[Lnet/minecraft/util/Hand;")}, cancellable=true)
    private void tryUseTotemMixin(class_1282 source, CallbackInfoReturnable<Boolean> info) {
        class_1657 playerEntity;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657 && BonusHelper.deathGraceChanceBonus(playerEntity = (class_1657)livingEntityMixin)) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(method={"drop"}, at={@At(value="HEAD")}, cancellable=true)
    protected void dropMixin(class_3218 world, class_1282 damageSource, CallbackInfo info) {
        if (!(this instanceof class_1657) && this.field_6258 != null && this.field_6238 > 0 && ConfigInit.CONFIG.disableMobFarms && !((PlayerDropAccess)this.field_6258).allowMobDrop()) {
            info.cancel();
        }
    }

    @Inject(method={"onDeath"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;drop(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/damage/DamageSource;)V")})
    private void onDeathMixin(class_1282 source, CallbackInfo info) {
        if (this.field_6258 != null && this.field_6238 > 0 && ConfigInit.CONFIG.disableMobFarms) {
            ((PlayerDropAccess)this.field_6258).increaseKilledMobStat(this.method_37908().method_22350(this.method_24515()));
        }
    }

    @Inject(method={"dropXp"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/ExperienceOrbEntity;spawn(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/Vec3d;I)V")})
    protected void dropXpMixin(CallbackInfo info) {
        class_1308 mobEntity;
        LivingEntityMixin livingEntityMixin;
        if (ConfigInit.CONFIG.mobXPMultiplier > 0.0f && (ConfigInit.CONFIG.spawnerMobXP || !((livingEntityMixin = this) instanceof class_1308) || !((MobEntityAccess)(mobEntity = (class_1308)livingEntityMixin)).isSpawnerMob())) {
            LevelExperienceOrbEntity.spawn((class_3218)this.method_37908(), this.method_19538(), (int)((float)this.method_6110() * ConfigInit.CONFIG.mobXPMultiplier * (ConfigInit.CONFIG.dropXPbasedOnLvl && this.field_6258 != null ? 1.0f + ConfigInit.CONFIG.basedOnMultiplier * (float)((LevelManagerAccess)this.field_6258).getLevelManager().getOverallLevel() : 1.0f)));
        }
    }

    @Shadow
    protected int method_6110() {
        return 0;
    }
}

