/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.registry;

import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.minecraft.class_2960;
import org.objectweb.asm.Type;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD})
public @interface RegistryEntryAcceptor {
    public String namespace();

    public String identifier();

    public Registry registry();

    public static class Handler {
        private static final Type TYPE = Type.getType(RegistryEntryAcceptor.class);
        private static final Map<Registries.Registry<?>, Map<class_2960, Set<Field>>> FIELDS = new HashMap();
        private static final Map<Registries.Registry<?>, Map<class_2960, Set<Method>>> METHODS = new HashMap();

        public static void gatherAnnotatedFields() {
            for (EntrypointContainer entrypoint : FabricLoader.getInstance().getEntrypointContainers("main", ModInitializer.class)) {
                Registry registry;
                String identifier;
                String namespace;
                RegistryEntryAcceptor annotation;
                try {
                    for (Field field : ((ModInitializer)entrypoint.getEntrypoint()).getClass().getFields()) {
                        annotation = field.getAnnotation(RegistryEntryAcceptor.class);
                        if (annotation == null) continue;
                        namespace = annotation.namespace();
                        if (!RegistryUtil.isValidNamespace(namespace)) {
                            throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
                        }
                        identifier = annotation.identifier();
                        if (!RegistryUtil.isValidPath(identifier)) {
                            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
                        }
                        registry = annotation.registry();
                        if (registry == null) {
                            throw new IllegalArgumentException("Registry must not be null!");
                        }
                        if (!Modifier.isStatic(field.getModifiers())) {
                            throw new RuntimeException("Field must be static!");
                        }
                        if (Modifier.isFinal(field.getModifiers())) {
                            throw new RuntimeException("Field must not be final!");
                        }
                        if (!registry.registry.getValueClass().isAssignableFrom(field.getType())) {
                            throw new RuntimeException("Field must have a type assignable from '" + registry.registry.getValueClass().getName() + "'!");
                        }
                        field.setAccessible(true);
                        FIELDS.computeIfAbsent(registry.registry, o -> new HashMap()).computeIfAbsent(class_2960.method_60655((String)namespace, (String)identifier), o -> new HashSet()).add(field);
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
                catch (Exception exception) {
                    CoreLib.LOGGER.error("Encountered an exception whilst scanning fields in 'main' entrypoint for mod '" + entrypoint.getProvider().getMetadata().getName() + "'!", (Throwable)exception);
                    continue;
                }
                try {
                    for (Method method : ((ModInitializer)entrypoint.getEntrypoint()).getClass().getMethods()) {
                        annotation = method.getAnnotation(RegistryEntryAcceptor.class);
                        if (annotation == null) continue;
                        namespace = annotation.namespace();
                        if (!RegistryUtil.isValidNamespace(namespace)) {
                            throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
                        }
                        identifier = annotation.identifier();
                        if (!RegistryUtil.isValidPath(identifier)) {
                            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
                        }
                        registry = annotation.registry();
                        if (registry == null) {
                            throw new IllegalArgumentException("Registry must not be null!");
                        }
                        if (!Modifier.isStatic(method.getModifiers())) {
                            throw new RuntimeException("Method must be static!");
                        }
                        if (method.getParameterCount() != 1) {
                            throw new RuntimeException("Method must have exactly 1 parameter!");
                        }
                        if (!registry.registry.getValueClass().isAssignableFrom(method.getParameterTypes()[0])) {
                            throw new RuntimeException("Method parameter must have a type assignable from '" + registry.registry.getValueClass().getName() + "'!");
                        }
                        method.setAccessible(true);
                        METHODS.computeIfAbsent(registry.registry, o -> new HashMap()).computeIfAbsent(class_2960.method_60655((String)namespace, (String)identifier), o -> new HashSet()).add(method);
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
                catch (Exception exception) {
                    CoreLib.LOGGER.error("Encountered an exception whilst scanning methods in 'main' entrypoint for mod '" + entrypoint.getProvider().getMetadata().getName() + "'!", (Throwable)exception);
                }
            }
            HashSet registries = new HashSet();
            registries.addAll(FIELDS.keySet());
            registries.addAll(METHODS.keySet());
            for (Registries.Registry registry : registries) {
                if (!registry.hasVanillaRegistry()) continue;
                RegistryEntryAddedCallback.event(registry.getVanillaRegistry()).register((rawId, id, object) -> Handler.onRegisterEvent(registry, id, object));
            }
        }

        public static void onRegisterEvent(Registries.Registry<?> registry, class_2960 identifier, Object object) {
            Handler.applyToFields(registry, identifier, object);
            Handler.applyToMethods(registry, identifier, object);
        }

        private static void applyToFields(Registries.Registry<?> registry, class_2960 identifier, Object object) {
            if (registry == null || !FIELDS.containsKey(registry)) {
                return;
            }
            for (Map.Entry<class_2960, Set<Field>> entry : FIELDS.get(registry).entrySet()) {
                if (!identifier.equals((Object)entry.getKey())) continue;
                for (Field field : entry.getValue()) {
                    if (!field.getType().isAssignableFrom(object.getClass())) {
                        CoreLib.LOGGER.warn("@RegistryEntryAcceptor field '" + field.getDeclaringClass().getName() + "." + field.getName() + "' for '" + String.valueOf(entry.getKey()) + "' could not be assigned value of type '" + String.valueOf(object.getClass()) + "'.");
                        continue;
                    }
                    try {
                        field.set(null, object);
                    }
                    catch (IllegalAccessException e) {
                        CoreLib.LOGGER.error("Encountered an error when trying to apply @RegistryEntryAcceptor annotation on field '" + field.getDeclaringClass().getName() + "." + field.getName() + "'!", (Throwable)e);
                    }
                }
            }
        }

        private static void applyToMethods(Registries.Registry<?> registry, class_2960 identifier, Object object) {
            if (registry == null || !METHODS.containsKey(registry)) {
                return;
            }
            for (Map.Entry<class_2960, Set<Method>> entry : METHODS.get(registry).entrySet()) {
                if (!identifier.equals((Object)entry.getKey())) continue;
                for (Method method : entry.getValue()) {
                    if (!method.getParameterTypes()[0].isAssignableFrom(object.getClass())) {
                        CoreLib.LOGGER.warn("@RegistryEntryAcceptor method '" + method.getDeclaringClass().getName() + "." + method.getName() + "' for '" + String.valueOf(entry.getKey()) + "' could not be assigned value of type '" + String.valueOf(object.getClass()) + "'.");
                        continue;
                    }
                    try {
                        method.invoke(null, object);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        CoreLib.LOGGER.error("Encountered an error when trying to apply @RegistryEntryAcceptor annotation on method '" + method.getDeclaringClass().getName() + "." + method.getName() + "'!", (Throwable)e);
                    }
                }
            }
        }

        public static void reportMissing() {
            HashSet registries = new HashSet();
            registries.addAll(FIELDS.keySet());
            registries.addAll(METHODS.keySet());
            registries.forEach(Handler::reportMissing);
        }

        private static void reportMissing(Registries.Registry<?> registry) {
            if (FIELDS.containsKey(registry)) {
                for (Map.Entry<class_2960, Set<Field>> entry : FIELDS.get(registry).entrySet()) {
                    if (registry.hasIdentifier(entry.getKey())) continue;
                    CoreLib.LOGGER.warn("Could not find value '" + String.valueOf(entry.getKey()) + "' in registry '" + String.valueOf(registry.getRegistryIdentifier()) + "' for @RegistryEntryAcceptor!");
                }
            }
            if (METHODS.containsKey(registry)) {
                for (Map.Entry<class_2960, Set<AccessibleObject>> entry : METHODS.get(registry).entrySet()) {
                    if (registry.hasIdentifier(entry.getKey())) continue;
                    CoreLib.LOGGER.warn("Could not find value '" + String.valueOf(entry.getKey()) + "' in registry '" + String.valueOf(registry.getRegistryIdentifier()) + "' for @RegistryEntryAcceptor!");
                }
            }
        }
    }

    public static enum Registry {
        BLOCKS(Registries.BLOCKS),
        FLUIDS(Registries.FLUIDS),
        ITEMS(Registries.ITEMS),
        MOB_EFFECTS(Registries.MOB_EFFECTS),
        SOUND_EVENTS(Registries.SOUND_EVENTS),
        POTIONS(Registries.POTIONS),
        ENTITY_TYPES(Registries.ENTITY_TYPES),
        BLOCK_ENTITY_TYPES(Registries.BLOCK_ENTITY_TYPES),
        PARTICLE_TYPES(Registries.PARTICLE_TYPES),
        MENU_TYPES(Registries.MENU_TYPES),
        RECIPE_SERIALIZERS(Registries.RECIPE_SERIALIZERS),
        ATTRIBUTES(Registries.ATTRIBUTES),
        STAT_TYPES(Registries.STAT_TYPES),
        RESOURCE_CONDITION_SERIALIZERS(Registries.RESOURCE_CONDITION_SERIALIZERS);

        public final Registries.Registry<?> registry;

        private Registry(Registries.Registry<?> registry) {
            this.registry = registry;
        }
    }
}

