/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.trimmable.tools.resource;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dev.worldgen.trimmable.tools.TrimmableTools;
import dev.worldgen.trimmable.tools.TrimmableToolsClient;
import dev.worldgen.trimmable.tools.config.ConfigHandler;
import dev.worldgen.trimmable.tools.config.ToolTags;
import dev.worldgen.trimmable.tools.config.TrimData;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3298;
import net.minecraft.class_3518;
import net.minecraft.class_7367;
import org.apache.commons.io.IOUtils;

public class TrimmableToolsResourceHelper {
    private static final Gson GSON = new Gson();

    public static void addAllTrimOverrides(Map<class_2960, class_3298> models) {
        for (Map.Entry<class_2960, class_3298> entry : new HashSet<Map.Entry<class_2960, class_3298>>(models.entrySet())) {
            class_2960 key = entry.getKey();
            if (!ToolTags.EVERYTHING_TRIMMABLE.contains(TrimmableToolsResourceHelper.stripModelAffixes(key))) continue;
            try {
                BufferedReader reader = entry.getValue().method_43039();
                try {
                    JsonObject json = class_3518.method_15255((Reader)reader);
                    class_2960 toolType = ToolTags.getToolType(key);
                    if (toolType.equals((Object)ToolTags.UNKNOWN)) continue;
                    String toolMaterial = ConfigHandler.getDarkerMaterial(key);
                    String parent = TrimmableToolsResourceHelper.getParent(json);
                    String layer0 = TrimmableToolsResourceHelper.getLayer0(json);
                    JsonArray overrides = TrimmableToolsResourceHelper.getOverrides(json);
                    List<class_2960> patterns = TrimData.PATTERNS;
                    for (int i = 0; i < patterns.size(); ++i) {
                        String pattern = patterns.get(i).method_12832();
                        List<class_2960> materials = TrimData.MATERIALS;
                        for (int j = 0; j < materials.size(); ++j) {
                            Object material = materials.get(j).method_12832();
                            if (Objects.equals(material, toolMaterial)) {
                                material = (String)material + "_darker";
                            }
                            class_2960 rawModelId = TrimmableToolsResourceHelper.createTrimmedToolId(key, pattern, (String)material);
                            models.put(rawModelId, TrimmableToolsResourceHelper.createTrimOverrideResource(entry.getValue().method_45304(), parent, layer0, toolType, pattern, (String)material));
                            JsonObject override = new JsonObject();
                            override.addProperty("model", TrimmableToolsResourceHelper.createModelId(rawModelId));
                            JsonObject predicate = new JsonObject();
                            predicate.addProperty(TrimmableToolsClient.TRIM_PATTERN.toString(), (Number)Float.valueOf((float)(i + 1) / 1000.0f));
                            predicate.addProperty(TrimmableToolsClient.TRIM_MATERIAL.toString(), (Number)Float.valueOf((float)(j + 1) / 1000.0f));
                            override.add("predicate", (JsonElement)predicate);
                            overrides.add((JsonElement)override);
                        }
                        json.add("overrides", (JsonElement)overrides);
                        models.put(entry.getKey(), new class_3298(entry.getValue().method_45304(), TrimmableToolsResourceHelper.createSupplier(json)));
                    }
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonSyntaxException reader) {
            }
            catch (Exception e) {
                TrimmableTools.LOGGER.error("Couldn't load trimmable tool data from model {}", (Object)key, (Object)e);
            }
        }
    }

    public static class_2960 stripModelAffixes(class_2960 id) {
        String path = id.method_12832();
        return class_2960.method_60655((String)id.method_12836(), (String)path.substring(path.lastIndexOf("/") + 1, path.length() - 5));
    }

    private static class_2960 createTrimmedToolId(class_2960 id, String pattern, String material) {
        return class_2960.method_60655((String)id.method_12836(), (String)id.method_12832().replace(".json", String.format("_%s_%s.json", pattern, material)));
    }

    private static String createModelId(class_2960 id) {
        String path = id.method_12832();
        return class_2960.method_60655((String)id.method_12836(), (String)path.substring(7, path.length() - 5)).toString();
    }

    private static class_3298 createTrimOverrideResource(class_3262 pack, String parent, String layer0, class_2960 toolType, String pattern, String material) {
        JsonObject textures = new JsonObject();
        textures.addProperty("layer0", layer0);
        textures.addProperty("layer1", String.format("%s:trims/items/%s/%s_%s", toolType.method_12836(), toolType.method_12832(), pattern, material));
        JsonObject json = new JsonObject();
        json.addProperty("parent", parent);
        json.add("textures", (JsonElement)textures);
        return new class_3298(pack, TrimmableToolsResourceHelper.createSupplier(json));
    }

    private static String getParent(JsonObject json) {
        return class_3518.method_15265((JsonObject)json, (String)"parent");
    }

    private static String getLayer0(JsonObject json) {
        JsonObject textures = class_3518.method_15296((JsonObject)json, (String)"textures");
        return class_3518.method_15265((JsonObject)textures, (String)"layer0");
    }

    private static JsonArray getOverrides(JsonObject json) {
        try {
            return class_3518.method_15261((JsonObject)json, (String)"overrides");
        }
        catch (Exception e) {
            return new JsonArray();
        }
    }

    private static class_7367<InputStream> createSupplier(JsonObject json) {
        return () -> IOUtils.toInputStream((String)GSON.toJson((JsonElement)json), (String)"UTF-8");
    }
}

