/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.item;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.CombatConfig;
import com.github.thedeathlycow.scorchful.registry.tag.SArmorMaterialTags;
import com.github.thedeathlycow.thermoo.api.armor.material.ArmorMaterialTags;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public class HeatResistanceHelper {
    public static double getHeatResistance(class_6880<class_1741> armorMaterial, class_1738.class_8051 armorType) {
        CombatConfig config = Scorchful.getConfig().combatConfig;
        HeatResistanceLevel level = HeatResistanceLevel.forMaterial(armorMaterial);
        return level.getHeatResistance(config);
    }

    public static enum HeatResistanceLevel {
        VERY_PROTECTIVE((class_6862<class_1741>)ArmorMaterialTags.VERY_RESISTANT_TO_HEAT, CombatConfig::getVeryProtectiveArmorHeatResistance),
        PROTECTIVE((class_6862<class_1741>)ArmorMaterialTags.RESISTANT_TO_HEAT, CombatConfig::getProtectiveArmorHeatResistance),
        VERY_HARMFUL((class_6862<class_1741>)ArmorMaterialTags.VERY_WEAK_TO_HEAT, CombatConfig::getVeryHarmfulArmorHeatResistance),
        NEUTRAL(SArmorMaterialTags.HEAT_NEUTRAL, c -> Double.NaN),
        DEFAULT(item -> true, CombatConfig::getDefaultArmorHeatResistance);

        private final Predicate<class_6880<class_1741>> predicate;
        private final ToDoubleFunction<CombatConfig> heatResistanceProvider;

        private HeatResistanceLevel(class_6862<class_1741> tag, ToDoubleFunction<CombatConfig> heatResistanceProvider) {
            this((class_6880<class_1741> material) -> material.method_40220(tag), heatResistanceProvider);
        }

        private HeatResistanceLevel(Predicate<class_6880<class_1741>> predicate, ToDoubleFunction<CombatConfig> heatResistanceProvider) {
            this.predicate = predicate;
            this.heatResistanceProvider = heatResistanceProvider;
        }

        public double getHeatResistance(CombatConfig config) {
            return this.heatResistanceProvider.applyAsDouble(config);
        }

        public boolean appliesToMaterial(class_6880<class_1741> material) {
            return this.predicate.test(material);
        }

        public static HeatResistanceLevel forMaterial(class_6880<class_1741> material) {
            for (HeatResistanceLevel level : HeatResistanceLevel.values()) {
                if (!level.appliesToMaterial(material)) continue;
                return level;
            }
            return DEFAULT;
        }
    }
}

