/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sawmill;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.trades.ItemListingManager;
import net.mehvahdjukaar.moonlight.api.trades.ModItemListing;
import net.mehvahdjukaar.sawmill.SawmillMod;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3851;
import net.minecraft.class_3854;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_9306;
import org.jetbrains.annotations.Nullable;

public final class CarpenterTrades {
    private static final Supplier<Map<class_3854, List<WoodType>>> TYPE_MAP = Suppliers.memoize(() -> {
        HashMap<class_3854, List<WoodType>> map = new HashMap<class_3854, List<WoodType>>();
        map.put(class_3854.field_17073, List.of(CarpenterTrades.wood("birch"), CarpenterTrades.wood("oak")));
        map.put(class_3854.field_17072, List.of(CarpenterTrades.wood("jungle"), CarpenterTrades.wood("bamboo")));
        map.put(class_3854.field_17075, List.of(CarpenterTrades.wood("spruce")));
        map.put(class_3854.field_17077, List.of(CarpenterTrades.wood("spruce")));
        map.put(class_3854.field_17074, List.of(CarpenterTrades.wood("acacia")));
        ArrayList<WoodType> desertList = new ArrayList<WoodType>();
        CarpenterTrades.maybeAddWood(desertList, "cactus");
        if (desertList.isEmpty()) {
            desertList.add(CarpenterTrades.wood("jungle"));
        }
        map.put(class_3854.field_17071, desertList);
        ArrayList<WoodType> swampList = new ArrayList<WoodType>();
        CarpenterTrades.maybeAddWood(swampList, "swamp", "cypress");
        if (swampList.isEmpty()) {
            swampList.add(CarpenterTrades.wood("dark_oak"));
        }
        map.put(class_3854.field_17076, swampList);
        return map;
    });

    public static void init() {
        ItemListingManager.registerSerializer((class_2960)SawmillMod.res("wood_item_to_emerald"), WoodToItemListing.CODEC);
        ItemListingManager.registerSerializer((class_2960)SawmillMod.res("log_stripping"), LogStrippingListing.CODEC);
    }

    private static WoodType wood(String name) {
        return WoodTypeRegistry.getValue((class_2960)class_2960.method_60654((String)name));
    }

    private static void maybeAddWood(List<WoodType> list, String ... names) {
        for (WoodType t : WoodTypeRegistry.getTypes()) {
            for (String name : names) {
                if (!t.id.method_12832().contains(name)) continue;
                list.add(t);
            }
        }
    }

    @Nullable
    private static WoodType getTypeSpecificWoodType(class_1297 trader, class_5819 random) {
        if (trader instanceof class_3851) {
            class_3851 d = (class_3851)trader;
            List<WoodType> list = TYPE_MAP.get().getOrDefault(d.method_7231().method_16919(), List.of(WoodTypeRegistry.OAK_TYPE));
            return list.get(random.method_43048(list.size()));
        }
        return null;
    }

    public record WoodToItemListing(boolean buys, String childKey, int woodPrice, class_9306 emeralds, int maxTrades, int xp, float priceMult, int level, boolean typeDependant) implements ModItemListing
    {
        public static final MapCodec<WoodToItemListing> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.BOOL.optionalFieldOf("buys", (Object)true).forGetter(WoodToItemListing::buys), (App)Codec.STRING.fieldOf("wood_block").forGetter(WoodToItemListing::childKey), (App)class_5699.field_33442.fieldOf("wood_block_amount").forGetter(WoodToItemListing::woodPrice), (App)class_9306.field_49393.fieldOf("emeralds").forGetter(WoodToItemListing::emeralds), (App)class_5699.field_33442.optionalFieldOf("max_trades", (Object)16).forGetter(WoodToItemListing::maxTrades), (App)class_5699.field_33442.optionalFieldOf("xp").forGetter(w -> Optional.of(w.xp)), (App)class_5699.field_34387.optionalFieldOf("price_multiplier", (Object)Float.valueOf(0.05f)).forGetter(WoodToItemListing::priceMult), (App)Codec.intRange((int)1, (int)5).optionalFieldOf("level", (Object)1).forGetter(WoodToItemListing::level), (App)Codec.BOOL.optionalFieldOf("type_dependant", (Object)false).forGetter(WoodToItemListing::typeDependant)).apply((Applicative)i, WoodToItemListing::createDefault));

        private static WoodToItemListing createDefault(boolean buys, String wood, int woodAmount, class_9306 emeralds, int maxTrades, Optional<Integer> xp, float priceMult, int level, boolean typeDependant) {
            return new WoodToItemListing(buys, wood, woodAmount, emeralds, maxTrades, xp.orElse(ModItemListing.defaultXp((boolean)buys, (int)level)), priceMult, level, typeDependant);
        }

        public boolean isValid() {
            return WoodTypeRegistry.OAK_TYPE.getItemOfThis(this.childKey) != null;
        }

        public MapCodec<? extends ModItemListing> getCodec() {
            return CODEC;
        }

        @Nullable
        public class_1914 method_7246(class_1297 trader, class_5819 random) {
            WoodType type = null;
            if (this.typeDependant && (type = CarpenterTrades.getTypeSpecificWoodType(trader, random)) == null) {
                return null;
            }
            ArrayList types = new ArrayList(WoodTypeRegistry.getTypes());
            int tries = 0;
            while (tries < 50 && !types.isEmpty()) {
                ++tries;
                if (type == null) {
                    type = (WoodType)types.get(random.method_43048(types.size()));
                }
                types.remove(type);
                class_1792 w = type.getItemOfThis(this.childKey);
                if (w == null) continue;
                class_9306 wood = new class_9306((class_1935)w, this.woodPrice);
                class_9306 emerald = this.emeralds;
                if (wood.comp_2427().method_7960()) {
                    throw new AssertionError((Object)("Wood item is empty. How? Key:" + this.childKey + ", Wood Type:" + String.valueOf(type) + ", ItemStack: " + String.valueOf(wood) + ", Item: " + String.valueOf(w) + ", Block: " + String.valueOf(type.getBlockOfThis(this.childKey))));
                }
                if (this.buys) {
                    return new class_1914(wood, Optional.empty(), emerald.comp_2427(), this.maxTrades, this.xp, this.priceMult);
                }
                return new class_1914(emerald, Optional.empty(), wood.comp_2427(), this.maxTrades, this.xp, this.priceMult);
            }
            return null;
        }

        public int getLevel() {
            return this.level;
        }
    }

    public record LogStrippingListing(class_9306 price, int amount, int maxTrades, int xp, float priceMult, int level) implements ModItemListing
    {
        public static final MapCodec<LogStrippingListing> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)class_9306.field_49393.fieldOf("price").forGetter(LogStrippingListing::price), (App)Codec.INT.fieldOf("amount").forGetter(LogStrippingListing::amount), (App)class_5699.field_33442.optionalFieldOf("max_trades", (Object)16).forGetter(LogStrippingListing::maxTrades), (App)class_5699.field_33442.optionalFieldOf("xp").forGetter(w -> Optional.of(w.xp)), (App)class_5699.field_34387.optionalFieldOf("price_multiplier", (Object)Float.valueOf(0.05f)).forGetter(LogStrippingListing::priceMult), (App)Codec.intRange((int)1, (int)5).optionalFieldOf("level", (Object)1).forGetter(LogStrippingListing::level)).apply((Applicative)i, LogStrippingListing::createDefault));

        private static LogStrippingListing createDefault(class_9306 price, int amount, int maxTrades, Optional<Integer> xp, float priceMult, int level) {
            return new LogStrippingListing(price, amount, maxTrades, xp.orElse(ModItemListing.defaultXp((boolean)false, (int)level)), priceMult, level);
        }

        public MapCodec<? extends ModItemListing> getCodec() {
            return CODEC;
        }

        @Nullable
        public class_1914 method_7246(class_1297 trader, class_5819 random) {
            WoodType type = CarpenterTrades.getTypeSpecificWoodType(trader, random);
            if (type == null) {
                return null;
            }
            class_1792 log = type.log.method_8389();
            class_1792 stripped = type.getItemOfThis("stripped_log");
            if (stripped != null) {
                return new class_1914(new class_9306((class_1935)log, this.amount), Optional.of(this.price), new class_1799((class_1935)stripped, this.amount), this.maxTrades, this.xp, this.priceMult);
            }
            return null;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

