/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import net.minecraft.class_1074;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.JadeIds;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.WailaTickHandler;
import snownee.jade.track.HealthTrackInfo;

public class HealthElement
extends Element {
    public static final class_2960 HEART = class_2960.method_60656((String)"hud/heart/full");
    public static final class_2960 HEART_BLINKING = class_2960.method_60656((String)"hud/heart/full_blinking");
    public static final class_2960 HALF_HEART = class_2960.method_60656((String)"hud/heart/half");
    public static final class_2960 HALF_HEART_BLINKING = class_2960.method_60656((String)"hud/heart/half_blinking");
    public static final class_2960 EMPTY_HEART = class_2960.method_60656((String)"hud/heart/container");
    public static final class_2960 EMPTY_HEART_BLINKING = class_2960.method_60656((String)"hud/heart/container_blinking");
    private final float health;
    private String text;
    private int iconsPerLine = 1;
    private int lineCount = 1;
    private int iconCount = 1;
    private HealthTrackInfo track;

    public HealthElement(float maxHealth, float health) {
        this.health = health;
        if (maxHealth > (float)PluginConfig.INSTANCE.getInt(JadeIds.MC_ENTITY_HEALTH_MAX_FOR_RENDER)) {
            if (!PluginConfig.INSTANCE.get(JadeIds.MC_ENTITY_HEALTH_SHOW_FRACTIONS)) {
                maxHealth = class_3532.method_15386((float)maxHealth);
                health = class_3532.method_15386((float)health);
            }
            this.text = String.format("%s/%s", DisplayHelper.dfCommas.format(health), DisplayHelper.dfCommas.format(maxHealth));
        } else {
            int maxHeartsPerLine = PluginConfig.INSTANCE.getInt(JadeIds.MC_ENTITY_HEALTH_ICONS_PER_LINE);
            this.iconCount = class_3532.method_15386((float)(maxHealth *= 0.5f));
            this.iconsPerLine = Math.min(maxHeartsPerLine, this.iconCount);
            this.lineCount = class_3532.method_15386((float)(maxHealth / (float)maxHeartsPerLine));
        }
    }

    @Override
    public class_241 getSize() {
        if (this.showText()) {
            class_327 font = class_310.method_1551().field_1772;
            return new class_241((float)(font.method_1727(this.text) + 10), 9.0f);
        }
        return new class_241((float)(8 * this.iconsPerLine + 1), (float)(5 + 4 * this.lineCount));
    }

    @Override
    public void render(class_332 guiGraphics, float x, float y, float maxX, float maxY) {
        float health;
        float lastHealth = health = this.health * 0.5f;
        boolean blink = false;
        if (this.track == null && this.getTag() != null) {
            this.track = WailaTickHandler.instance().progressTracker.getOrCreate(this.getTag(), HealthTrackInfo.class, () -> new HealthTrackInfo(this.health));
        }
        if (this.track != null) {
            this.track.setHealth(this.health);
            this.track.update(class_310.method_1551().method_60646().method_60638());
            lastHealth = this.track.getLastHealth() * 0.5f;
            blink = this.track.isBlinking();
        }
        IDisplayHelper helper = IDisplayHelper.get();
        int xOffset = (this.iconCount - 1) % this.iconsPerLine * 8;
        int yOffset = this.lineCount * 4 - 4;
        for (int i = this.iconCount; i > 0; --i) {
            int xPos = (int)(x + (float)xOffset);
            int yPos = (int)(y + (float)yOffset);
            helper.blitSprite(guiGraphics, blink ? EMPTY_HEART_BLINKING : EMPTY_HEART, xPos, yPos, 9, 9);
            if (i <= class_3532.method_15375((float)health)) {
                helper.blitSprite(guiGraphics, HEART, xPos, yPos, 9, 9);
            }
            if ((float)i > health) {
                if (i <= class_3532.method_15375((float)lastHealth)) {
                    helper.blitSprite(guiGraphics, HEART_BLINKING, xPos, yPos, 9, 9);
                } else if ((float)i > lastHealth && (float)i < lastHealth + 1.0f) {
                    helper.blitSprite(guiGraphics, HALF_HEART_BLINKING, xPos, yPos, 9, 9);
                }
                if ((float)i < health + 1.0f) {
                    helper.blitSprite(guiGraphics, HALF_HEART, xPos, yPos, 9, 9);
                }
            }
            if ((xOffset -= 8) >= 0) continue;
            xOffset = this.iconsPerLine * 8 - 8;
            yOffset -= 4;
        }
        if (this.showText()) {
            helper.drawText(guiGraphics, this.text, x + 10.0f, y + 1.0f, IThemeHelper.get().getNormalColor());
        }
    }

    @Override
    @Nullable
    public String getMessage() {
        return class_1074.method_4662((String)"narration.jade.health", (Object[])new Object[]{class_3532.method_15386((float)this.health)});
    }

    public boolean showText() {
        return this.text != null;
    }
}

