/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.levelz.LevelzMain;
import net.levelz.init.ConfigInit;
import net.levelz.level.LevelManager;
import net.levelz.level.Skill;
import net.levelz.level.restriction.PlayerRestriction;
import net.levelz.registry.EnchantmentRegistry;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record RestrictionLoader(class_7225.class_7874 wrapperLookup) implements SimpleSynchronousResourceReloadListener
{
    public static final class_2960 ID = LevelzMain.identifierOf("restriction");
    private static final Logger LOGGER = LogManager.getLogger((String)"LevelZ");
    private static final List<Integer> blockList = new ArrayList<Integer>();
    private static final List<Integer> craftingList = new ArrayList<Integer>();
    private static final List<Integer> entityList = new ArrayList<Integer>();
    private static final List<Integer> itemList = new ArrayList<Integer>();
    private static final List<Integer> miningList = new ArrayList<Integer>();
    private static final List<Integer> enchantmentList = new ArrayList<Integer>();

    public class_2960 getFabricId() {
        return ID;
    }

    public void method_14491(class_3300 manager) {
        LevelManager.BLOCK_RESTRICTIONS.clear();
        LevelManager.CRAFTING_RESTRICTIONS.clear();
        LevelManager.ENTITY_RESTRICTIONS.clear();
        LevelManager.ITEM_RESTRICTIONS.clear();
        LevelManager.MINING_RESTRICTIONS.clear();
        LevelManager.ENCHANTMENT_RESTRICTIONS.clear();
        if (!ConfigInit.CONFIG.restrictions) {
            return;
        }
        EnchantmentRegistry.updateEnchantments(this.wrapperLookup());
        manager.method_14488("restriction", id -> id.method_12832().endsWith(".json")).forEach((id, resourceRef) -> {
            try {
                if (!ConfigInit.CONFIG.defaultRestrictions && id.method_12832().endsWith("/default.json")) {
                    return;
                }
                InputStream stream = resourceRef.method_14482();
                JsonObject data = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
                HashMap<String, Integer> skillKeyIdMap = new HashMap<String, Integer>();
                for (Skill skill : LevelManager.SKILLS.values()) {
                    skillKeyIdMap.put(skill.getKey(), skill.getId());
                }
                for (String mapKey : data.keySet()) {
                    JsonObject restrictionJsonObject = data.getAsJsonObject(mapKey);
                    HashMap<Integer, Integer> skillLevelRestrictions = new HashMap<Integer, Integer>();
                    boolean replace = restrictionJsonObject.has("replace") && restrictionJsonObject.get("replace").getAsBoolean();
                    JsonObject skillRestrictions = restrictionJsonObject.getAsJsonObject("skills");
                    for (String skillKey : skillRestrictions.keySet()) {
                        if (skillKeyIdMap.containsKey(skillKey)) {
                            skillLevelRestrictions.put((Integer)skillKeyIdMap.get(skillKey), skillRestrictions.get(skillKey).getAsInt());
                            continue;
                        }
                        LOGGER.warn("Restriction {} contains an unrecognized skill called {}.", (Object)mapKey, (Object)skillKey);
                    }
                    if (!skillLevelRestrictions.isEmpty()) {
                        if (restrictionJsonObject.has("blocks")) {
                            for (JsonElement blockElement : restrictionJsonObject.getAsJsonArray("blocks")) {
                                class_2960 blockIdentifier = class_2960.method_60654((String)blockElement.getAsString());
                                if (class_7923.field_41175.method_10250(blockIdentifier)) {
                                    int blockRawId = class_7923.field_41175.method_10206((Object)((class_2248)class_7923.field_41175.method_10223(blockIdentifier)));
                                    if (blockList.contains(blockRawId)) continue;
                                    if (replace) {
                                        blockList.add(blockRawId);
                                    }
                                    LevelManager.BLOCK_RESTRICTIONS.put(blockRawId, new PlayerRestriction(blockRawId, skillLevelRestrictions));
                                    continue;
                                }
                                LOGGER.warn("Restriction {} contains an unrecognized block id called {}.", (Object)mapKey, (Object)blockIdentifier);
                            }
                        }
                        if (restrictionJsonObject.has("crafting")) {
                            for (JsonElement craftingElement : restrictionJsonObject.getAsJsonArray("crafting")) {
                                class_2960 craftingIdentifier = class_2960.method_60654((String)craftingElement.getAsString());
                                if (class_7923.field_41178.method_10250(craftingIdentifier)) {
                                    int craftingRawId = class_7923.field_41178.method_10206((Object)((class_1792)class_7923.field_41178.method_10223(craftingIdentifier)));
                                    if (craftingList.contains(craftingRawId)) continue;
                                    if (replace) {
                                        craftingList.add(craftingRawId);
                                    }
                                    LevelManager.CRAFTING_RESTRICTIONS.put(craftingRawId, new PlayerRestriction(craftingRawId, skillLevelRestrictions));
                                    continue;
                                }
                                LOGGER.warn("Restriction {} contains an unrecognized crafting id called {}.", (Object)mapKey, (Object)craftingIdentifier);
                            }
                        }
                        if (restrictionJsonObject.has("entities")) {
                            for (JsonElement entityElement : restrictionJsonObject.getAsJsonArray("entities")) {
                                class_2960 entityIdentifier = class_2960.method_60654((String)entityElement.getAsString());
                                if (class_7923.field_41177.method_10250(entityIdentifier)) {
                                    int entityRawId = class_7923.field_41177.method_10206((Object)((class_1299)class_7923.field_41177.method_10223(entityIdentifier)));
                                    if (entityList.contains(entityRawId)) continue;
                                    if (replace) {
                                        entityList.add(entityRawId);
                                    }
                                    LevelManager.ENTITY_RESTRICTIONS.put(entityRawId, new PlayerRestriction(entityRawId, skillLevelRestrictions));
                                    continue;
                                }
                                LOGGER.warn("Restriction {} contains an unrecognized entity id called {}.", (Object)mapKey, (Object)entityIdentifier);
                            }
                        }
                        if (restrictionJsonObject.has("items")) {
                            for (JsonElement itemElement : restrictionJsonObject.getAsJsonArray("items")) {
                                class_2960 itemIdentifier = class_2960.method_60654((String)itemElement.getAsString());
                                if (class_7923.field_41178.method_10250(itemIdentifier)) {
                                    int itemRawId = class_7923.field_41178.method_10206((Object)((class_1792)class_7923.field_41178.method_10223(itemIdentifier)));
                                    if (itemList.contains(itemRawId)) continue;
                                    if (replace) {
                                        itemList.add(itemRawId);
                                    }
                                    LevelManager.ITEM_RESTRICTIONS.put(itemRawId, new PlayerRestriction(itemRawId, skillLevelRestrictions));
                                    continue;
                                }
                                LOGGER.warn("Restriction {} contains an unrecognized item id called {}.", (Object)mapKey, (Object)itemIdentifier);
                            }
                        }
                        if (restrictionJsonObject.has("mining")) {
                            for (JsonElement miningElement : restrictionJsonObject.getAsJsonArray("mining")) {
                                class_2960 miningIdentifier = class_2960.method_60654((String)miningElement.getAsString());
                                if (class_7923.field_41175.method_10250(miningIdentifier)) {
                                    int miningRawId = class_7923.field_41175.method_10206((Object)((class_2248)class_7923.field_41175.method_10223(miningIdentifier)));
                                    if (miningList.contains(miningRawId)) continue;
                                    if (replace) {
                                        miningList.add(miningRawId);
                                    }
                                    LevelManager.MINING_RESTRICTIONS.put(miningRawId, new PlayerRestriction(miningRawId, skillLevelRestrictions));
                                    continue;
                                }
                                LOGGER.warn("Restriction {} contains an unrecognized mining id called {}.", (Object)mapKey, (Object)miningIdentifier);
                            }
                        }
                        if (restrictionJsonObject.has("enchantments")) {
                            JsonObject enchantmentObject = restrictionJsonObject.getAsJsonObject("enchantments");
                            for (String enchantment : enchantmentObject.keySet()) {
                                int level;
                                class_2960 enchantmentIdentifier = class_2960.method_60654((String)enchantment);
                                if (EnchantmentRegistry.containsId(enchantmentIdentifier, level = enchantmentObject.get(enchantment).getAsInt())) {
                                    int enchantmentRawId = EnchantmentRegistry.getId(enchantmentIdentifier, level);
                                    if (enchantmentList.contains(enchantmentRawId)) continue;
                                    if (replace) {
                                        enchantmentList.add(enchantmentRawId);
                                    }
                                    LevelManager.ENCHANTMENT_RESTRICTIONS.put(enchantmentRawId, new PlayerRestriction(enchantmentRawId, skillLevelRestrictions));
                                    continue;
                                }
                                LOGGER.warn("Restriction {} contains an unrecognized enchantment id called {}.", (Object)mapKey, (Object)enchantmentIdentifier);
                            }
                        }
                        if (!restrictionJsonObject.has("components")) continue;
                        JsonObject componentObject = restrictionJsonObject.getAsJsonObject("components");
                        for (String component : componentObject.keySet()) {
                            class_2960 itemIdentifier = class_2960.method_60654((String)component);
                            if (class_7923.field_41178.method_10250(itemIdentifier)) {
                                if (class_7923.field_49658.method_10250(class_2960.method_60654((String)componentObject.get(component).getAsString()))) {
                                    int n = class_7923.field_41178.method_10206((Object)((class_1792)class_7923.field_41178.method_10223(itemIdentifier)));
                                    continue;
                                }
                                LOGGER.warn("Restriction {} contains an unrecognized component called {}.", (Object)mapKey, (Object)componentObject.get(component).getAsString());
                                continue;
                            }
                            LOGGER.warn("Restriction {} contains an unrecognized item id at component called {}.", (Object)mapKey, (Object)itemIdentifier);
                        }
                        continue;
                    }
                    LOGGER.warn("Restriction {} does not contain any valid skills.", (Object)mapKey);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while loading resource {}. {}", (Object)id.toString(), (Object)e.toString());
            }
        });
    }
}

