/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.levelz.LevelzMain;
import net.levelz.init.ConfigInit;
import net.levelz.level.LevelManager;
import net.levelz.level.Skill;
import net.levelz.level.SkillAttribute;
import net.levelz.level.SkillBonus;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SkillLoader
implements SimpleSynchronousResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger((String)"LevelZ");
    private static List<String> skillList = new ArrayList<String>();

    public class_2960 getFabricId() {
        return LevelzMain.identifierOf("skill");
    }

    public void method_14491(class_3300 manager) {
        int i;
        LevelManager.SKILLS.clear();
        LevelManager.BONUSES.clear();
        AtomicInteger skillCount = new AtomicInteger();
        ArrayList attributeIds = new ArrayList();
        manager.method_14488("skill", id -> id.method_12832().endsWith(".json")).forEach((id, resourceRef) -> {
            try {
                if (!ConfigInit.CONFIG.defaultSkills && id.method_12832().endsWith("/default.json")) {
                    return;
                }
                InputStream stream = resourceRef.method_14482();
                JsonObject data = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
                for (String mapKey : data.keySet()) {
                    int identification;
                    JsonObject skillJsonObject = data.getAsJsonObject(mapKey);
                    if (skillList.contains(skillJsonObject.get("id").getAsString())) {
                        LOGGER.warn("Skill {} was already loaded.", (Object)skillJsonObject.get("id").getAsString());
                        continue;
                    }
                    if (skillJsonObject.has("replace") && skillJsonObject.get("replace").getAsBoolean()) {
                        skillList.add(skillJsonObject.get("id").getAsString());
                    }
                    if (LevelManager.SKILLS.containsKey(identification = skillJsonObject.get("id").getAsInt())) {
                        LOGGER.warn("Id {} in skill {} was already used by another skill.", (Object)identification, (Object)skillJsonObject.get("id").getAsString());
                        continue;
                    }
                    String key = skillJsonObject.get("key").getAsString();
                    int maxLevel = skillJsonObject.get("level").getAsInt();
                    ArrayList<SkillAttribute> attributes = new ArrayList<SkillAttribute>();
                    for (JsonElement attributeElement : skillJsonObject.getAsJsonArray("attributes")) {
                        JsonObject attributeJsonObject = attributeElement.getAsJsonObject();
                        Optional entityAttribute = class_7923.field_41190.method_55841(class_2960.method_60654((String)attributeJsonObject.get("type").getAsString()));
                        if (entityAttribute.isPresent()) {
                            int attributeId = -1;
                            if (attributeJsonObject.has("id")) {
                                attributeId = attributeJsonObject.get("id").getAsInt();
                            }
                            class_6880 attibute = (class_6880)entityAttribute.get();
                            float baseValue = -10000.0f;
                            if (attributeJsonObject.has("base")) {
                                baseValue = attributeJsonObject.get("base").getAsFloat();
                            }
                            float levelValue = attributeJsonObject.get("value").getAsFloat();
                            class_1322.class_1323 operation = class_1322.class_1323.valueOf((String)attributeJsonObject.get("operation").getAsString().toUpperCase());
                            attributes.add(new SkillAttribute(attributeId, (class_6880<class_1320>)attibute, baseValue, levelValue, operation));
                            if (attributeId == -1) continue;
                            attributeIds.add(attributeId);
                            continue;
                        }
                        LOGGER.warn("Attribute {} is not a usable attribute in skill {}.", (Object)attributeJsonObject.get("type").getAsString(), (Object)skillJsonObject.get("id").getAsString());
                    }
                    if (skillJsonObject.has("bonus")) {
                        for (JsonElement attributeElement : skillJsonObject.getAsJsonArray("bonus")) {
                            JsonObject bonusJsonObject = attributeElement.getAsJsonObject();
                            String bonusKey = bonusJsonObject.get("key").getAsString();
                            int bonusLevel = bonusJsonObject.get("level").getAsInt();
                            if (!SkillBonus.BONUS_KEYS.contains(bonusKey)) {
                                LOGGER.warn("Bonus type {} is not a valid bonus type.", (Object)bonusKey);
                                continue;
                            }
                            LevelManager.BONUSES.put(bonusKey, new SkillBonus(bonusKey, identification, bonusLevel));
                        }
                    }
                    LevelManager.SKILLS.put(identification, new Skill(identification, key, maxLevel, attributes));
                    skillCount.getAndIncrement();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while loading resource {}. {}", (Object)id.toString(), (Object)e.toString());
            }
        });
        for (i = 0; i < skillCount.get(); ++i) {
            if (LevelManager.SKILLS.containsKey(i)) continue;
            throw new MissingResourceException("Missing skill with id " + i + "! Please add a skill with this id.", this.getClass().getName(), "LevelZ");
        }
        for (i = 0; i < attributeIds.size(); ++i) {
            if (attributeIds.contains(i)) continue;
            throw new MissingResourceException("Missing attribute with id " + i + "! Please add an attribute with this id.", this.getClass().getName(), "LevelZ");
        }
        TreeMap<Integer, Skill> sortedMap = new TreeMap<Integer, Skill>(LevelManager.SKILLS);
        LevelManager.SKILLS.clear();
        LevelManager.SKILLS.putAll(sortedMap);
    }
}

