/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.mixin.player;

import net.levelz.access.LevelManagerAccess;
import net.levelz.access.PlayerDropAccess;
import net.levelz.entity.LevelExperienceOrbEntity;
import net.levelz.init.ConfigInit;
import net.levelz.level.LevelManager;
import net.levelz.util.BonusHelper;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_4174;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements LevelManagerAccess,
PlayerDropAccess {
    private final class_1657 playerEntity = (class_1657)this;
    @Unique
    private final LevelManager levelManager = new LevelManager(this.playerEntity);
    @Unique
    private int killedMobsInChunk;
    @Unique
    @Nullable
    private class_2791 killedMobChunk;

    public PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    public void readCustomDataFromNbtMixin(class_2487 nbt, CallbackInfo info) {
        this.levelManager.readNbt(nbt);
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    public void writeCustomDataToNbtMixin(class_2487 nbt, CallbackInfo info) {
        this.levelManager.writeNbt(nbt);
    }

    @ModifyVariable(method={"addExhaustion"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/HungerManager;addExhaustion(F)V"), ordinal=0, argsOnly=true)
    private float addExhaustionMixin(float original) {
        return original *= BonusHelper.exhaustionReductionBonus(this.playerEntity);
    }

    @ModifyVariable(method={"attack"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/item/Item;getBonusAttackDamage(Lnet/minecraft/entity/Entity;FLnet/minecraft/entity/damage/DamageSource;)F"), ordinal=0)
    private boolean attackKnockbackkMixin(boolean original) {
        if (!original && BonusHelper.meleeKnockbackAttackChanceBonus(this.playerEntity)) {
            return true;
        }
        return original;
    }

    @ModifyVariable(method={"attack"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/item/Item;getBonusAttackDamage(Lnet/minecraft/entity/Entity;FLnet/minecraft/entity/damage/DamageSource;)F"), ordinal=1)
    private boolean attackCriticalMixin(boolean original) {
        if (!original && BonusHelper.meleeCriticalAttackChanceBonus(this.playerEntity)) {
            return true;
        }
        return original;
    }

    @ModifyVariable(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getWeaponStack()Lnet/minecraft/item/ItemStack;"), ordinal=0)
    private float attackMixin(float original) {
        if (this.playerEntity.method_7337()) {
            return original;
        }
        if (!this.levelManager.hasRequiredItemLevel(this.method_59958().method_7909())) {
            return 0.0f;
        }
        return original;
    }

    @ModifyVariable(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;playSound(Lnet/minecraft/entity/player/PlayerEntity;DDDLnet/minecraft/sound/SoundEvent;Lnet/minecraft/sound/SoundCategory;FF)V", ordinal=0), ordinal=0)
    private float attackCriticalDamageMixin(float original) {
        return original += BonusHelper.meleeCriticalDamageBonus(this.playerEntity);
    }

    @ModifyVariable(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;getVelocity()Lnet/minecraft/util/math/Vec3d;"), ordinal=3)
    private float attackDoubleDamageMixin(float original) {
        if (BonusHelper.meleeDoubleDamageBonus(this.playerEntity)) {
            original *= 2.0f;
        }
        return original;
    }

    @Inject(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;dropShoulderEntities()V")}, cancellable=true)
    private void damageMixin(class_1282 source, float amount, CallbackInfoReturnable<Boolean> info) {
        BonusHelper.damageReflectionBonus(this.playerEntity, source, amount);
        if (!source.method_48789(class_8103.field_42242) && BonusHelper.evadingDamageBonus(this.playerEntity)) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"eatFood"}, at={@At(value="HEAD")})
    private void eatFoodMixin(class_1937 world, class_1799 stack, class_4174 foodComponent, CallbackInfoReturnable<class_1799> info) {
        BonusHelper.foodIncreasionBonus(this.playerEntity, stack);
    }

    @Shadow
    public abstract class_1799 method_59958();

    @Override
    public LevelManager getLevelManager() {
        return this.levelManager;
    }

    @Override
    public void increaseKilledMobStat(class_2791 chunk) {
        if (this.killedMobChunk != null && this.killedMobChunk == chunk) {
            ++this.killedMobsInChunk;
        } else {
            this.killedMobChunk = chunk;
            this.killedMobsInChunk = 0;
        }
    }

    @Override
    public void resetKilledMobStat() {
        this.killedMobsInChunk = 0;
    }

    @Override
    public boolean allowMobDrop() {
        return this.killedMobsInChunk < ConfigInit.CONFIG.mobKillCount;
    }

    protected void method_23883(@Nullable class_1297 attacker) {
        class_1937 class_19372 = this.playerEntity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (this.method_6054() && this.method_37908().method_8450().method_8355(class_1928.field_19391) && ConfigInit.CONFIG.resetCurrentXp) {
                LevelExperienceOrbEntity.spawn(serverWorld, this.method_19538(), (int)(this.levelManager.getLevelProgress() * (float)this.levelManager.getNextLevelExperience()));
            }
        }
        super.method_23883(attacker);
    }
}

