/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.levelz.registry.EnchantmentZ;
import net.minecraft.class_1887;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public class EnchantmentRegistry {
    public static final Map<Integer, EnchantmentZ> ENCHANTMENTS = new HashMap<Integer, EnchantmentZ>();
    public static final Map<String, Integer> INDEX_ENCHANTMENTS = new HashMap<String, Integer>();

    public static boolean containsId(class_6880<class_1887> enchantment, int level) {
        return EnchantmentRegistry.containsId(enchantment.toString(), level);
    }

    public static boolean containsId(class_2960 identifier, int level) {
        return EnchantmentRegistry.containsId(identifier.toString(), level);
    }

    public static boolean containsId(String enchantment, int level) {
        return INDEX_ENCHANTMENTS.containsKey(enchantment + level);
    }

    public static EnchantmentZ getEnchantmentZ(int key) {
        return ENCHANTMENTS.get(key);
    }

    public static int getId(class_6880<class_1887> enchantment, int level) {
        return EnchantmentRegistry.getId(enchantment.method_55840(), level);
    }

    public static int getId(class_2960 identifier, int level) {
        return EnchantmentRegistry.getId(identifier.toString(), level);
    }

    public static int getId(String enchantment, int level) {
        return EnchantmentRegistry.getId(enchantment + level);
    }

    private static int getId(String enchantment) {
        if (INDEX_ENCHANTMENTS.containsKey(enchantment)) {
            return INDEX_ENCHANTMENTS.get(enchantment);
        }
        return -1;
    }

    public static void updateEnchantments(class_7225.class_7874 wrapperLookup) {
        ENCHANTMENTS.clear();
        INDEX_ENCHANTMENTS.clear();
        Optional wrapper = wrapperLookup.method_46759(class_7924.field_41265);
        for (class_7225.class_7226 enchantmentImpl : wrapper.stream().toList()) {
            for (class_6880.class_6883 enchantment : enchantmentImpl.method_42017().toList()) {
                for (int i = 1; i <= ((class_1887)enchantment.comp_349()).method_8183(); ++i) {
                    INDEX_ENCHANTMENTS.put(enchantment.method_55840() + i, ENCHANTMENTS.size());
                    ENCHANTMENTS.put(ENCHANTMENTS.size(), new EnchantmentZ((class_6880<class_1887>)enchantment, i));
                }
            }
        }
    }
}

