/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.levelz.LevelzMain;
import net.levelz.access.ClientPlayerAccess;
import net.levelz.access.LevelManagerAccess;
import net.levelz.init.ConfigInit;
import net.levelz.init.KeyInit;
import net.levelz.level.LevelManager;
import net.levelz.level.Skill;
import net.levelz.level.SkillAttribute;
import net.levelz.network.packet.AttributeSyncPacket;
import net.levelz.network.packet.StatPacket;
import net.levelz.screen.SkillInfoScreen;
import net.levelz.screen.SkillRestrictionScreen;
import net.libz.api.Tab;
import net.libz.util.DrawTabHelper;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class LevelScreen
extends class_437
implements Tab {
    public static final class_2960 BACKGROUND_TEXTURE = LevelzMain.identifierOf("textures/gui/skill_background.png");
    public static final class_2960 ATTRIBUTE_BACKGROUND_TEXTURE = LevelzMain.identifierOf("textures/gui/attribute_background.png");
    public static final class_2960 ICON_TEXTURE = LevelzMain.identifierOf("textures/gui/icons.png");
    private final int backgroundWidth = 200;
    private final int backgroundHeight = 215;
    private int x;
    private int y;
    private LevelManager levelManager;
    private class_746 clientPlayerEntity;
    private Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI).rotateLocalY(2.7f);
    private boolean turnClientPlayer = false;
    private List<SkillAttribute> attributes = new ArrayList<SkillAttribute>();
    private boolean showAttributes = false;
    private int attributeRow = 0;
    private final WidgetButtonPage[] levelButtons = new WidgetButtonPage[12];
    private int skillRow = 0;

    public LevelScreen() {
        super((class_2561)class_2561.method_43471((String)"screen.levelz.skill_screen"));
    }

    protected void method_25426() {
        int i;
        super.method_25426();
        ClientPlayNetworking.send((class_8710)new AttributeSyncPacket());
        this.x = (this.field_22789 - this.backgroundWidth) / 2;
        this.y = (this.field_22790 - this.backgroundHeight) / 2;
        this.levelManager = ((LevelManagerAccess)this.field_22787.field_1724).getLevelManager();
        this.clientPlayerEntity = this.field_22787.field_1761.method_2901(this.field_22787.field_1687, this.field_22787.field_1724.method_3143(), this.field_22787.field_1724.method_3130(), false, false);
        ((ClientPlayerAccess)this.clientPlayerEntity).setShouldRenderClientName(false);
        for (class_1304 equipmentSlot : class_1304.values()) {
            if (this.field_22787.field_1724.method_6118(equipmentSlot).method_7960()) continue;
            this.clientPlayerEntity.method_5673(equipmentSlot, this.field_22787.field_1724.method_6118(equipmentSlot));
        }
        HashMap<Integer, SkillAttribute> skillAttributes = new HashMap<Integer, SkillAttribute>();
        int attributeCount = 0;
        for (Skill skill : LevelManager.SKILLS.values()) {
            for (SkillAttribute skillAttribute : skill.getAttributes()) {
                if (skillAttribute.getId() < 0) continue;
                skillAttributes.put(skillAttribute.getId(), skillAttribute);
                ++attributeCount;
            }
        }
        for (i = 0; i < attributeCount; ++i) {
            this.attributes.add((SkillAttribute)skillAttributes.get(i));
        }
        for (i = 0; i < 12 && this.levelManager.getPlayerSkills().size() > i; ++i) {
            int skillId = i;
            this.levelButtons[i] = (WidgetButtonPage)this.method_37063((class_364)new WidgetButtonPage(this.x + (i % 2 == 0 ? 80 : 169), this.y + 91 + i / 2 * 20, 13, 13, 33, 42, true, true, null, button -> ClientPlayNetworking.send((class_8710)new StatPacket(this.skillRow * 2 + skillId, 1))));
        }
        this.updateLevelButtons();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            class_5250 title = class_2561.method_43469((String)"text.levelz.gui.title", (Object[])new Object[]{this.field_22787.field_1724.method_5477().getString()});
            context.method_51439(this.field_22793, (class_2561)title, this.x + 118 - this.field_22793.method_27525((class_5348)title) / 2, this.y + 7, 0x3F3F3F, false);
            if (!this.attributes.isEmpty()) {
                if (this.showAttributes) {
                    context.method_25302(ICON_TEXTURE, this.x + 178, this.y + 5, 30, 114, 15, 13);
                    context.method_25302(ATTRIBUTE_BACKGROUND_TEXTURE, this.x + 202, this.y, 0, 0, 82, 215);
                    int maxAttributes = Math.min(this.attributes.size(), 15);
                    if (this.attributes.size() > 15) {
                        int scrollLevels = this.attributes.size() - 15;
                        int sliderY = this.attributeRow * 158 / scrollLevels;
                        context.method_25302(ATTRIBUTE_BACKGROUND_TEXTURE, this.x + 270, this.y + 8 + sliderY, 82, 0, 6, 41);
                    } else {
                        context.method_25302(ATTRIBUTE_BACKGROUND_TEXTURE, this.x + 270, this.y + 8, 88, 0, 6, 41);
                    }
                    context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"text.levelz.gui.attributes"), this.x + 214, this.y + 12, 0xE0E0E0, false);
                    int k = 27;
                    for (int i = this.attributeRow; i < this.attributeRow + maxAttributes; ++i) {
                        String attributeKey = this.attributes.get(i).getAttibute().method_55840();
                        if (attributeKey.contains(":")) {
                            attributeKey = attributeKey.split(":")[1];
                        }
                        context.method_25290(LevelzMain.identifierOf("textures/gui/sprites/" + attributeKey + ".png"), this.x + 214, this.y + k, 0.0f, 0.0f, 9, 9, 9, 9);
                        float attributeValue = (float)Math.round(this.field_22787.field_1724.method_5996(this.attributes.get(i).getAttibute()).method_6194() * 100.0) / 100.0f;
                        context.method_51439(this.field_22793, class_2561.method_30163((String)String.valueOf(attributeValue)), this.x + 214 + 15, this.y + k, 0xE0E0E0, false);
                        k += 12;
                    }
                } else {
                    context.method_25302(ICON_TEXTURE, this.x + 178, this.y + 5, 15, 114, 15, 13);
                }
                if (LevelScreen.isPointWithinBounds(this.x + 178, this.y + 5, 15, 13, mouseX, mouseY)) {
                    context.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"text.levelz.gui.attributes"), mouseX, mouseY);
                }
            } else {
                context.method_25302(ICON_TEXTURE, this.x + 178, this.y + 5, 0, 114, 15, 13);
            }
            class_5250 skillLevelText = class_2561.method_43469((String)"text.levelz.gui.level", (Object[])new Object[]{this.levelManager.getOverallLevel()});
            context.method_51439(this.field_22793, (class_2561)skillLevelText, this.x + 62, this.y + 42, 0x3F3F3F, false);
            class_5250 skillPointText = class_2561.method_43469((String)"text.levelz.gui.points", (Object[])new Object[]{this.levelManager.getSkillPoints()});
            context.method_51439(this.field_22793, (class_2561)skillPointText, this.x + 62, this.y + 54, 0x3F3F3F, false);
            context.method_25302(ICON_TEXTURE, this.x + 62, this.y + 21, 0, 100, 131, 5);
            int nextLevelExperience = this.levelManager.getNextLevelExperience();
            float levelProgress = this.levelManager.getLevelProgress();
            long experience = (int)((float)nextLevelExperience * levelProgress);
            context.method_25302(ICON_TEXTURE, this.x + 62, this.y + 21, 0, 105, (int)(130.0f * levelProgress), 5);
            class_5250 currentXpText = class_2561.method_43469((String)"text.levelz.gui.current_xp", (Object[])new Object[]{experience, nextLevelExperience});
            context.method_51439(this.field_22793, (class_2561)currentXpText, this.x - this.field_22793.method_27525((class_5348)currentXpText) / 2 + 127, this.y + 30, 0x3F3F3F, false);
            if (!LevelManager.CRAFTING_RESTRICTIONS.isEmpty()) {
                if (LevelScreen.isPointWithinBounds(this.x + 178, this.y + 29, 14, 13, mouseX, mouseY)) {
                    context.method_25302(ICON_TEXTURE, this.x + 178, this.y + 29, 30, 80, 15, 13);
                    context.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"restriction.levelz.crafting"), mouseX, mouseY);
                } else {
                    context.method_25302(ICON_TEXTURE, this.x + 178, this.y + 29, 15, 80, 15, 13);
                }
            } else {
                context.method_25302(ICON_TEXTURE, this.x + 178, this.y + 29, 0, 80, 15, 13);
            }
            if (!LevelManager.MINING_RESTRICTIONS.isEmpty()) {
                if (LevelScreen.isPointWithinBounds(this.x + 178, this.y + 45, 14, 13, mouseX, mouseY)) {
                    context.method_25302(ICON_TEXTURE, this.x + 178, this.y + 45, 75, 80, 15, 13);
                    context.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"restriction.levelz.mining"), mouseX, mouseY);
                } else {
                    context.method_25302(ICON_TEXTURE, this.x + 178, this.y + 45, 60, 80, 15, 13);
                }
            } else {
                context.method_25302(ICON_TEXTURE, this.x + 178, this.y + 45, 45, 80, 15, 13);
            }
        }
        if (this.clientPlayerEntity != null) {
            class_490.method_48472((class_332)context, (float)(this.x + 33), (float)(this.y + 43), (float)30.0f, (Vector3f)new Vector3f(0.0f, this.clientPlayerEntity.method_17682() / 2.0f, 0.0f), (Quaternionf)this.quaternionf, null, (class_1309)this.clientPlayerEntity);
            if (LevelScreen.isPointWithinBounds(this.x + 9, this.y + 67, 15, 10, mouseX, mouseY)) {
                context.method_25302(ICON_TEXTURE, this.x + 9, this.y + 67, 0, 138, 15, 10);
            } else {
                context.method_25302(ICON_TEXTURE, this.x + 9, this.y + 67, 0, 128, 15, 10);
            }
            if (LevelScreen.isPointWithinBounds(this.x + 41, this.y + 67, 15, 10, mouseX, mouseY)) {
                context.method_25302(ICON_TEXTURE, this.x + 41, this.y + 67, 15, 138, 15, 10);
            } else {
                context.method_25302(ICON_TEXTURE, this.x + 41, this.y + 67, 15, 128, 15, 10);
            }
        }
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_52752(context);
        context.method_25302(BACKGROUND_TEXTURE, this.x, this.y, 0, 0, this.backgroundWidth, this.backgroundHeight);
        for (int i = 0; i < 12; ++i) {
            int skillId = i + this.skillRow * 2;
            if (LevelManager.SKILLS.size() <= skillId || this.levelManager.getPlayerSkills().size() <= skillId) break;
            context.method_25302(BACKGROUND_TEXTURE, this.x + (i % 2 == 0 ? 8 : 96), this.y + 87 + i / 2 * 20, 0, 215, 88, 20);
            context.method_25290(LevelzMain.identifierOf("textures/gui/sprites/" + LevelManager.SKILLS.get(skillId).getKey() + ".png"), this.x + (i % 2 == 0 ? 11 : 99), this.y + 89 + i / 2 * 20, 0.0f, 0.0f, 16, 16, 16, 16);
            class_5250 skillLevel = class_2561.method_43469((String)"text.levelz.gui.current_level", (Object[])new Object[]{this.levelManager.getSkillLevel(skillId), LevelManager.SKILLS.get(skillId).getMaxLevel()});
            context.method_51439(this.field_22793, (class_2561)skillLevel, this.x + (i % 2 == 0 ? 53 : 141) - this.field_22793.method_27525((class_5348)skillLevel) / 2, this.y + 94 + i / 2 * 20, 0x3F3F3F, false);
            if (!LevelScreen.isPointWithinBounds(this.x + (i % 2 == 0 ? 11 : 99), this.y + 89 + i / 2 * 20, 16, 16, mouseX, mouseY)) continue;
            context.method_51438(this.field_22793, LevelManager.SKILLS.get(skillId).getText(), mouseX, mouseY);
        }
        if (this.levelManager.getPlayerSkills().size() > 12) {
            int scrollLevels = (this.levelManager.getPlayerSkills().size() - 12) / 2;
            if (this.levelManager.getPlayerSkills().size() % 2 != 0) {
                ++scrollLevels;
            }
            int sliderY = this.skillRow * 86 / scrollLevels;
            context.method_25302(BACKGROUND_TEXTURE, this.x + 186, this.y + 87 + sliderY, 200, 0, 6, 34);
        } else {
            context.method_25302(BACKGROUND_TEXTURE, this.x + 186, this.y + 87, 206, 0, 6, 34);
        }
        DrawTabHelper.drawTab((class_310)this.field_22787, (class_332)context, (class_437)this, (int)this.x, (int)this.y, (int)mouseX, (int)mouseY);
    }

    public void method_25393() {
        super.method_25393();
        if (this.clientPlayerEntity != null && this.turnClientPlayer) {
            double mouseY;
            double mouseX = this.field_22787.field_1729.method_1603() * (double)this.field_22787.method_22683().method_4486() / (double)this.field_22787.method_22683().method_4480();
            if (LevelScreen.isPointWithinBounds(this.x + 9, this.y + 67, 15, 10, mouseX, mouseY = this.field_22787.field_1729.method_1604() * (double)this.field_22787.method_22683().method_4502() / (double)this.field_22787.method_22683().method_4507())) {
                this.quaternionf.rotateLocalY(0.087f);
            } else if (LevelScreen.isPointWithinBounds(this.x + 41, this.y + 67, 15, 10, mouseX, mouseY)) {
                this.quaternionf.rotateLocalY(-0.087f);
            } else {
                this.turnClientPlayer = false;
            }
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (KeyInit.screenKey.method_1417(keyCode, scanCode) || Objects.requireNonNull(this.field_22787).field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.turnClientPlayer) {
            this.turnClientPlayer = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        DrawTabHelper.onTabButtonClick((class_310)this.field_22787, (class_437)this, (int)this.x, (int)this.y, (double)mouseX, (double)mouseY, (this.method_25399() != null ? 1 : 0) != 0);
        if (!this.attributes.isEmpty() && LevelScreen.isPointWithinBounds(this.x + 178, this.y + 5, 15, 13, mouseX, mouseY)) {
            this.showAttributes = !this.showAttributes;
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            return true;
        }
        if (!LevelManager.CRAFTING_RESTRICTIONS.isEmpty() && LevelScreen.isPointWithinBounds(this.x + 178, this.y + 29, 14, 13, mouseX, mouseY)) {
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            this.field_22787.method_1507((class_437)new SkillRestrictionScreen(this.levelManager, LevelManager.CRAFTING_RESTRICTIONS, (class_2561)class_2561.method_43471((String)"restriction.levelz.crafting"), 0));
            return true;
        }
        if (!LevelManager.MINING_RESTRICTIONS.isEmpty() && LevelScreen.isPointWithinBounds(this.x + 178, this.y + 45, 14, 13, mouseX, mouseY)) {
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            this.field_22787.method_1507((class_437)new SkillRestrictionScreen(this.levelManager, LevelManager.MINING_RESTRICTIONS, (class_2561)class_2561.method_43471((String)"restriction.levelz.mining"), 1));
            return true;
        }
        if (this.clientPlayerEntity != null) {
            if (LevelScreen.isPointWithinBounds(this.x + 9, this.y + 67, 15, 10, mouseX, mouseY)) {
                this.turnClientPlayer = true;
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                return true;
            }
            if (LevelScreen.isPointWithinBounds(this.x + 41, this.y + 67, 15, 10, mouseX, mouseY)) {
                this.turnClientPlayer = true;
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                return true;
            }
        }
        for (int i = 0; i < 12; ++i) {
            int skillId = i + this.skillRow * 2;
            if (LevelManager.SKILLS.size() <= skillId || this.levelManager.getPlayerSkills().size() <= skillId) break;
            if (!LevelScreen.isPointWithinBounds(this.x + (i % 2 == 0 ? 11 : 99), this.y + 89 + i / 2 * 20, 16, 16, mouseX, mouseY)) continue;
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            this.field_22787.method_1507((class_437)new SkillInfoScreen(this.levelManager, skillId));
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.showAttributes && this.attributes.size() > 15 && LevelScreen.isPointWithinBounds(this.x + 209, this.y + 7, 68, 201, mouseX, mouseY)) {
            int maxAttributeRow = this.attributes.size() - 15;
            int newAttributeRow = this.attributeRow;
            this.attributeRow = (newAttributeRow -= (int)verticalAmount) < 0 ? 0 : Math.min(newAttributeRow, maxAttributeRow);
        }
        if (this.levelManager.getPlayerSkills().size() > 12 && LevelScreen.isPointWithinBounds(this.x + 7, this.y + 86, 186, 122, mouseX, mouseY)) {
            int maxSkillRow = (this.levelManager.getPlayerSkills().size() - 12) / 2;
            if (this.levelManager.getPlayerSkills().size() % 2 != 0) {
                ++maxSkillRow;
            }
            int oldSkillRow = this.skillRow;
            int newSkillRow = this.skillRow;
            this.skillRow = (newSkillRow -= (int)verticalAmount) < 0 ? 0 : Math.min(newSkillRow, maxSkillRow);
            if (oldSkillRow != this.skillRow) {
                this.updateLevelButtons();
            }
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25421() {
        return false;
    }

    public void updateLevelButtons() {
        for (int i = 0; i < this.levelButtons.length && this.levelManager.getPlayerSkills().size() > i; ++i) {
            int skillId = i + this.skillRow * 2;
            if (LevelManager.SKILLS.size() <= skillId) {
                this.levelButtons[i].field_22764 = false;
                return;
            }
            this.levelButtons[i].field_22764 = true;
            this.levelButtons[i].field_22763 = ConfigInit.CONFIG.overallMaxLevel > 0 && this.levelManager.getOverallLevel() >= ConfigInit.CONFIG.overallMaxLevel ? false : (LevelManager.SKILLS.get(skillId).getMaxLevel() <= this.levelManager.getPlayerSkills().get(skillId).getLevel() ? false : this.levelManager.getSkillPoints() > 0);
        }
    }

    public static boolean isPointWithinBounds(int x, int y, int width, int height, double pointX, double pointY) {
        return pointX >= (double)(x - 1) && pointX < (double)(x + width + 1) && pointY >= (double)(y - 1) && pointY < (double)(y + height + 1);
    }

    private static class WidgetButtonPage
    extends class_4185 {
        private final boolean hoverOutline;
        private final boolean clickable;
        private final int textureX;
        private final int textureY;
        private List<class_2561> tooltip = new ArrayList<class_2561>();
        private int clickedKey = -1;

        public WidgetButtonPage(int x, int y, int sizeX, int sizeY, int textureX, int textureY, boolean hoverOutline, boolean clickable, @Nullable class_2561 tooltip, class_4185.class_4241 onPress) {
            super(x, y, sizeX, sizeY, class_5244.field_39003, onPress, field_40754);
            this.hoverOutline = hoverOutline;
            this.clickable = clickable;
            this.textureX = textureX;
            this.textureY = textureY;
            this.field_22758 = sizeX;
            this.field_22759 = sizeY;
            if (tooltip != null) {
                this.tooltip.add(tooltip);
            }
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            class_310 minecraftClient = class_310.method_1551();
            context.method_51422(1.0f, 1.0f, 1.0f, this.field_22765);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            int i = this.hoverOutline ? this.getTextureY() : 0;
            context.method_25302(ICON_TEXTURE, this.method_46426(), this.method_46427(), this.textureX + i * this.field_22758, this.textureY, this.field_22758, this.field_22759);
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            if (this.method_49606()) {
                context.method_51434(minecraftClient.field_1772, this.tooltip, mouseX, mouseY);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            this.clickedKey = button;
            if (!this.clickable) {
                return false;
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        protected boolean method_25351(int button) {
            return super.method_25351(button) || button == 1 || button == 2;
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (!this.clickable) {
                return false;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        public void addTooltip(class_2561 text) {
            this.tooltip.add(text);
        }

        public boolean wasMiddleButtonClicked() {
            return this.clickedKey == 2;
        }

        public boolean wasRightButtonClicked() {
            return this.clickedKey == 1;
        }

        private int getTextureY() {
            int i = 1;
            if (!this.field_22763) {
                i = 0;
            } else if (this.method_49606()) {
                i = 2;
            }
            return i;
        }
    }
}

