/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture;

import com.mojang.serialization.Codec;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import me.chrr.camerapture.ByteCollector;
import me.chrr.camerapture.DownloadQueue;
import me.chrr.camerapture.PlatformAdapter;
import me.chrr.camerapture.config.ConfigManager;
import me.chrr.camerapture.entity.PictureFrameEntity;
import me.chrr.camerapture.gui.AlbumLecternScreenHandler;
import me.chrr.camerapture.gui.AlbumScreenHandler;
import me.chrr.camerapture.gui.PictureFrameScreenHandler;
import me.chrr.camerapture.item.AlbumItem;
import me.chrr.camerapture.item.CameraItem;
import me.chrr.camerapture.item.PictureCloningRecipe;
import me.chrr.camerapture.item.PictureItem;
import me.chrr.camerapture.net.NetworkAdapter;
import me.chrr.camerapture.net.clientbound.PictureErrorPacket;
import me.chrr.camerapture.net.clientbound.RequestUploadPacket;
import me.chrr.camerapture.net.serverbound.NewPicturePacket;
import me.chrr.camerapture.net.serverbound.RequestDownloadPacket;
import me.chrr.camerapture.net.serverbound.UploadPartialPicturePacket;
import me.chrr.camerapture.picture.ServerPictureStore;
import me.chrr.camerapture.picture.StoredPicture;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1866;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_7699;
import net.minecraft.class_9135;
import net.minecraft.class_9331;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Camerapture {
    public static final String MOD_ID = "camerapture";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Executor EXECUTOR = runnable -> new Thread(runnable, "Camerapture Worker").start();
    public static final ConfigManager CONFIG_MANAGER = new ConfigManager();
    public static final PlatformAdapter PLATFORM = ServiceLoader.load(PlatformAdapter.class).iterator().next();
    public static final NetworkAdapter NETWORK = PLATFORM.createNetworkAdapter();
    public static final int SECTION_SIZE = 30000;
    public static class_1792 CAMERA = new CameraItem();
    public static final class_3414 CAMERA_SHUTTER = class_3414.method_47908((class_2960)Camerapture.id("camera_shutter"));
    public static final class_2960 PICTURES_TAKEN = Camerapture.id("pictures_taken");
    public static class_1792 PICTURE = new PictureItem();
    public static final class_1866<PictureCloningRecipe> PICTURE_CLONING = new class_1866(PictureCloningRecipe::new);
    public static final class_1792 ALBUM = new AlbumItem();
    public static final class_3917<AlbumScreenHandler> ALBUM_SCREEN_HANDLER = new class_3917(AlbumScreenHandler::new, class_7699.method_45397());
    public static final class_3917<AlbumLecternScreenHandler> ALBUM_LECTERN_SCREEN_HANDLER = new class_3917((syncId, playerInventory) -> new AlbumLecternScreenHandler(syncId), class_7699.method_45397());
    public static final class_1299<PictureFrameEntity> PICTURE_FRAME = class_1299.class_1300.method_5903(PictureFrameEntity::new, (class_1311)class_1311.field_17715).method_27299(10).method_5905("picture_frame");
    public static final class_3917<PictureFrameScreenHandler> PICTURE_FRAME_SCREEN_HANDLER = new class_3917((syncId, pi) -> new PictureFrameScreenHandler(syncId), class_7699.method_45397());
    public static final class_9331<PictureItem.PictureData> PICTURE_DATA = class_9331.method_57873().method_57881(PictureItem.PictureData.CODEC).method_57882(PictureItem.PictureData.PACKET_CODEC).method_57880();
    public static final class_9331<Boolean> CAMERA_ACTIVE = class_9331.method_57873().method_57881((Codec)Codec.BOOL).method_57882(class_9135.field_48547).method_57880();

    public static void registerPacketHandlers() {
        NETWORK.onReceiveFromClient(NewPicturePacket.class, (packet, player) -> {
            CameraItem.HeldCamera camera = CameraItem.find((class_1657)player, false);
            if (camera == null) {
                return;
            }
            if (!player.method_7337() && class_1262.method_29234((class_1263)player.method_31548(), stack -> stack.method_31574(class_1802.field_8407), (int)1, (boolean)false) != 1) {
                return;
            }
            if (CameraItem.isActive(camera.stack())) {
                player.method_51469().method_43129(null, (class_1297)player, CAMERA_SHUTTER, class_3419.field_15248, 1.0f, 1.0f);
            }
            CameraItem.setActive(camera.stack(), false);
            player.method_7357().method_7906(CAMERA, 60);
            player.method_23667(camera.hand(), true);
            player.method_7281(PICTURES_TAKEN);
            UUID id = ServerPictureStore.getInstance().reserveId();
            NETWORK.sendToClient((class_3222)player, new RequestUploadPacket(id));
        });
        ConcurrentHashMap collectors = new ConcurrentHashMap();
        NETWORK.onReceiveFromClient(UploadPartialPicturePacket.class, (packet, player) -> {
            ByteCollector collector;
            if (!ServerPictureStore.getInstance().isReserved(packet.uuid())) {
                LOGGER.error("{} tried to send a byte section for an unreserved UUID", (Object)player.method_5477().toString());
                return;
            }
            if (packet.bytesLeft() > Camerapture.CONFIG_MANAGER.getConfig().server.maxImageBytes) {
                LOGGER.error("{} sent a picture exceeding the size limit", (Object)player.method_5477().getString());
                collectors.remove(packet.uuid());
                ServerPictureStore.getInstance().unreserveId(packet.uuid());
            }
            if (!(collector = collectors.computeIfAbsent(packet.uuid(), uuid -> new ByteCollector(bytes -> {
                collectors.remove(uuid);
                EXECUTOR.execute(() -> {
                    try {
                        MinecraftServer server = player.method_5682();
                        if (server == null) {
                            return;
                        }
                        ServerPictureStore.getInstance().put(server, (UUID)uuid, new StoredPicture((byte[])bytes));
                        class_1799 picture = PictureItem.create(player.method_5477().getString(), uuid);
                        server.execute(() -> player.method_31548().method_7398(picture));
                    }
                    catch (Exception e) {
                        LOGGER.error("failed to save picture from {}", (Object)player.method_5477().getString(), (Object)e);
                        player.method_7353((class_2561)class_2561.method_43471((String)"text.camerapture.picture_failed").method_27692(class_124.field_1061), false);
                    }
                });
            }))).push(packet.bytes(), packet.bytesLeft())) {
                LOGGER.error("{} sent a malformed byte section", (Object)player.method_5477().getString());
                collectors.remove(packet.uuid());
                ServerPictureStore.getInstance().unreserveId(packet.uuid());
            }
            if (collector.getCurrentLength() > Camerapture.CONFIG_MANAGER.getConfig().server.maxImageBytes) {
                LOGGER.error("{} sent a picture exceeding the size limit", (Object)player.method_5477().getString());
                collectors.remove(packet.uuid());
                ServerPictureStore.getInstance().unreserveId(packet.uuid());
            }
        });
        NETWORK.onReceiveFromClient(RequestDownloadPacket.class, (packet, player) -> {
            try {
                StoredPicture picture = ServerPictureStore.getInstance().get(player.method_5682(), packet.uuid());
                if (picture == null) {
                    LOGGER.warn("{} requested a picture with an unknown UUID", (Object)player.method_5477().getString());
                    NETWORK.sendToClient((class_3222)player, new PictureErrorPacket(packet.uuid()));
                    return;
                }
                DownloadQueue.getInstance().send((class_3222)player, packet.uuid(), picture);
            }
            catch (Exception e) {
                LOGGER.error("failed to load picture for {}", (Object)player.method_5477().getString(), (Object)e);
                NETWORK.sendToClient((class_3222)player, new PictureErrorPacket(packet.uuid()));
            }
        });
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }
}

