/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.picture;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import javax.imageio.ImageIO;
import me.chrr.camerapture.ByteCollector;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.config.Config;
import me.chrr.camerapture.item.CameraItem;
import me.chrr.camerapture.net.serverbound.NewPicturePacket;
import me.chrr.camerapture.net.serverbound.UploadPartialPicturePacket;
import me.chrr.camerapture.picture.ClientPictureStore;
import me.chrr.camerapture.util.ImageUtil;
import net.minecraft.class_1011;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_746;

public class PictureTaker {
    private static final PictureTaker INSTANCE = new PictureTaker();
    public float zoomLevel = 1.0f;
    private boolean hudWasHidden = false;
    private boolean takingPicture = false;
    private BufferedImage picture;
    private int maxImageBytes;
    private int maxImageResolution;

    private PictureTaker() {
    }

    public void takePicture() {
        if (this.takingPicture) {
            return;
        }
        this.takingPicture = true;
        this.hudWasHidden = class_310.method_1551().field_1690.field_1842;
        class_310.method_1551().field_1690.field_1842 = true;
    }

    public void tryUploadFile(Path filePath) {
        block2: {
            try {
                this.picture = ImageIO.read(filePath.toFile());
                Camerapture.NETWORK.sendToServer(new NewPicturePacket());
            }
            catch (IOException e) {
                Camerapture.LOGGER.error("failed to read picture from file", (Throwable)e);
                class_746 player = class_310.method_1551().field_1724;
                if (player == null) break block2;
                player.method_7353((class_2561)class_2561.method_43471((String)"text.camerapture.upload_failed").method_27692(class_124.field_1061), false);
            }
        }
    }

    public void renderTickEnd() {
        if (!this.takingPicture) {
            return;
        }
        class_310 client = class_310.method_1551();
        this.takingPicture = false;
        client.field_1690.field_1842 = this.hudWasHidden;
        try (class_1011 nativeImage = class_318.method_1663((class_276)client.method_1522());){
            this.picture = ImageUtil.fromNativeImage(nativeImage, false);
        }
        CameraItem.HeldCamera activeCamera = CameraItem.find((class_1657)client.field_1724, true);
        if (activeCamera != null) {
            CameraItem.setActive(activeCamera.stack(), false);
        }
        Camerapture.NETWORK.sendToServer(new NewPicturePacket());
    }

    public void uploadStoredPicture(UUID pictureId) {
        block5: {
            if (this.picture == null) {
                return;
            }
            try {
                BufferedImage picture = ImageUtil.clampSize(this.picture, this.maxImageResolution);
                float factor = 1.0f;
                byte[] bytes = ImageUtil.compressIntoWebP(picture, factor);
                while (bytes.length > this.maxImageBytes) {
                    if (factor < 0.1f) {
                        throw new IOException("image too big, even at 10% compression (" + bytes.length + " bytes)");
                    }
                    bytes = ImageUtil.compressIntoWebP(picture, factor -= 0.05f);
                }
                Camerapture.LOGGER.debug("sending picture ({} bytes, {}%)", (Object)bytes.length, (Object)((int)(factor * 100.0f)));
                ByteCollector.split(bytes, 30000, (section, bytesLeft) -> Camerapture.NETWORK.sendToServer(new UploadPartialPicturePacket(pictureId, section, bytesLeft)));
                ClientPictureStore.getInstance().processReceivedImage(pictureId, picture);
                ClientPictureStore.getInstance().cacheBytesToDisk(pictureId, bytes);
                this.picture = null;
            }
            catch (IOException e) {
                Camerapture.LOGGER.error("failed to send picture to server", (Throwable)e);
                this.picture = null;
                class_746 player = class_310.method_1551().field_1724;
                if (player == null) break block5;
                player.method_7353((class_2561)class_2561.method_43471((String)"text.camerapture.upload_failed").method_27692(class_124.field_1061), false);
            }
        }
    }

    public void configureFromConfig() {
        Config config = Camerapture.CONFIG_MANAGER.getConfig();
        this.maxImageBytes = config.server.maxImageBytes;
        this.maxImageResolution = config.server.maxImageResolution;
    }

    public void configure(int maxImageBytes, int maxImageResolution) {
        Camerapture.LOGGER.info("setting max image size to {} bytes, max resolution to {}", (Object)maxImageBytes, (Object)maxImageResolution);
        this.maxImageBytes = maxImageBytes;
        this.maxImageResolution = maxImageResolution;
    }

    public void zoom(float delta) {
        this.zoomLevel += delta;
        this.zoomLevel = Math.max(1.0f, Math.min(6.0f, this.zoomLevel));
    }

    public float getFovModifier() {
        float zoomProgress = 1.0f - (this.zoomLevel - 1.0f) / 5.0f;
        return 0.1f + 0.9f * (float)Math.pow(zoomProgress, 2.0);
    }

    public static PictureTaker getInstance() {
        return INSTANCE;
    }
}

