/*
 * Decompiled with CFR 0.152.
 */
package dev.cubxity.plugins.metrics.fabric.mixins;

import dev.cubxity.plugins.metrics.fabric.events.TickEvent;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public class MinecraftServerMixin {
    private long lastTick = 0L;

    @Inject(method={"runServer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;setFavicon(Lnet/minecraft/server/ServerMetadata;)V")})
    private void onRunServerBeforeLoop(CallbackInfo ci) {
        this.lastTick = System.nanoTime() - 50000000L;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTickStart(CallbackInfo ci) {
        this.lastTick = System.nanoTime();
    }

    @Inject(method={"tick"}, at={@At(value="CONSTANT", args={"stringValue=tallying"})})
    private void onTickEnd(CallbackInfo ci) {
        ((TickEvent)TickEvent.Companion.getEvent().invoker()).onTick((double)(System.nanoTime() - this.lastTick) / 1000000.0);
    }
}

