/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.events.fabric;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.events.SimpleEvent;

public class MoonlightEventsHelperImpl {
    private static final Map<Class<? extends SimpleEvent>, Queue<Consumer<? extends SimpleEvent>>> LISTENERS = new ConcurrentHashMap<Class<? extends SimpleEvent>, Queue<Consumer<? extends SimpleEvent>>>();

    public static <T extends SimpleEvent> void addListener(Consumer<T> listener, Class<T> eventClass) {
        LISTENERS.computeIfAbsent(eventClass, e -> new ConcurrentLinkedDeque()).add(listener);
    }

    public static <T extends SimpleEvent> void postEvent(T event, Class<T> eventClass) {
        Queue<Consumer<? extends SimpleEvent>> consumers = LISTENERS.get(eventClass);
        if (consumers != null) {
            consumers.forEach(e -> e.accept(event));
        }
    }
}

