/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animatable;

import java.util.function.Consumer;
import net.minecraft.class_1297;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.constant.dataticket.SerializableDataTicket;
import software.bernie.geckolib.util.GeckoLibUtil;

public interface SingletonGeoAnimatable
extends GeoAnimatable {
    public static void registerSyncedAnimatable(GeoAnimatable animatable) {
        GeckoLibUtil.registerSyncedAnimatable(animatable);
    }

    @ApiStatus.NonExtendable
    @Nullable
    default public <D> D getAnimData(long instanceId, SerializableDataTicket<D> dataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(instanceId).getData(dataTicket);
    }

    @ApiStatus.NonExtendable
    default public <D> void setAnimData(class_1297 relatedEntity, long instanceId, SerializableDataTicket<D> dataTicket, D data) {
        if (relatedEntity.method_37908().method_8608()) {
            this.getAnimatableInstanceCache().getManagerForId(instanceId).setData(dataTicket, data);
        } else {
            this.syncAnimData(instanceId, dataTicket, data, relatedEntity);
        }
    }

    @ApiStatus.NonExtendable
    default public <D> void syncAnimData(long instanceId, SerializableDataTicket<D> dataTicket, D data, class_1297 entityToTrack) {
        GeckoLibServices.NETWORK.syncSingletonAnimData(this.getClass(), instanceId, dataTicket, data, entityToTrack);
    }

    @ApiStatus.NonExtendable
    default public <D> void triggerAnim(class_1297 relatedEntity, long instanceId, @Nullable String controllerName, String animName) {
        if (relatedEntity.method_37908().method_8608()) {
            if (controllerName != null) {
                this.getAnimatableInstanceCache().getManagerForId(instanceId).tryTriggerAnimation(controllerName, animName);
            } else {
                this.getAnimatableInstanceCache().getManagerForId(instanceId).tryTriggerAnimation(animName);
            }
        } else {
            GeckoLibServices.NETWORK.triggerSingletonAnim(this.getClass(), relatedEntity, instanceId, controllerName, animName);
        }
    }

    @ApiStatus.NonExtendable
    default public void stopTriggeredAnim(class_1297 relatedEntity, long instanceId, @Nullable String controllerName, @Nullable String animName) {
        if (relatedEntity.method_37908().method_8608()) {
            AnimatableManager animatableManager = this.getAnimatableInstanceCache().getManagerForId(instanceId);
            if (animatableManager == null) {
                return;
            }
            if (controllerName != null) {
                animatableManager.stopTriggeredAnimation(controllerName, animName);
            } else {
                animatableManager.stopTriggeredAnimation(animName);
            }
        } else {
            GeckoLibServices.NETWORK.stopTriggeredSingletonAnim(this.getClass(), relatedEntity, instanceId, controllerName, animName);
        }
    }

    @Override
    @Nullable
    default public AnimatableInstanceCache animatableCacheOverride() {
        return new SingletonAnimatableInstanceCache(this);
    }

    default public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
    }

    default public Object getRenderProvider() {
        return this.getAnimatableInstanceCache().getRenderProvider();
    }
}

