/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.coordfinder.command;

import de.maxhenkel.admiral.permissions.PermissionManager;
import de.maxhenkel.coordfinder.CoordFinder;
import java.util.List;
import javax.annotation.Nullable;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

public class CoordFinderPermissionManager
implements PermissionManager<class_2168> {
    public static final CoordFinderPermissionManager INSTANCE = new CoordFinderPermissionManager();
    private static final Permission PLAYER_LOCATION = new Permission("coordfinder.playerlocation", PermissionType.EVERYONE);
    private static final Permission MODIFY_PLACES = new Permission("coordfinder.modifyplaces", PermissionType.EVERYONE);
    private static final Permission GET_PLACES = new Permission("coordfinder.getplaces", PermissionType.EVERYONE);
    private static final Permission HIDE = new Permission("coordfinder.hide", PermissionType.EVERYONE);
    private static final List<Permission> PERMISSIONS = List.of(PLAYER_LOCATION, MODIFY_PLACES, GET_PLACES, HIDE);
    private static Boolean loaded;

    public boolean hasPermission(class_2168 stack, String permission) {
        for (Permission p : PERMISSIONS) {
            if (!p.permission.equals(permission)) continue;
            if (stack.method_43737()) {
                return p.hasPermission(stack.method_44023());
            }
            if (p.getType().equals((Object)PermissionType.OPS)) {
                return stack.method_9259(stack.method_9211().method_21714());
            }
            return p.hasPermission(null);
        }
        return false;
    }

    private static boolean isFabricPermissionsAPILoaded() {
        if (loaded == null && (loaded = Boolean.valueOf(FabricLoader.getInstance().isModLoaded("fabric-permissions-api-v0"))).booleanValue()) {
            CoordFinder.LOGGER.info("Using Fabric Permissions API");
        }
        return loaded;
    }

    private static class Permission {
        private final String permission;
        private final PermissionType type;

        public Permission(String permission, PermissionType type) {
            this.permission = permission;
            this.type = type;
        }

        public boolean hasPermission(@Nullable class_3222 player) {
            if (CoordFinderPermissionManager.isFabricPermissionsAPILoaded()) {
                return this.checkFabricPermission(player);
            }
            return this.type.hasPermission(player);
        }

        private boolean checkFabricPermission(@Nullable class_3222 player) {
            if (player == null) {
                return false;
            }
            TriState permissionValue = Permissions.getPermissionValue((class_1297)player, (String)this.permission);
            switch (permissionValue) {
                case DEFAULT: {
                    return this.type.hasPermission(player);
                }
                case TRUE: {
                    return true;
                }
            }
            return false;
        }

        public PermissionType getType() {
            return this.type;
        }
    }

    private static enum PermissionType {
        EVERYONE,
        NOONE,
        OPS;


        boolean hasPermission(@Nullable class_3222 player) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> true;
                case 1 -> false;
                case 2 -> player != null && player.method_5687(player.field_13995.method_3798());
            };
        }
    }
}

