/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.coordfinder.config;

import de.maxhenkel.coordfinder.Location;
import de.maxhenkel.coordfinder.configbuilder.CommentedProperties;
import de.maxhenkel.coordfinder.configbuilder.CommentedPropertyConfig;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class PlaceConfig
extends CommentedPropertyConfig {
    public static final Pattern PLACE_NAME_REGEX = Pattern.compile("^[a-zA-Z_-]{1,32}$");
    private final Map<String, Location> places;

    public PlaceConfig(Path path) {
        super(new CommentedProperties(false));
        this.path = path;
        this.reload();
        Map<String, String> entries = this.getEntries();
        this.places = new HashMap<String, Location>();
        for (Map.Entry<String, String> entry : entries.entrySet()) {
            Location location = Location.fromString(entry.getValue());
            this.places.put(entry.getKey(), location);
        }
    }

    @Nullable
    public Location getPlace(String name) {
        return this.places.get(name);
    }

    public void setPlace(String name, Location location) {
        this.places.put(name, location);
        this.set(name, location.toString(), new String[0]);
        this.save();
    }

    public void removePlace(String name) {
        this.places.remove(name);
        this.properties.remove(name);
        this.save();
    }

    public Map<String, Location> getPlaces() {
        return this.places;
    }

    public static boolean isValidPlaceName(String name) {
        return PLACE_NAME_REGEX.matcher(name).matches();
    }
}

