/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.picono435.dependencies.spongepowered.configurate.reactive;

import com.gmail.picono435.dependencies.checkerframework.checker.nullness.qual.Nullable;
import com.gmail.picono435.dependencies.spongepowered.configurate.reactive.CachedPublisher;
import com.gmail.picono435.dependencies.spongepowered.configurate.reactive.Disposable;
import com.gmail.picono435.dependencies.spongepowered.configurate.reactive.ExecutePublisher;
import com.gmail.picono435.dependencies.spongepowered.configurate.reactive.MappedProcessor;
import com.gmail.picono435.dependencies.spongepowered.configurate.reactive.Subscriber;
import com.gmail.picono435.dependencies.spongepowered.configurate.reactive.TransactionFailedException;
import com.gmail.picono435.dependencies.spongepowered.configurate.util.CheckedFunction;
import com.gmail.picono435.dependencies.spongepowered.configurate.util.CheckedSupplier;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;

public interface Publisher<V> {
    public static <V, E extends Exception> Publisher<V> execute(CheckedSupplier<V, E> action) {
        return Publisher.execute(action, ForkJoinPool.commonPool());
    }

    public static <V, E extends Exception> Publisher<V> execute(CheckedSupplier<V, E> action, Executor executor) {
        return new ExecutePublisher<V>(Objects.requireNonNull(action, "action"), Objects.requireNonNull(executor, "executor"));
    }

    public Disposable subscribe(Subscriber<? super V> var1);

    public boolean hasSubscribers();

    default public <R> Publisher<R> map(CheckedFunction<? super V, ? extends R, TransactionFailedException> mapper) {
        return new MappedProcessor<V, R>(mapper, this);
    }

    default public Cached<V> cache() {
        return this.cache(null);
    }

    default public Cached<V> cache(@Nullable V initialValue) {
        return new CachedPublisher<V>(this, initialValue);
    }

    public Executor executor();

    public static interface Cached<V>
    extends Publisher<V> {
        public V get();

        public void submit(V var1);
    }
}

