/*
 * Decompiled with CFR 0.152.
 */
package net.treset.adaptiveview;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.server.MinecraftServer;
import net.treset.adaptiveview.commands.ConfigCommandHandler;
import net.treset.adaptiveview.commands.LockCommandHandler;
import net.treset.adaptiveview.commands.NotificationCommandHandler;
import net.treset.adaptiveview.config.Config;
import net.treset.adaptiveview.distance.ServerHandler;
import net.treset.adaptiveview.distance.ViewDistanceHandler;
import net.treset.adaptiveview.tools.TextTools;
import net.treset.adaptiveview.unlocking.LockManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptiveViewMod
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"adaptiveview");
    private static final Config config = Config.loadOrDefault();
    private static final NotificationCommandHandler notificationCommandHandler = new NotificationCommandHandler(config);
    private static final ConfigCommandHandler configCommandHandler = new ConfigCommandHandler(config);
    private static final ViewDistanceHandler viewDistanceHandler = new ViewDistanceHandler(config);
    private static final LockManager lockManager = new LockManager(config, viewDistanceHandler);
    private static final LockCommandHandler lockCommandHandler = new LockCommandHandler(config, lockManager);
    private static final ServerHandler serverHandler = new ServerHandler(config, lockManager, viewDistanceHandler);
    private static MinecraftServer server;
    private static boolean client;

    public static Config getConfig() {
        return config;
    }

    public static MinecraftServer getServer() {
        return server;
    }

    public static boolean isClient() {
        return client;
    }

    public static void setClient(boolean client) {
        AdaptiveViewMod.client = client;
    }

    public void onInitialize() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> this.registerCommands((CommandDispatcher<class_2168>)dispatcher, environment));
        ServerLifecycleEvents.SERVER_STARTED.register(s -> {
            server = s;
        });
        ServerTickEvents.END_SERVER_TICK.register(serverHandler::onTick);
    }

    private void registerCommands(CommandDispatcher<class_2168> dispatcher, class_2170.class_5364 environment) {
        if (!environment.field_25423 && !config.isAllowOnClient()) {
            return;
        }
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"adaptiveview").executes(this::status)).then(class_2170.method_9247((String)"status").executes(this::status));
        notificationCommandHandler.registerCommands((LiteralArgumentBuilder<class_2168>)builder);
        configCommandHandler.registerCommands((LiteralArgumentBuilder<class_2168>)builder);
        lockCommandHandler.registerCommands((LiteralArgumentBuilder<class_2168>)builder);
        dispatcher.register(builder);
    }

    private int status(CommandContext<class_2168> ctx) {
        TextTools.replyFormatted(ctx, "The current view distance is $b%s chunks$b and the current simulation distance is $b%s chunks$b", ViewDistanceHandler.getViewDistance(), ViewDistanceHandler.getSimDistance());
        return 1;
    }

    static {
        client = false;
    }
}

