/*
 * Decompiled with CFR 0.152.
 */
package net.treset.adaptiveview.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.util.function.BiConsumer;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.treset.adaptiveview.config.Config;
import net.treset.adaptiveview.config.Rule;
import net.treset.adaptiveview.config.RuleTarget;
import net.treset.adaptiveview.config.RuleType;
import net.treset.adaptiveview.tools.BroadcastLevel;
import net.treset.adaptiveview.tools.TextTools;

public class ConfigCommandHandler {
    private final Config config;

    public ConfigCommandHandler(Config config) {
        this.config = config;
    }

    public int list(CommandContext<class_2168> ctx) {
        TextTools.replyFormatted(ctx, "Current Configuration:", new Object[0]);
        TextTools.replyFormatted(ctx, "Update rate: $b%d ticks", this.config.getUpdateRate());
        TextTools.replyFormatted(ctx, "View Distance Range: $b%d-%d chunks", this.config.getMinViewDistance(), this.config.getMaxViewDistance());
        TextTools.replyFormatted(ctx, "Rules: $b%s$b", this.config.getRules().size());
        return 1;
    }

    public int reload(CommandContext<class_2168> ctx) {
        Config config;
        try {
            config = Config.load();
        }
        catch (IOException e) {
            TextTools.replyError(ctx, "Failed to reload Config! Check for syntax errors.");
            return 0;
        }
        this.config.copy(config);
        TextTools.replyFormatted(ctx, "Reloaded Configuration!", false);
        return 1;
    }

    public int updateRate(CommandContext<class_2168> ctx) {
        TextTools.replyFormatted(ctx, "Update Rate: $b%s ticks", this.config.getUpdateRate());
        return 1;
    }

    public int setUpdateRate(CommandContext<class_2168> ctx) {
        Integer ticks = (Integer)ctx.getArgument("ticks", Integer.class);
        this.config.setUpdateRate(ticks);
        this.config.save();
        TextTools.replyFormatted(ctx, "Set Update Rate to $b%s ticks", this.config.getUpdateRate());
        return 1;
    }

    public int maxView(CommandContext<class_2168> ctx) {
        TextTools.replyFormatted(ctx, "Max View Distance: $b%d chunks", this.config.getMaxViewDistance());
        return 1;
    }

    public int setMaxView(CommandContext<class_2168> ctx) {
        Integer chunks = (Integer)ctx.getArgument("chunks", Integer.class);
        this.config.setMaxViewDistance(chunks);
        this.config.save();
        TextTools.replyFormatted(ctx, "Set Max View Distance to $b%d chunks", this.config.getMaxViewDistance());
        return 1;
    }

    public int minView(CommandContext<class_2168> ctx) {
        TextTools.replyFormatted(ctx, "Min View Distance: $b%s chunks", this.config.getMinViewDistance());
        return 1;
    }

    public int setMinView(CommandContext<class_2168> ctx) {
        Integer chunks = (Integer)ctx.getArgument("chunks", Integer.class);
        this.config.setMinViewDistance(chunks);
        this.config.save();
        TextTools.replyFormatted(ctx, "Set Min View Distance to $b%s chunks", this.config.getMinViewDistance());
        return 1;
    }

    public int maxSim(CommandContext<class_2168> ctx) {
        TextTools.replyFormatted(ctx, "Max Simulation Distance: $b%s chunks", this.config.getMaxSimDistance());
        return 1;
    }

    public int setMaxSim(CommandContext<class_2168> ctx) {
        Integer chunks = (Integer)ctx.getArgument("chunks", Integer.class);
        this.config.setMaxSimDistance(chunks);
        this.config.save();
        TextTools.replyFormatted(ctx, "Set Max Simulation Distance to $b%s chunks", this.config.getMaxSimDistance());
        return 1;
    }

    public int minSim(CommandContext<class_2168> ctx) {
        TextTools.replyFormatted(ctx, "Min Simulation Distance: $b%s chunks", this.config.getMinSimDistance());
        return 1;
    }

    public int setMinSim(CommandContext<class_2168> ctx) {
        Integer chunks = (Integer)ctx.getArgument("chunks", Integer.class);
        this.config.setMinSimDistance(chunks);
        this.config.save();
        TextTools.replyFormatted(ctx, "Set Min Simulation Distance to $b%s chunks", this.config.getMinSimDistance());
        return 1;
    }

    public int broadcastChanges(CommandContext<class_2168> ctx) {
        Object[] objectArray = new Object[1];
        objectArray[0] = switch (this.config.getBroadcastChangesDefault()) {
            default -> throw new IncompatibleClassChangeError();
            case BroadcastLevel.ALL -> "all players";
            case BroadcastLevel.OPS -> "operators";
            case BroadcastLevel.NONE -> "no one";
        };
        TextTools.replyFormatted(ctx, "Broadcasting view distance changes to $b%s", objectArray);
        return 1;
    }

    public int broadcastChangesNone(CommandContext<class_2168> ctx) {
        this.config.setBroadcastChangesDefault(BroadcastLevel.NONE);
        this.config.save();
        TextTools.replyFormatted(ctx, "Set broadcast changes to $bno one", new Object[0]);
        return 1;
    }

    public int broadcastChangesOps(CommandContext<class_2168> ctx) {
        this.config.setBroadcastChangesDefault(BroadcastLevel.OPS);
        this.config.save();
        TextTools.replyFormatted(ctx, "Set broadcast changes to $boperators", new Object[0]);
        return 1;
    }

    public int broadcastChangesAll(CommandContext<class_2168> ctx) {
        this.config.setBroadcastChangesDefault(BroadcastLevel.ALL);
        this.config.save();
        TextTools.replyFormatted(ctx, "Set broadcast changes to $ball players", new Object[0]);
        return 1;
    }

    public int broadcastLock(CommandContext<class_2168> ctx) {
        Object[] objectArray = new Object[1];
        objectArray[0] = switch (this.config.getBroadcastLockDefault()) {
            default -> throw new IncompatibleClassChangeError();
            case BroadcastLevel.ALL -> "all players";
            case BroadcastLevel.OPS -> "operators";
            case BroadcastLevel.NONE -> "no one";
        };
        TextTools.replyFormatted(ctx, "Broadcasting view distance locking and unlocking to $b%s", objectArray);
        return 1;
    }

    public int broadcastLockNone(CommandContext<class_2168> ctx) {
        this.config.setBroadcastLockDefault(BroadcastLevel.NONE);
        this.config.save();
        TextTools.replyFormatted(ctx, "Set broadcast lock to $bno one", new Object[0]);
        return 1;
    }

    public int broadcastLockOps(CommandContext<class_2168> ctx) {
        this.config.setBroadcastLockDefault(BroadcastLevel.OPS);
        this.config.save();
        TextTools.replyFormatted(ctx, "Set broadcast lock to $boperators", new Object[0]);
        return 1;
    }

    public int broadcastLockAll(CommandContext<class_2168> ctx) {
        this.config.setBroadcastLockDefault(BroadcastLevel.ALL);
        this.config.save();
        TextTools.replyFormatted(ctx, "Set broadcast lock to $ball players", new Object[0]);
        return 1;
    }

    public int rules(CommandContext<class_2168> ctx) {
        TextTools.replyFormatted(ctx, "Current Rules:", new Object[0]);
        for (int i = 0; i < this.config.getRules().size(); ++i) {
            TextTools.replyFormatted(ctx, "%d. %s", i + 1, this.config.getRules().get(i));
        }
        return 1;
    }

    private int performRuleAction(CommandContext<class_2168> ctx, BiConsumer<Integer, Rule> action) {
        Integer index = (Integer)ctx.getArgument("index", Integer.class);
        if (index == null || index <= 0 || index > this.config.getRules().size()) {
            TextTools.replyError(ctx, "Rule at index $b" + index + "$b doesn't exist. Needs to be at most " + (this.config.getRules().size() - 1) + ".");
            return 0;
        }
        action.accept(index, this.config.getRules().get(index - 1));
        return 1;
    }

    public int ruleIndex(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> TextTools.replyFormatted(ctx, "Rule $b%d$b: %s", i, r));
    }

    public int ruleRemove(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> {
            this.config.getRules().remove(i - 1);
            this.config.save();
            TextTools.replyFormatted(ctx, "Removed rule $b%d$b.", i);
        });
    }

    public int ruleName(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> TextTools.replyFormatted(ctx, "Name of rule $b%d$b: $b%s$b", i, r.getName()));
    }

    public int ruleSetName(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> {
            String name = (String)ctx.getArgument("name", String.class);
            r.setName(name);
            this.config.save();
            TextTools.replyFormatted(ctx, "Set Name of rule $b%d$b to $b%s$b", i, r.getName());
        });
    }

    public int ruleClearName(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> {
            r.setName(null);
            this.config.save();
            TextTools.replyFormatted(ctx, "Cleared Name of rule $b%d$b", i);
        });
    }

    public int ruleCondition(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> TextTools.replyFormatted(ctx, "Condition of rule $b%d$b: %s", i, r.toConditionString()));
    }

    public int ruleType(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> TextTools.replyFormatted(ctx, "Condition Type of rule $b%d$b: $b%s$b", new Object[]{i, r.getType()}));
    }

    private int setRuleType(CommandContext<class_2168> ctx, RuleType type) {
        return this.performRuleAction(ctx, (i, r) -> {
            r.setType(type);
            this.config.save();
            TextTools.replyFormatted(ctx, "Set Condition Type of rule $b%d$b to $b%s$b", new Object[]{i, r.getType()});
        });
    }

    public int ruleTypeSetMspt(CommandContext<class_2168> ctx) {
        return this.setRuleType(ctx, RuleType.MSPT);
    }

    public int ruleTypeSetMemory(CommandContext<class_2168> ctx) {
        return this.setRuleType(ctx, RuleType.MEMORY);
    }

    public int ruleTypeSetPlayers(CommandContext<class_2168> ctx) {
        return this.setRuleType(ctx, RuleType.PLAYERS);
    }

    public int ruleValue(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> TextTools.replyFormatted(ctx, "Value of rule $b%d$b: $b%s$b", i, r.getValue()));
    }

    public int ruleSetValue(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> {
            String value = (String)ctx.getArgument("value", String.class);
            r.setValue(value);
            this.config.save();
            TextTools.replyFormatted(ctx, "Set Value of rule $b%d$b to $b%s$b", i, r.getValue());
        });
    }

    public int ruleClearValue(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> {
            r.setValue(null);
            this.config.save();
            TextTools.replyFormatted(ctx, "Cleared Value of rule $b%d$b", i);
        });
    }

    public int ruleMin(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> TextTools.replyFormatted(ctx, "Min value of rule $b%d$b: $b%s$b", i, r.getMin()));
    }

    public int ruleSetMin(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> {
            Integer min = (Integer)ctx.getArgument("min", Integer.class);
            r.setMin(min);
            this.config.save();
            TextTools.replyFormatted(ctx, "Set Min value of rule $b%d$b to $b%s$b", i, r.getMin());
        });
    }

    public int ruleClearMin(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> {
            r.setMin(null);
            this.config.save();
            TextTools.replyFormatted(ctx, "Cleared Min value of rule $b%d$b", i);
        });
    }

    public int ruleMax(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> TextTools.replyFormatted(ctx, "Max value of rule $b%d$b: $b%s$b", i, r.getMax()));
    }

    public int ruleSetMax(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> {
            Integer max = (Integer)ctx.getArgument("max", Integer.class);
            r.setMax(max);
            this.config.save();
            TextTools.replyFormatted(ctx, "Set Max value of rule $b%d$b to $b%s$b", i, r.getMax());
        });
    }

    public int ruleClearMax(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> {
            r.setMax(null);
            this.config.save();
            TextTools.replyFormatted(ctx, "Cleared Max value of rule $b%d$b", i);
        });
    }

    public int ruleAction(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> TextTools.replyFormatted(ctx, "Action of rule $b%d$b: %s", i, r.toActionString()));
    }

    public int ruleTarget(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> TextTools.replyFormatted(ctx, "Action Target of rule $b%d$b: $b%s$b", i, r.getTarget().getName()));
    }

    private int ruleSetTarget(CommandContext<class_2168> ctx, RuleTarget target) {
        return this.performRuleAction(ctx, (i, r) -> {
            r.setTarget(target);
            this.config.save();
            TextTools.replyFormatted(ctx, "Set Action Target of rule $b%d$b to $b%s$b", i, r.getTarget().getName());
        });
    }

    public int ruleSetTargetView(CommandContext<class_2168> ctx) {
        return this.ruleSetTarget(ctx, RuleTarget.VIEW);
    }

    public int ruleSetTargetSim(CommandContext<class_2168> ctx) {
        return this.ruleSetTarget(ctx, RuleTarget.SIMULATION);
    }

    public int ruleUpdateRate(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> TextTools.replyFormatted(ctx, "Update Rate of rule $b%d$b: $b%s$b", i, r.getUpdateRate()));
    }

    public int ruleSetUpdateRate(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> {
            Integer updateRate = (Integer)ctx.getArgument("ticks", Integer.class);
            r.setUpdateRate(updateRate);
            this.config.save();
            TextTools.replyFormatted(ctx, "Set Update Rate of rule $b%d$b to $b%s$b", i, r.getUpdateRate());
        });
    }

    public int ruleClearUpdateRate(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> {
            r.setUpdateRate(null);
            this.config.save();
            TextTools.replyFormatted(ctx, "Cleared Update Rate of rule $b%d$b", i);
        });
    }

    public int ruleStep(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> TextTools.replyFormatted(ctx, "Step of rule $b%d$b: $b%s$b", i, r.getStep()));
    }

    public int ruleSetStep(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> {
            Integer step = (Integer)ctx.getArgument("step", Integer.class);
            r.setStep(step);
            this.config.save();
            TextTools.replyFormatted(ctx, "Set Step of rule $b%d$b to $b%s$b", i, r.getStep());
        });
    }

    public int ruleClearStep(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> {
            r.setStep(null);
            this.config.save();
            TextTools.replyFormatted(ctx, "Cleared Step of rule $b%d$b", i);
        });
    }

    public int ruleStepAfter(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> TextTools.replyFormatted(ctx, "Step After of rule $b%d$b: $b%s$b", i, r.getStepAfter()));
    }

    public int ruleSetStepAfter(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> {
            Integer step = (Integer)ctx.getArgument("step_after", Integer.class);
            r.setStepAfter(step);
            this.config.save();
            TextTools.replyFormatted(ctx, "Set Step After of rule $b%d$b to $b%s$b", i, r.getStepAfter());
        });
    }

    public int ruleClearStepAfter(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> {
            r.setStepAfter(null);
            this.config.save();
            TextTools.replyFormatted(ctx, "Cleared Step After of rule $b%d$b", i);
        });
    }

    public int ruleMinView(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> TextTools.replyFormatted(ctx, "Min View Distance of rule $b%d$b: $b%s$b", i, r.getMinDistance()));
    }

    public int ruleSetMinView(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> {
            Integer min = (Integer)ctx.getArgument("chunks", Integer.class);
            r.setMinDistance(min);
            this.config.save();
            TextTools.replyFormatted(ctx, "Set Min View Distance of rule $b%d$b to $b%s$b", i, r.getMinDistance());
        });
    }

    public int ruleClearMinView(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> {
            r.setMinDistance(null);
            this.config.save();
            TextTools.replyFormatted(ctx, "Cleared Min View Distance of rule $b%d$b", i);
        });
    }

    public int ruleMaxView(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> TextTools.replyFormatted(ctx, "Max View Distance of rule $b%d$b: $b%s$b", i, r.getMaxDistance()));
    }

    public int ruleSetMaxView(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> {
            Integer max = (Integer)ctx.getArgument("chunks", Integer.class);
            r.setMaxDistance(max);
            this.config.save();
            TextTools.replyFormatted(ctx, "Set Max View Distance of rule $b%d$b to $b%s$b", i, r.getMaxDistance());
        });
    }

    public int ruleClearMaxView(CommandContext<class_2168> ctx) {
        return this.performRuleAction(ctx, (i, r) -> {
            r.setMaxDistance(null);
            this.config.save();
            TextTools.replyFormatted(ctx, "Cleared Max View Distance of rule $b%d$b", i);
        });
    }

    private int addRule(CommandContext<class_2168> ctx, RuleType type, String value, Integer max, Integer min, RuleTarget target) {
        Rule r = new Rule(type, value, max, min, target, null, null, null, null, null, null);
        this.config.getRules().add(r);
        this.config.save();
        TextTools.replyFormatted(ctx, "Added new Rule at index $b%d$b. Modify the action to make it effective.", this.config.getRules().size());
        return 1;
    }

    public int addMsptMinView(CommandContext<class_2168> ctx) {
        Integer min = (Integer)ctx.getArgument("min", Integer.class);
        return this.addRule(ctx, RuleType.MSPT, null, null, min, RuleTarget.VIEW);
    }

    public int addMsptMinSim(CommandContext<class_2168> ctx) {
        Integer max = (Integer)ctx.getArgument("min", Integer.class);
        return this.addRule(ctx, RuleType.MSPT, null, max, null, RuleTarget.SIMULATION);
    }

    public int addMsptMaxView(CommandContext<class_2168> ctx) {
        Integer max = (Integer)ctx.getArgument("max", Integer.class);
        return this.addRule(ctx, RuleType.MSPT, null, max, null, RuleTarget.VIEW);
    }

    public int addMsptMaxSim(CommandContext<class_2168> ctx) {
        Integer max = (Integer)ctx.getArgument("max", Integer.class);
        return this.addRule(ctx, RuleType.MSPT, null, max, null, RuleTarget.SIMULATION);
    }

    public int addMsptRangeView(CommandContext<class_2168> ctx) {
        Integer min = (Integer)ctx.getArgument("min", Integer.class);
        Integer max = (Integer)ctx.getArgument("max", Integer.class);
        return this.addRule(ctx, RuleType.MSPT, null, max, min, RuleTarget.VIEW);
    }

    public int addMsptRangeSim(CommandContext<class_2168> ctx) {
        Integer min = (Integer)ctx.getArgument("min", Integer.class);
        Integer max = (Integer)ctx.getArgument("max", Integer.class);
        return this.addRule(ctx, RuleType.MSPT, null, max, min, RuleTarget.SIMULATION);
    }

    public int addMemoryMinView(CommandContext<class_2168> ctx) {
        Integer min = (Integer)ctx.getArgument("min", Integer.class);
        return this.addRule(ctx, RuleType.MEMORY, null, null, min, RuleTarget.VIEW);
    }

    public int addMemoryMinSim(CommandContext<class_2168> ctx) {
        Integer max = (Integer)ctx.getArgument("min", Integer.class);
        return this.addRule(ctx, RuleType.MEMORY, null, max, null, RuleTarget.SIMULATION);
    }

    public int addMemoryMaxView(CommandContext<class_2168> ctx) {
        Integer max = (Integer)ctx.getArgument("max", Integer.class);
        return this.addRule(ctx, RuleType.MEMORY, null, max, null, RuleTarget.VIEW);
    }

    public int addMemoryMaxSim(CommandContext<class_2168> ctx) {
        Integer max = (Integer)ctx.getArgument("max", Integer.class);
        return this.addRule(ctx, RuleType.MEMORY, null, max, null, RuleTarget.SIMULATION);
    }

    public int addMemoryRangeView(CommandContext<class_2168> ctx) {
        Integer min = (Integer)ctx.getArgument("min", Integer.class);
        Integer max = (Integer)ctx.getArgument("max", Integer.class);
        return this.addRule(ctx, RuleType.MEMORY, null, max, min, RuleTarget.VIEW);
    }

    public int addMemoryRangeSim(CommandContext<class_2168> ctx) {
        Integer min = (Integer)ctx.getArgument("min", Integer.class);
        Integer max = (Integer)ctx.getArgument("max", Integer.class);
        return this.addRule(ctx, RuleType.MEMORY, null, max, min, RuleTarget.SIMULATION);
    }

    public int addPlayersMinView(CommandContext<class_2168> ctx) {
        Integer min = (Integer)ctx.getArgument("min", Integer.class);
        return this.addRule(ctx, RuleType.PLAYERS, null, null, min, RuleTarget.VIEW);
    }

    public int addPlayersMinSim(CommandContext<class_2168> ctx) {
        Integer max = (Integer)ctx.getArgument("min", Integer.class);
        return this.addRule(ctx, RuleType.PLAYERS, null, max, null, RuleTarget.SIMULATION);
    }

    public int addPlayersMaxView(CommandContext<class_2168> ctx) {
        Integer max = (Integer)ctx.getArgument("max", Integer.class);
        return this.addRule(ctx, RuleType.PLAYERS, null, max, null, RuleTarget.VIEW);
    }

    public int addPlayersMaxSim(CommandContext<class_2168> ctx) {
        Integer max = (Integer)ctx.getArgument("max", Integer.class);
        return this.addRule(ctx, RuleType.PLAYERS, null, max, null, RuleTarget.SIMULATION);
    }

    public int addPlayersRangeView(CommandContext<class_2168> ctx) {
        Integer min = (Integer)ctx.getArgument("min", Integer.class);
        Integer max = (Integer)ctx.getArgument("max", Integer.class);
        return this.addRule(ctx, RuleType.PLAYERS, null, max, min, RuleTarget.VIEW);
    }

    public int addPlayersRangeSim(CommandContext<class_2168> ctx) {
        Integer min = (Integer)ctx.getArgument("min", Integer.class);
        Integer max = (Integer)ctx.getArgument("max", Integer.class);
        return this.addRule(ctx, RuleType.PLAYERS, null, max, min, RuleTarget.SIMULATION);
    }

    public int addPlayersNameView(CommandContext<class_2168> ctx) {
        String name = (String)ctx.getArgument("names", String.class);
        return this.addRule(ctx, RuleType.PLAYERS, name, null, null, RuleTarget.VIEW);
    }

    public int addPlayersNameSim(CommandContext<class_2168> ctx) {
        String name = (String)ctx.getArgument("names", String.class);
        return this.addRule(ctx, RuleType.PLAYERS, name, null, null, RuleTarget.SIMULATION);
    }

    public void registerCommands(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"config").requires(source -> source.method_9259(2))).executes(this::list)).then(class_2170.method_9247((String)"status").executes(this::list))).then(class_2170.method_9247((String)"reload").executes(this::reload))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"update_rate").executes(this::updateRate)).then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)1, (int)72000)).executes(this::setUpdateRate)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"max_view_distance").executes(this::maxView)).then(class_2170.method_9244((String)"chunks", (ArgumentType)IntegerArgumentType.integer((int)2, (int)32)).executes(this::setMaxView)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"min_view_distance").executes(this::minView)).then(class_2170.method_9244((String)"chunks", (ArgumentType)IntegerArgumentType.integer((int)2, (int)32)).executes(this::setMinView)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"max_simulation_distance").executes(this::maxSim)).then(class_2170.method_9244((String)"chunks", (ArgumentType)IntegerArgumentType.integer((int)2, (int)32)).executes(this::setMaxSim)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"min_simulation_distance").executes(this::minSim)).then(class_2170.method_9244((String)"chunks", (ArgumentType)IntegerArgumentType.integer((int)2, (int)32)).executes(this::setMinSim)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"broadcast_changes").executes(this::broadcastChanges)).then(class_2170.method_9247((String)"none").executes(this::broadcastChangesNone))).then(class_2170.method_9247((String)"ops").executes(this::broadcastChangesOps))).then(class_2170.method_9247((String)"all").executes(this::broadcastChangesAll)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"broadcast_lock").executes(this::broadcastLock)).then(class_2170.method_9247((String)"none").executes(this::broadcastLockNone))).then(class_2170.method_9247((String)"ops").executes(this::broadcastLockOps))).then(class_2170.method_9247((String)"all").executes(this::broadcastLockAll)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rules").executes(this::rules)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"index", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(this::ruleIndex)).then(class_2170.method_9247((String)"remove").executes(this::ruleRemove))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"name").executes(this::ruleName)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(this::ruleSetName))).then(class_2170.method_9247((String)"clear").executes(this::ruleClearName)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"condition").executes(this::ruleCondition)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"type").executes(this::ruleType)).then(class_2170.method_9247((String)"mspt").executes(this::ruleTypeSetMspt))).then(class_2170.method_9247((String)"memory").executes(this::ruleTypeSetMemory))).then(class_2170.method_9247((String)"players").executes(this::ruleTypeSetPlayers)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"value").executes(this::ruleValue)).then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(this::ruleSetValue))).then(class_2170.method_9247((String)"clear").executes(this::ruleClearValue)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"min").executes(this::ruleMin)).then(class_2170.method_9244((String)"min", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(this::ruleSetMin))).then(class_2170.method_9247((String)"clear").executes(this::ruleClearMin)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"max").executes(this::ruleMax)).then(class_2170.method_9244((String)"max", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(this::ruleSetMax))).then(class_2170.method_9247((String)"clear").executes(this::ruleClearMax))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"action").executes(this::ruleAction)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"target").executes(this::ruleTarget)).then(class_2170.method_9247((String)"view").executes(this::ruleSetTargetView))).then(class_2170.method_9247((String)"simulation").executes(this::ruleSetTargetSim)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"update_rate").executes(this::ruleUpdateRate)).then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)1, (int)72000)).executes(this::ruleSetUpdateRate))).then(class_2170.method_9247((String)"clear").executes(this::ruleClearUpdateRate)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"step").executes(this::ruleStep)).then(class_2170.method_9244((String)"step", (ArgumentType)IntegerArgumentType.integer((int)-32, (int)32)).executes(this::ruleSetStep))).then(class_2170.method_9247((String)"clear").executes(this::ruleClearStep)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"step_after").executes(this::ruleStepAfter)).then(class_2170.method_9244((String)"step_after", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(this::ruleSetStepAfter))).then(class_2170.method_9247((String)"clear").executes(this::ruleClearStepAfter)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"min_view_distance").executes(this::ruleMinView)).then(class_2170.method_9244((String)"chunks", (ArgumentType)IntegerArgumentType.integer((int)2, (int)32)).executes(this::ruleSetMinView))).then(class_2170.method_9247((String)"clear").executes(this::ruleClearMinView)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"max_view_distance").executes(this::ruleMaxView)).then(class_2170.method_9244((String)"chunks", (ArgumentType)IntegerArgumentType.integer((int)2, (int)32)).executes(this::ruleSetMaxView))).then(class_2170.method_9247((String)"clear").executes(this::ruleClearMaxView)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"add").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mspt").then(class_2170.method_9247((String)"min").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"min", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000)).executes(this::addMsptMinView)).then(class_2170.method_9247((String)"view").executes(this::addMsptMinView))).then(class_2170.method_9247((String)"simulation").executes(this::addMsptMinSim))))).then(class_2170.method_9247((String)"max").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"max", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000)).executes(this::addMsptMaxView)).then(class_2170.method_9247((String)"view").executes(this::addMsptMaxView))).then(class_2170.method_9247((String)"simulation").executes(this::addMsptMaxSim))))).then(class_2170.method_9247((String)"range").then(class_2170.method_9244((String)"min", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"max", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000)).executes(this::addMsptRangeView)).then(class_2170.method_9247((String)"view").executes(this::addMsptRangeView))).then(class_2170.method_9247((String)"simulation").executes(this::addMsptRangeSim))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"memory").then(class_2170.method_9247((String)"min").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"min", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(this::addMemoryMinView)).then(class_2170.method_9247((String)"view").executes(this::addMemoryMinView))).then(class_2170.method_9247((String)"simulation").executes(this::addMemoryMinSim))))).then(class_2170.method_9247((String)"max").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"max", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(this::addMemoryMaxView)).then(class_2170.method_9247((String)"view").executes(this::addMemoryMaxView))).then(class_2170.method_9247((String)"simulation").executes(this::addMemoryMaxSim))))).then(class_2170.method_9247((String)"range").then(class_2170.method_9244((String)"min", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"max", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(this::addMemoryRangeView)).then(class_2170.method_9247((String)"view").executes(this::addMemoryRangeView))).then(class_2170.method_9247((String)"simulation").executes(this::addMemoryRangeSim))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"players").then(class_2170.method_9247((String)"min").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"min", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000)).executes(this::addPlayersMinView)).then(class_2170.method_9247((String)"view").executes(this::addPlayersMinView))).then(class_2170.method_9247((String)"simulation").executes(this::addPlayersMinSim))))).then(class_2170.method_9247((String)"max").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"max", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000)).executes(this::addPlayersMaxView)).then(class_2170.method_9247((String)"view").executes(this::addPlayersMaxView))).then(class_2170.method_9247((String)"simulation").executes(this::addPlayersMaxSim))))).then(class_2170.method_9247((String)"range").then(class_2170.method_9244((String)"min", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"max", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000)).executes(this::addPlayersRangeView)).then(class_2170.method_9247((String)"view").executes(this::addPlayersRangeView))).then(class_2170.method_9247((String)"simulation").executes(this::addPlayersRangeSim)))))).then(class_2170.method_9247((String)"names").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"names", (ArgumentType)StringArgumentType.greedyString()).executes(this::addPlayersNameView)).then(class_2170.method_9247((String)"view").executes(this::addPlayersNameView))).then(class_2170.method_9247((String)"simulation").executes(this::addPlayersNameSim))))))));
    }
}

