/*
 * Decompiled with CFR 0.152.
 */
package net.treset.adaptiveview.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_3222;
import net.treset.adaptiveview.AdaptiveViewMod;
import net.treset.adaptiveview.config.Config;
import net.treset.adaptiveview.tools.TextTools;
import net.treset.adaptiveview.unlocking.LockManager;
import net.treset.adaptiveview.unlocking.LockTarget;
import net.treset.adaptiveview.unlocking.Locker;
import net.treset.adaptiveview.unlocking.PlayerDisconnectLocker;
import net.treset.adaptiveview.unlocking.PlayerMoveLocker;
import net.treset.adaptiveview.unlocking.TimeoutLocker;

public class LockCommandHandler {
    private final Config config;
    private final LockManager lockManager;

    public LockCommandHandler(Config config, LockManager lockManager) {
        this.config = config;
        this.lockManager = lockManager;
    }

    private void replyAndBroadcastLock(CommandContext<class_2168> ctx, String message, Object ... args) {
        TextTools.replyAndBroadcastIf(p -> LockManager.shouldBroadcastLock(p, this.config), ctx, message, args);
    }

    private int lockStatus(CommandContext<class_2168> ctx, LockTarget target) {
        Locker currentLocker = this.lockManager.getCurrentLocker(target);
        int numLockers = this.lockManager.getNumLockers(target);
        Integer lockedManually = this.lockManager.getLockedManually(target);
        if (lockedManually == null && numLockers == 0) {
            TextTools.replyFormatted(ctx, "The %s is $bunlocked", target.getPrettyString());
            return 1;
        }
        if (lockedManually != null) {
            StringBuilder sb = new StringBuilder(String.format("The %s is manually locked to $b%s chunks$b", target.getPrettyString(), lockedManually));
            if (numLockers > 0) {
                sb.append(String.format(" and there %s $b%s %s$b queued", numLockers > 1 ? "are" : "is", numLockers, numLockers > 1 ? "lockers" : "locker"));
            }
            TextTools.replyFormatted(ctx, sb.toString(), new Object[0]);
        } else if (currentLocker != null) {
            StringBuilder sb = new StringBuilder(String.format("The %s is locked to $b%s chunks$b until %s", target.getPrettyString(), currentLocker.getDistance(), currentLocker.getLockedReason()));
            if (numLockers > 1) {
                sb.append(String.format(" and $b%s other %s$b queued", numLockers - 1, numLockers > 2 ? "lockers are" : "locker is"));
            }
            TextTools.replyFormatted(ctx, sb.toString(), new Object[0]);
        } else {
            TextTools.replyError(ctx, "An error occurred while fetching the lock status");
            return 0;
        }
        return 1;
    }

    private int status(CommandContext<class_2168> ctx) {
        if (this.lockStatus(ctx, LockTarget.VIEW) == 1 && this.lockStatus(ctx, LockTarget.SIM) == 1) {
            return 1;
        }
        return 0;
    }

    private int lock(CommandContext<class_2168> ctx, LockTarget target) {
        int chunks = IntegerArgumentType.getInteger(ctx, (String)"chunks");
        this.lockManager.lockManually(chunks, target);
        this.replyAndBroadcastLock(ctx, "Locked the %s to $b%s chunks", target.getPrettyString(), chunks);
        return 1;
    }

    private int lockTimeout(CommandContext<class_2168> ctx, LockTarget target) {
        int chunks = IntegerArgumentType.getInteger(ctx, (String)"chunks");
        int ticks = IntegerArgumentType.getInteger(ctx, (String)"ticks");
        this.lockManager.addLocker(new TimeoutLocker(chunks, ticks, target, this.lockManager));
        this.replyAndBroadcastLock(ctx, "Locked the %s to $b%s chunks$b for $b%s ticks", target.getPrettyString(), chunks, ticks);
        return 1;
    }

    private int lockPlayerDisconnect(CommandContext<class_2168> ctx, LockTarget target) {
        class_3222 player;
        int chunks = IntegerArgumentType.getInteger(ctx, (String)"chunks");
        try {
            player = class_2186.method_9315(ctx, (String)"player");
        }
        catch (CommandSyntaxException e) {
            TextTools.replyError(ctx, "Cannot parse the provided player");
            AdaptiveViewMod.LOGGER.error("Failed to parse player", (Throwable)e);
            return 0;
        }
        this.lockManager.addLocker(new PlayerDisconnectLocker(player, chunks, target, this.lockManager));
        this.replyAndBroadcastLock(ctx, "Locked the %s to $b%s chunks$b until $b%s disconnects", target.getPrettyString(), chunks, player.method_5477().getString());
        return 1;
    }

    private int lockPlayerMove(CommandContext<class_2168> ctx, LockTarget target) {
        class_3222 player;
        int chunks = IntegerArgumentType.getInteger(ctx, (String)"chunks");
        try {
            player = class_2186.method_9315(ctx, (String)"player");
        }
        catch (CommandSyntaxException e) {
            TextTools.replyError(ctx, "Cannot parse the provided player");
            AdaptiveViewMod.LOGGER.error("Failed to parse player", (Throwable)e);
            return 0;
        }
        this.lockManager.addLocker(new PlayerMoveLocker(player, chunks, target, this.lockManager));
        this.replyAndBroadcastLock(ctx, "Locked the %s to $b%s chunks$b until $b%s moves", target.getPrettyString(), chunks, player.method_5477().getString());
        return 1;
    }

    private int unlock(CommandContext<class_2168> ctx, LockTarget target) {
        int numLocks = this.lockManager.getNumLockers(target);
        Integer lockedManually = this.lockManager.getLockedManually(target);
        if (lockedManually == null) {
            if (numLocks == 0) {
                TextTools.replyFormatted(ctx, "The %s %sn't locked", target.getPrettyString(), target.getIs());
                return 1;
            }
            TextTools.replyFormatted(ctx, "The %s %sn't locked manually but there %s %s %s active. Clear them with by appending 'clear' to this command", target.getPrettyString(), target.getIs(), numLocks > 1 ? "are" : "is", numLocks, numLocks > 1 ? "lockers" : "locker");
            return 1;
        }
        this.lockManager.lockManually(null, target);
        if (lockedManually > 0 && numLocks > 0) {
            this.replyAndBroadcastLock(ctx, "$bUnlocked$b the %s but there %s still $b%s %s$b active", target.getPrettyString(), numLocks > 1 ? "are" : "is", numLocks, numLocks > 1 ? "lockers" : "locker");
            return 1;
        }
        this.replyAndBroadcastLock(ctx, "$bUnlocked$b the %s", target.getPrettyString());
        return 1;
    }

    private int unlockClear(CommandContext<class_2168> ctx, LockTarget target) {
        int numLocks = this.lockManager.getNumLockers(target);
        Integer lockedManually = this.lockManager.getLockedManually(target);
        if (numLocks == 0 && lockedManually == null) {
            TextTools.replyFormatted(ctx, "Nothing to unlock and no lockers to clear", new Object[0]);
            return 1;
        }
        this.lockManager.clearLockers(target);
        this.lockManager.lockManually(null, target);
        if (lockedManually != null && lockedManually > 0 && numLocks > 0) {
            this.replyAndBroadcastLock(ctx, "$bUnlocked$b the %s and $bcleared %s %s", target.getPrettyString(), numLocks, numLocks > 1 ? "lockers" : "locker");
            return 1;
        }
        if (lockedManually != null && lockedManually > 0) {
            this.replyAndBroadcastLock(ctx, "$bUnlocked$b the %s", target.getPrettyString());
            return 1;
        }
        this.replyAndBroadcastLock(ctx, "$bCleared %s %s", numLocks, numLocks > 1 ? "lockers" : "locker");
        return 1;
    }

    public int allChunks(CommandContext<class_2168> ctx) {
        return this.lock(ctx, LockTarget.ALL);
    }

    public int allChunksTimeoutTicks(CommandContext<class_2168> ctx) {
        return this.lockTimeout(ctx, LockTarget.ALL);
    }

    public int allChunksPlayerDisconnect(CommandContext<class_2168> ctx) {
        return this.lockPlayerDisconnect(ctx, LockTarget.ALL);
    }

    public int allChunksPlayerMove(CommandContext<class_2168> ctx) {
        return this.lockPlayerMove(ctx, LockTarget.ALL);
    }

    public int viewChunks(CommandContext<class_2168> ctx) {
        return this.lock(ctx, LockTarget.VIEW);
    }

    public int viewChunksTimeoutTicks(CommandContext<class_2168> ctx) {
        return this.lockTimeout(ctx, LockTarget.VIEW);
    }

    public int viewChunksPlayerDisconnect(CommandContext<class_2168> ctx) {
        return this.lockPlayerDisconnect(ctx, LockTarget.VIEW);
    }

    public int viewChunksPlayerMove(CommandContext<class_2168> ctx) {
        return this.lockPlayerMove(ctx, LockTarget.VIEW);
    }

    public int simChunks(CommandContext<class_2168> ctx) {
        return this.lock(ctx, LockTarget.SIM);
    }

    public int simChunksTimeoutTicks(CommandContext<class_2168> ctx) {
        return this.lockTimeout(ctx, LockTarget.SIM);
    }

    public int simChunksPlayerDisconnect(CommandContext<class_2168> ctx) {
        return this.lockPlayerDisconnect(ctx, LockTarget.SIM);
    }

    public int simChunksPlayerMove(CommandContext<class_2168> ctx) {
        return this.lockPlayerMove(ctx, LockTarget.SIM);
    }

    public int unlockAll(CommandContext<class_2168> ctx) {
        return this.unlock(ctx, LockTarget.ALL);
    }

    public int unlockAllClear(CommandContext<class_2168> ctx) {
        return this.unlockClear(ctx, LockTarget.ALL);
    }

    public int unlockView(CommandContext<class_2168> ctx) {
        return this.unlock(ctx, LockTarget.VIEW);
    }

    public int unlockViewClear(CommandContext<class_2168> ctx) {
        return this.unlockClear(ctx, LockTarget.VIEW);
    }

    public int unlockSim(CommandContext<class_2168> ctx) {
        return this.unlock(ctx, LockTarget.SIM);
    }

    public int unlockSimClear(CommandContext<class_2168> ctx) {
        return this.unlockClear(ctx, LockTarget.SIM);
    }

    public void registerCommands(LiteralArgumentBuilder<class_2168> builder) {
        ((LiteralArgumentBuilder)builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"lock").executes(this::status)).then(class_2170.method_9247((String)"status").executes(this::status))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"all").requires(source -> source.method_9259(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"chunks", (ArgumentType)IntegerArgumentType.integer((int)2, (int)32)).executes(this::allChunks)).then(class_2170.method_9247((String)"timeout").then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(this::allChunksTimeoutTicks)))).then(class_2170.method_9247((String)"player").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9247((String)"disconnect").executes(this::allChunksPlayerDisconnect))).then(class_2170.method_9247((String)"move").executes(this::allChunksPlayerMove))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"view").requires(source -> source.method_9259(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"chunks", (ArgumentType)IntegerArgumentType.integer((int)2, (int)32)).executes(this::viewChunks)).then(class_2170.method_9247((String)"timeout").then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(this::viewChunksTimeoutTicks)))).then(class_2170.method_9247((String)"player").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9247((String)"disconnect").executes(this::viewChunksPlayerDisconnect))).then(class_2170.method_9247((String)"move").executes(this::viewChunksPlayerMove))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"simulation").requires(source -> source.method_9259(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"chunks", (ArgumentType)IntegerArgumentType.integer((int)2, (int)32)).executes(this::simChunks)).then(class_2170.method_9247((String)"timeout").then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(this::simChunksTimeoutTicks)))).then(class_2170.method_9247((String)"player").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9247((String)"disconnect").executes(this::simChunksPlayerDisconnect))).then(class_2170.method_9247((String)"move").executes(this::simChunksPlayerMove)))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"unlock").requires(source -> source.method_9259(2))).executes(this::unlockAll)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"all").executes(this::unlockAll)).then(class_2170.method_9247((String)"clear").executes(this::unlockAllClear)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"view").executes(this::unlockView)).then(class_2170.method_9247((String)"clear").executes(this::unlockViewClear)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"simulation").executes(this::unlockSim)).then(class_2170.method_9247((String)"clear").executes(this::unlockSimClear))));
    }
}

