/*
 * Decompiled with CFR 0.152.
 */
package net.treset.adaptiveview.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import net.treset.adaptiveview.config.Config;
import net.treset.adaptiveview.distance.ViewDistanceHandler;
import net.treset.adaptiveview.tools.NotificationState;
import net.treset.adaptiveview.tools.TextTools;
import net.treset.adaptiveview.unlocking.LockManager;

public class NotificationCommandHandler {
    private final Config config;

    public NotificationCommandHandler(Config config) {
        this.config = config;
    }

    public int notifications(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            TextTools.replyError(ctx, "Error getting player from command context!");
            return 0;
        }
        Object status = "You are ";
        NotificationState changeState = NotificationState.getFromPlayer(player, this.config.getBroadcastChanges());
        NotificationState lockState = NotificationState.getFromPlayer(player, this.config.getBroadcastLock());
        switch (changeState) {
            case NONE: {
                if (ViewDistanceHandler.shouldBroadcastChange(player, this.config)) {
                    status = (String)status + "receiving view distance change notifications by default";
                    break;
                }
                status = (String)status + "not receiving view distance change notifications";
                break;
            }
            case ADDED: {
                status = (String)status + "subscribed to view distance change notifications";
                break;
            }
            case REMOVED: {
                status = (String)status + "unsubscribed from view distance change notifications";
            }
        }
        status = (String)status + " and ";
        switch (lockState) {
            case NONE: {
                if (LockManager.shouldBroadcastLock(player, this.config)) {
                    status = (String)status + "receiving lock notifications by default";
                    break;
                }
                status = (String)status + "not receiving lock notifications";
                break;
            }
            case ADDED: {
                status = (String)status + "subscribed to lock notifications";
                break;
            }
            case REMOVED: {
                status = (String)status + "unsubscribed from lock notifications";
            }
        }
        status = (String)status + ".";
        TextTools.replyFormatted(ctx, (String)status, new Object[0]);
        return 1;
    }

    public int notificationsChanges(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            TextTools.replyError(ctx, "Error getting player from command context!");
            return 0;
        }
        String status = "";
        NotificationState state = NotificationState.getFromPlayer(player, this.config.getBroadcastChanges());
        switch (state) {
            case NONE: {
                if (ViewDistanceHandler.shouldBroadcastChange(player, this.config)) {
                    status = "You are receiving view distance change notifications by default.";
                    break;
                }
                status = "You are not receiving view distance change notifications.";
                break;
            }
            case ADDED: {
                status = "You are subscribed to view distance change notifications.";
                break;
            }
            case REMOVED: {
                status = "You are unsubscribed from view distance change notifications.";
            }
        }
        TextTools.replyFormatted(ctx, status, new Object[0]);
        return 1;
    }

    public int notificationsChangesSubscribe(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            TextTools.replyError(ctx, "Error getting player from command context!");
            return 0;
        }
        NotificationState state = NotificationState.getFromPlayer(player, this.config.getBroadcastChanges());
        switch (state) {
            case NONE: {
                this.config.getBroadcastChanges().add(player.method_5477().getString().toLowerCase());
                TextTools.replyFormatted(ctx, "Subscribed to view distance change notifications.", new Object[0]);
                break;
            }
            case ADDED: {
                TextTools.replyFormatted(ctx, "You are already subscribed to view distance change notifications.", new Object[0]);
                break;
            }
            case REMOVED: {
                this.config.getBroadcastChanges().removeIf(s -> s.startsWith("!") && s.substring(1).equalsIgnoreCase(player.method_5477().getString()));
                this.config.getBroadcastChanges().add(player.method_5477().getString().toLowerCase());
                TextTools.replyFormatted(ctx, "Resubscribed to view distance change notifications.", new Object[0]);
            }
        }
        this.config.save();
        return 1;
    }

    public int notificationsChangesUnsubscribe(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            TextTools.replyError(ctx, "Error getting player from command context!");
            return 0;
        }
        NotificationState state = NotificationState.getFromPlayer(player, this.config.getBroadcastChanges());
        switch (state) {
            case NONE: {
                this.config.getBroadcastChanges().add("!" + player.method_5477().getString().toLowerCase());
                TextTools.replyFormatted(ctx, "Unsubscribed from view distance change notifications.", new Object[0]);
                break;
            }
            case ADDED: {
                this.config.getBroadcastChanges().remove(player.method_5477().getString().toLowerCase());
                this.config.getBroadcastChanges().add("!" + player.method_5477().getString().toLowerCase());
                TextTools.replyFormatted(ctx, "Unsubscribed from view distance change notifications.", new Object[0]);
                break;
            }
            case REMOVED: {
                TextTools.replyFormatted(ctx, "You are already unsubscribed from view distance change notifications.", new Object[0]);
            }
        }
        this.config.save();
        return 1;
    }

    public int notificationsLock(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            TextTools.replyError(ctx, "Error getting player from command context!");
            return 0;
        }
        String status = "";
        NotificationState state = NotificationState.getFromPlayer(player, this.config.getBroadcastLock());
        switch (state) {
            case NONE: {
                if (LockManager.shouldBroadcastLock(player, this.config)) {
                    status = "You are receiving lock notifications by default.";
                    break;
                }
                status = "You are not receiving lock notifications.";
                break;
            }
            case ADDED: {
                status = "You are subscribed to lock notifications.";
                break;
            }
            case REMOVED: {
                status = "You are unsubscribed from lock notifications.";
            }
        }
        TextTools.replyFormatted(ctx, status, new Object[0]);
        return 1;
    }

    public int notificationsLockSubscribe(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            TextTools.replyError(ctx, "Error getting player from command context!");
            return 0;
        }
        NotificationState state = NotificationState.getFromPlayer(player, this.config.getBroadcastLock());
        switch (state) {
            case NONE: {
                this.config.getBroadcastLock().add(player.method_5477().getString().toLowerCase());
                TextTools.replyFormatted(ctx, "Subscribed to lock notifications.", new Object[0]);
                break;
            }
            case ADDED: {
                TextTools.replyFormatted(ctx, "You are already subscribed to lock notifications.", new Object[0]);
                break;
            }
            case REMOVED: {
                this.config.getBroadcastLock().removeIf(s -> s.startsWith("!") && s.substring(1).equalsIgnoreCase(player.method_5477().getString()));
                this.config.getBroadcastLock().add(player.method_5477().getString().toLowerCase());
                TextTools.replyFormatted(ctx, "Resubscribed to lock notifications.", new Object[0]);
            }
        }
        this.config.save();
        return 1;
    }

    public int notificationsLockUnsubscribe(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            TextTools.replyError(ctx, "Error getting player from command context!");
            return 0;
        }
        NotificationState state = NotificationState.getFromPlayer(player, this.config.getBroadcastLock());
        switch (state) {
            case NONE: {
                this.config.getBroadcastLock().add("!" + player.method_5477().getString().toLowerCase());
                TextTools.replyFormatted(ctx, "Unsubscribed from lock notifications.", new Object[0]);
                break;
            }
            case ADDED: {
                this.config.getBroadcastLock().remove(player.method_5477().getString().toLowerCase());
                this.config.getBroadcastLock().add("!" + player.method_5477().getString().toLowerCase());
                TextTools.replyFormatted(ctx, "Unsubscribed from lock notifications.", new Object[0]);
                break;
            }
            case REMOVED: {
                TextTools.replyFormatted(ctx, "You are already unsubscribed from lock notifications.", new Object[0]);
            }
        }
        this.config.save();
        return 1;
    }

    public void registerCommands(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"notifications").executes(this::notifications)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"changes").executes(this::notificationsChanges)).then(class_2170.method_9247((String)"subscribe").executes(this::notificationsChangesSubscribe))).then(class_2170.method_9247((String)"unsubscribe").executes(this::notificationsChangesUnsubscribe)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"lock").executes(this::notificationsLock)).then(class_2170.method_9247((String)"subscribe").executes(this::notificationsLockSubscribe))).then(class_2170.method_9247((String)"unsubscribe").executes(this::notificationsLockUnsubscribe))));
    }
}

