/*
 * Decompiled with CFR 0.152.
 */
package net.treset.adaptiveview.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import net.treset.adaptiveview.AdaptiveViewMod;

public class OldConfig {
    private static final File configFile = new File("./config/adaptiveview.json");
    private static final File oldConfigFile = new File("./config/dynview.json");
    private int locked = 0;
    private int updateInterval = 600;
    private int minMspt = 40;
    private int maxMspt = 50;
    private int minMsptAggressive = 60;
    private int maxMsptAggressive = 30;
    private int minViewDistance = 4;
    private int maxViewDistance = 20;
    private boolean overrideClient = false;

    public static OldConfig load() {
        String json;
        File file = configFile;
        if (!file.exists() && !(file = oldConfigFile).exists()) {
            return null;
        }
        try {
            json = Files.readString(file.toPath());
        }
        catch (IOException e) {
            AdaptiveViewMod.LOGGER.warn("Failed to read old config file", (Throwable)e);
            return new OldConfig();
        }
        if (file == oldConfigFile) {
            try {
                Files.delete(oldConfigFile.toPath());
            }
            catch (IOException e) {
                AdaptiveViewMod.LOGGER.warn("Failed to delete old old config file", (Throwable)e);
            }
        }
        try {
            return (OldConfig)new Gson().fromJson(json, OldConfig.class);
        }
        catch (JsonSyntaxException e) {
            AdaptiveViewMod.LOGGER.error("Failed to parse old config file", (Throwable)e);
            return null;
        }
    }

    public void save() {
        if (!configFile.exists()) {
            try {
                Files.createDirectories(configFile.getParentFile().toPath(), new FileAttribute[0]);
                Files.createFile(configFile.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                AdaptiveViewMod.LOGGER.error("Failed to create config file", (Throwable)e);
            }
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((Object)this);
        try {
            Files.writeString(configFile.toPath(), (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            AdaptiveViewMod.LOGGER.error("Failed to write config file", (Throwable)e);
        }
    }

    public int getLocked() {
        return this.locked;
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    public int getMinMspt() {
        return this.minMspt;
    }

    public int getMaxMspt() {
        return this.maxMspt;
    }

    public int getMinMsptAggressive() {
        return this.minMsptAggressive;
    }

    public int getMaxMsptAggressive() {
        return this.maxMsptAggressive;
    }

    public int getMinViewDistance() {
        return this.minViewDistance;
    }

    public int getMaxViewDistance() {
        return this.maxViewDistance;
    }

    public void setLocked(int locked) {
        this.locked = locked;
    }

    public void setUpdateInterval(int updateInterval) {
        this.updateInterval = updateInterval;
    }

    public void setMinMspt(int minMspt) {
        this.minMspt = minMspt;
    }

    public void setMaxMspt(int maxMspt) {
        this.maxMspt = maxMspt;
    }

    public void setMinMsptAggressive(int minMsptAggressive) {
        this.minMsptAggressive = minMsptAggressive;
    }

    public void setMaxMsptAggressive(int maxMsptAggressive) {
        this.maxMsptAggressive = maxMsptAggressive;
    }

    public void setMinViewDistance(int minViewDistance) {
        this.minViewDistance = minViewDistance;
    }

    public void setMaxViewDistance(int maxViewDistance) {
        this.maxViewDistance = maxViewDistance;
    }

    public boolean isOverrideClient() {
        return this.overrideClient;
    }

    public void setOverrideClient(boolean overrideClient) {
        this.overrideClient = overrideClient;
    }
}

