/*
 * Decompiled with CFR 0.152.
 */
package net.treset.adaptiveview.config;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.List;
import net.treset.adaptiveview.config.RuleTarget;
import net.treset.adaptiveview.config.RuleType;
import net.treset.adaptiveview.config.ServerState;
import net.treset.adaptiveview.tools.TextTools;

public class Rule {
    private RuleType type;
    private String value;
    private Integer max;
    private Integer min;
    private RuleTarget target;
    private Integer updateRate;
    private Integer step;
    private Integer stepAfter;
    @SerializedName(value="max_distance", alternate={"max_view_distance"})
    private Integer maxDistance;
    @SerializedName(value="min_distance", alternate={"min_view_distance"})
    private Integer minDistance;
    private String name;
    private transient boolean valid = true;
    private transient int counter = 0;

    public Rule(RuleType type, String value, Integer max, Integer min, RuleTarget target, Integer updateRate, Integer step, Integer stepAfter, Integer maxDistance, Integer minDistance, String name) {
        this.type = type;
        this.value = value;
        this.max = max;
        this.min = min;
        this.target = target;
        this.updateRate = updateRate;
        this.step = step;
        this.stepAfter = stepAfter;
        this.maxDistance = maxDistance;
        this.minDistance = minDistance;
        this.name = name;
        this.setDefaults();
    }

    public boolean isEffective() {
        this.valid = this.isValid();
        return this.valid;
    }

    private boolean isValid() {
        this.setDefaults();
        switch (this.type) {
            case MSPT: {
                if (this.checkMinMaxValues(0, 1000)) break;
                return false;
            }
            case MEMORY: {
                if (this.checkMinMaxValues(0, 100)) break;
                return false;
            }
            case PLAYERS: {
                if (!(this.value == null ? !this.checkMinMaxValues(0, 500) : this.min != null || this.max != null)) break;
                return false;
            }
        }
        return this.updateRate != null || this.step != null || this.maxDistance != null || this.minDistance != null;
    }

    private void setDefaults() {
        if (this.target == null) {
            this.target = RuleTarget.VIEW;
        }
    }

    private boolean checkMinMaxValues(int minAllowed, int maxAllowed) {
        if (this.min == null && this.max == null) {
            return false;
        }
        if (this.min != null && this.max != null && this.min > this.max) {
            return false;
        }
        if (this.min != null && (this.min < minAllowed || this.min > maxAllowed)) {
            return false;
        }
        return this.max == null || this.max >= minAllowed && this.max <= maxAllowed;
    }

    public boolean applies(ServerState serverState) {
        if (!this.valid) {
            return false;
        }
        switch (this.type) {
            case MSPT: {
                if (!this.valueInMinMax(serverState.getMspt())) break;
                return true;
            }
            case MEMORY: {
                if (!this.valueInMinMax(serverState.getMemory())) break;
                return true;
            }
            case PLAYERS: {
                if (this.value != null) {
                    List<String> players = this.splitPlayers(this.value);
                    if (!(this.value.startsWith("&") ? players.stream().allMatch(p -> this.containsPlayer(serverState, (String)p)) : (this.value.startsWith("!") ? serverState.getPlayers().stream().anyMatch(p -> !TextTools.containsIgnoreCase(players, p)) : (this.value.startsWith("\\") ? players.stream().noneMatch(p -> this.containsPlayer(serverState, (String)p)) : players.stream().anyMatch(p -> this.containsPlayer(serverState, (String)p)))))) break;
                    return true;
                }
                if (!this.valueInMinMax(serverState.getPlayers().size())) break;
                return true;
            }
        }
        return false;
    }

    private List<String> splitPlayers(String value) {
        String players = value;
        if (players.startsWith("&") || players.startsWith("!") || players.startsWith("\\")) {
            players = players.substring(1);
        }
        String[] playerArray = players.split(",");
        List<String> playerList = Arrays.stream(playerArray).map(String::trim).toList();
        return playerList;
    }

    private boolean containsPlayer(ServerState serverState, String player) {
        return TextTools.containsIgnoreCase(serverState.getPlayers(), player);
    }

    private boolean valueInMinMax(double value) {
        if (this.min != null) {
            return (double)this.min.intValue() <= value && (this.max == null || (double)this.max.intValue() >= value);
        }
        return this.max != null && (double)this.max.intValue() >= value;
    }

    public String toConditionString() {
        StringBuilder sb = new StringBuilder();
        if (this.min != null && this.max != null) {
            sb.append("$b").append(this.min).append(" <= ").append(this.type.toString().toLowerCase()).append(" <= ").append(this.max).append("$b");
        } else if (this.min != null) {
            sb.append("$b").append(this.type.toString().toLowerCase()).append(" >= ").append(this.min).append("$b");
        } else if (this.max != null) {
            sb.append("$b").append(this.type.toString().toLowerCase()).append(" <= ").append(this.max).append("$b");
        } else if (this.value != null) {
            sb.append("$b").append(this.type.toString().toLowerCase()).append(" = ").append(this.value).append("$b");
        } else {
            sb.append("$b").append(this.type.toString().toLowerCase()).append("$b");
        }
        return sb.toString();
    }

    public String toActionString() {
        StringBuilder sb = new StringBuilder();
        sb.append("$b").append(this.target.getName()).append("$b").append(": ");
        int len = 0;
        if (this.updateRate != null) {
            sb.append("$bupdate_rate = ").append(this.updateRate).append("$b");
            ++len;
        }
        if (this.step != null) {
            if (len > 0) {
                sb.append(", ");
            }
            sb.append("$bstep = ").append(this.step).append("$b");
            ++len;
            if (this.stepAfter != null) {
                sb.append(", $bstep_after = ").append(this.stepAfter).append("$b");
            }
        }
        if (this.maxDistance != null) {
            if (len > 0) {
                sb.append(", ");
            }
            sb.append("$bmax_distance = ").append(this.maxDistance).append("$b");
            ++len;
        }
        if (this.minDistance != null) {
            if (len > 0) {
                sb.append(", ");
            }
            sb.append("$bmin_distance = ").append(this.minDistance).append("$b");
            ++len;
        }
        if (len == 0) {
            sb.append("$bno action").append("$b");
        }
        return sb.toString();
    }

    public String toString() {
        Object str = this.name == null ? "" : "$b" + this.name + "$b: ";
        str = (String)str + "Condition: " + this.toConditionString() + "; Action: " + this.toActionString();
        if (!this.valid) {
            str = (String)str + " $R($bIneffective!$b)$W";
        }
        return str;
    }

    public RuleType getType() {
        return this.type;
    }

    public void setType(RuleType type) {
        this.type = type;
        this.isEffective();
    }

    public RuleTarget getTarget() {
        return this.target;
    }

    public void setTarget(RuleTarget target) {
        this.target = target;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.isEffective();
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        this.max = max;
        this.isEffective();
    }

    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer min) {
        this.min = min;
        this.isEffective();
    }

    public Integer getUpdateRate() {
        return this.updateRate;
    }

    public void setUpdateRate(Integer updateRate) {
        this.updateRate = updateRate;
        this.isEffective();
    }

    public void incrementCounter() {
        ++this.counter;
    }

    public Integer getStep() {
        if (this.stepAfter != null && this.counter % this.stepAfter != 0) {
            return 0;
        }
        return this.step;
    }

    public void setStep(Integer step) {
        this.step = step;
        this.isEffective();
    }

    public Integer getStepAfter() {
        return this.stepAfter;
    }

    public void setStepAfter(Integer stepAfter) {
        this.stepAfter = stepAfter;
        this.isEffective();
    }

    public Integer getMaxDistance() {
        return this.maxDistance;
    }

    public void setMaxDistance(Integer maxDistance) {
        this.maxDistance = maxDistance;
        this.isEffective();
    }

    public Integer getMinDistance() {
        return this.minDistance;
    }

    public void setMinDistance(Integer minDistance) {
        this.minDistance = minDistance;
        this.isEffective();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

