/*
 * Decompiled with CFR 0.152.
 */
package net.treset.adaptiveview.distance;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.treset.adaptiveview.AdaptiveViewMod;
import net.treset.adaptiveview.config.Config;
import net.treset.adaptiveview.config.ServerState;
import net.treset.adaptiveview.distance.ViewDistanceHandler;
import net.treset.adaptiveview.tools.MathTools;
import net.treset.adaptiveview.unlocking.LockManager;

public class ServerHandler {
    private static final ArrayList<Long> tickLengths = new ArrayList();
    private final Config config;
    private final LockManager lockManager;
    private final ViewDistanceHandler viewDistanceHandler;
    private int tickCounter = 0;
    private int nextUpdate;

    public static ArrayList<Long> getTickLengths() {
        return tickLengths;
    }

    public ServerHandler(Config config, LockManager lockManager, ViewDistanceHandler viewDistanceHandler) {
        this.config = config;
        this.lockManager = lockManager;
        this.viewDistanceHandler = viewDistanceHandler;
        this.nextUpdate = config.getUpdateRate();
    }

    public void onTick(MinecraftServer server) {
        if (AdaptiveViewMod.isClient() && !this.config.isAllowOnClient()) {
            return;
        }
        this.lockManager.onTick();
        ++this.tickCounter;
        if (this.tickCounter == this.nextUpdate) {
            ServerState state = new ServerState(ViewDistanceHandler.getViewDistance(), ViewDistanceHandler.getSimDistance(), (double)MathTools.longArrayAverage(tickLengths.toArray(new Long[0])) / 1000000.0, ServerHandler.getMemory(), ServerHandler.getPlayers());
            this.tickCounter = 0;
            this.nextUpdate = this.viewDistanceHandler.updateViewDistance(state);
            tickLengths.clear();
        }
    }

    public static double getMemory() {
        long allocatedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        long maxMemory = Runtime.getRuntime().maxMemory();
        return (double)allocatedMemory / (double)maxMemory * 100.0;
    }

    public static List<String> getPlayers() {
        MinecraftServer server = AdaptiveViewMod.getServer();
        return server.method_3760().method_14571().stream().map(p -> p.method_5477().getString()).toList();
    }
}

