/*
 * Decompiled with CFR 0.152.
 */
package net.treset.adaptiveview.unlocking;

import net.treset.adaptiveview.tools.Message;
import net.treset.adaptiveview.tools.TextTools;
import net.treset.adaptiveview.unlocking.LockManager;
import net.treset.adaptiveview.unlocking.LockTarget;

public abstract class Locker {
    private final LockManager lockManager;
    private LockTarget target;
    private final int distance;

    public Locker(int distance, LockTarget target, LockManager lockManager) {
        this.lockManager = lockManager;
        this.target = target;
        this.distance = distance;
    }

    public final void onTick() {
        this.beforeTick();
        if (this.shouldUnlock()) {
            this.lockManager.finishLocker(this);
            TextTools.broadcastIf(p -> LockManager.shouldBroadcastLock(p, this.lockManager.getConfig()), "Cleared View distance lock of $b%s chunks$b after %s", this.distance, this.getUnlockReason());
        }
    }

    public int getDistance() {
        return this.distance;
    }

    public LockTarget getTarget() {
        return this.target;
    }

    public void setTarget(LockTarget target) {
        this.target = target;
    }

    public void beforeTick() {
    }

    public abstract boolean shouldUnlock();

    public abstract Message getUnlockReason();

    public abstract Message getLockedReason();
}

