/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component;

import artifacts.ability.ArtifactAbility;
import artifacts.ability.CollideWithFluidsAbility;
import artifacts.component.SwimData;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModAbilities;
import artifacts.util.AbilityHelper;
import be.florens.expandability.api.EventResult;
import dev.architectury.event.events.common.TickEvent;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3486;
import net.minecraft.class_3610;

public class SwimEvents {
    public static void register() {
        TickEvent.PLAYER_PRE.register(SwimEvents::onPlayerTick);
    }

    private static void onPlayerTick(class_1657 player) {
        SwimData swimData = PlatformServices.platformHelper.getSwimData((class_1309)player);
        if (swimData != null) {
            if (player.method_5799() || player.method_5771() || player.field_6017 > 6.0f) {
                if (!swimData.isWet()) {
                    swimData.setWet(true);
                }
            } else if (player.method_24828() || player.method_31549().field_7479) {
                swimData.setWet(false);
            }
        }
    }

    public static EventResult onPlayerSwim(class_1657 player) {
        SwimData swimData = PlatformServices.platformHelper.getSwimData((class_1309)player);
        if (swimData != null) {
            if (swimData.isSwimming()) {
                return EventResult.SUCCESS;
            }
            if (AbilityHelper.hasAbilityActive((ArtifactAbility.Type)ModAbilities.SINKING.comp_349(), (class_1309)player)) {
                return EventResult.FAIL;
            }
        }
        return EventResult.PASS;
    }

    public static boolean onFluidCollision(class_1309 player, class_3610 fluidState) {
        SwimData swimData = PlatformServices.platformHelper.getSwimData(player);
        if (swimData == null || swimData.isWet() || swimData.isSwimming()) {
            return false;
        }
        if (SwimEvents.canSprintOnFluid(player, fluidState) || SwimEvents.canSneakOnFluid(player, fluidState)) {
            SwimEvents.dealLavaDamage(player, fluidState);
            return true;
        }
        return false;
    }

    private static boolean canSprintOnFluid(class_1309 entity, class_3610 fluidState) {
        return SwimEvents.canCollideWithFluid(entity, fluidState, (ArtifactAbility.Type)ModAbilities.SPRINT_ON_FLUIDS.comp_349()) && entity.method_5624() && !entity.method_6115() && !entity.method_18276();
    }

    private static boolean canSneakOnFluid(class_1309 entity, class_3610 fluidState) {
        return entity.method_18276() && SwimEvents.canCollideWithFluid(entity, fluidState, (ArtifactAbility.Type)ModAbilities.SNEAK_ON_FLUIDS.comp_349());
    }

    private static boolean canCollideWithFluid(class_1309 entity, class_3610 fluidState, ArtifactAbility.Type<CollideWithFluidsAbility> type) {
        return AbilityHelper.hasAbilityActive(type, entity, ability -> ability.tag().isEmpty() || fluidState.method_15767(ability.tag().get()));
    }

    private static void dealLavaDamage(class_1309 entity, class_3610 fluidState) {
        if (fluidState.method_15767(class_3486.field_15518) && !entity.method_5753()) {
            entity.method_5643(entity.method_48923().method_48820(), 1.0f);
        }
    }
}

