/*
 * Decompiled with CFR 0.152.
 */
package atonkish.reinfshulker.gametest.testcase;

import atonkish.reinfcore.util.ReinforcingMaterials;
import atonkish.reinfshulker.ReinforcedShulkerBoxesMod;
import atonkish.reinfshulker.block.ModBlocks;
import atonkish.reinfshulker.block.ReinforcedShulkerBoxBlock;
import atonkish.reinfshulker.gametest.util.MockServerPlayerHelper;
import atonkish.reinfshulker.item.ModItems;
import atonkish.reinfshulker.stat.ModStats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3445;
import net.minecraft.class_3468;
import net.minecraft.class_4525;
import net.minecraft.class_4529;

public class CauldronBehaviorTests {
    private static final String BATCH_ID = String.format("%s:CauldronBehaviorBatch", "reinfshulker");
    public static final Collection<class_4529> TEST_FUNCTIONS = new ArrayList<class_4529>(){
        {
            ReinforcedShulkerBoxBlock shulkerBoxBlock;
            for (class_1767 color : class_1767.values()) {
                shulkerBoxBlock = (ReinforcedShulkerBoxBlock)ModBlocks.REINFORCED_SHULKER_BOX_MAP.get(ReinforcingMaterials.MAP.get("copper")).get(color);
                this.add(CauldronBehaviorTests.createTest(String.format("Clean %s", shulkerBoxBlock.method_9518().getString()), shulkerBoxBlock));
            }
            for (class_1767 color : class_1767.values()) {
                shulkerBoxBlock = (ReinforcedShulkerBoxBlock)ModBlocks.REINFORCED_SHULKER_BOX_MAP.get(ReinforcingMaterials.MAP.get("iron")).get(color);
                this.add(CauldronBehaviorTests.createTest(String.format("Clean %s", shulkerBoxBlock.method_9518().getString()), shulkerBoxBlock));
            }
            for (class_1767 color : class_1767.values()) {
                shulkerBoxBlock = (ReinforcedShulkerBoxBlock)ModBlocks.REINFORCED_SHULKER_BOX_MAP.get(ReinforcingMaterials.MAP.get("gold")).get(color);
                this.add(CauldronBehaviorTests.createTest(String.format("Clean %s", shulkerBoxBlock.method_9518().getString()), shulkerBoxBlock));
            }
            for (class_1767 color : class_1767.values()) {
                shulkerBoxBlock = (ReinforcedShulkerBoxBlock)ModBlocks.REINFORCED_SHULKER_BOX_MAP.get(ReinforcingMaterials.MAP.get("diamond")).get(color);
                this.add(CauldronBehaviorTests.createTest(String.format("Clean %s", shulkerBoxBlock.method_9518().getString()), shulkerBoxBlock));
            }
            for (class_1767 color : class_1767.values()) {
                shulkerBoxBlock = (ReinforcedShulkerBoxBlock)ModBlocks.REINFORCED_SHULKER_BOX_MAP.get(ReinforcingMaterials.MAP.get("netherite")).get(color);
                this.add(CauldronBehaviorTests.createTest(String.format("Clean %s", shulkerBoxBlock.method_9518().getString()), shulkerBoxBlock));
            }
        }
    };

    private static class_4529 createTest(String name, ReinforcedShulkerBoxBlock shulkerBoxBlock) {
        String testName = String.format("%s %s %s", "reinfshulker", CauldronBehaviorTests.class.getSimpleName(), name).replace(" ", "_");
        return new class_4529(BATCH_ID, testName, "fabric-gametest-api-v1:empty", class_4525.method_29408((int)0), 100, 0L, true, false, 1, 1, false, context -> {
            class_2338 blockPos = class_2338.field_10980;
            context.method_35986(blockPos, (class_2680)class_2246.field_27097.method_9564().method_11657((class_2769)class_2741.field_12513, (Comparable)Integer.valueOf(3)));
            class_3222 player = MockServerPlayerHelper.spawn(context, class_1934.field_9215, class_243.method_24954((class_2382)blockPos.method_10077(4)));
            player.method_6122(class_1268.field_5808, new class_1799((class_1935)shulkerBoxBlock.method_8389()));
            class_3445 stat = class_3468.field_15419.method_14956((Object)ModStats.CLEAN_REINFORCED_SHULKER_BOX_MAP.get(shulkerBoxBlock.getMaterial()));
            CompletableFuture futurePartialAct1 = new CompletableFuture();
            CompletableFuture futurePartialAct2 = new CompletableFuture();
            HashMap statMap = new HashMap();
            String statMapKeyBeforeCleaning = "beforeCleaning";
            String statMapKeyAfterCleaning = "afterCleaning";
            long tickOrigin = 0L;
            context.method_35951(tickOrigin, () -> {
                statMap.put(statMapKeyBeforeCleaning, player.method_14248().method_15025(stat));
                context.method_36034(blockPos, (class_1657)player);
                futurePartialAct1.complete(null);
            });
            long tickShulkerBoxCleaning = 1L;
            context.method_35951(tickShulkerBoxCleaning, () -> {
                statMap.put(statMapKeyAfterCleaning, player.method_14248().method_15025(stat));
                futurePartialAct2.complete(null);
            });
            CompletableFuture.allOf(futurePartialAct1, futurePartialAct2).thenRun(() -> {
                try {
                    context.method_56606((Object)player.method_6047().method_7909(), (Object)ModItems.REINFORCED_SHULKER_BOX_MAP.get(shulkerBoxBlock.getMaterial()).get(null), "main hand item");
                    context.method_56606((Object)((Integer)context.method_35980(blockPos).method_11654((class_2769)class_2741.field_12513)), (Object)2, "fluid level");
                    context.method_56606((Object)((Integer)statMap.get(statMapKeyAfterCleaning) - (Integer)statMap.get(statMapKeyBeforeCleaning)), (Object)1, String.format("diff %s value", stat.method_1225()));
                }
                catch (Exception e) {
                    ReinforcedShulkerBoxesMod.LOGGER.error("[{}] {}", (Object)testName, (Object)e.getMessage());
                    throw e;
                }
                finally {
                    MockServerPlayerHelper.destroy(context, player);
                }
                context.method_36036();
            });
        });
    }
}

