/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.mixin.common.JigsawStructureAccessor;
import dev.worldgen.lithostitched.worldgen.LithostitchedCodecs;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import dev.worldgen.lithostitched.worldgen.structure.AlternateJigsawStructure;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_3195;
import net.minecraft.class_5434;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_8889;

public record SetPoolAliasesModifier(class_6885<class_3195> structures, List<class_8889> poolAliases, boolean append) implements Modifier
{
    public static final MapCodec<SetPoolAliasesModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LithostitchedCodecs.registrySet(class_7924.field_41246, "structures").forGetter(SetPoolAliasesModifier::structures), (App)Codec.list((Codec)class_8889.field_46825).fieldOf("pool_aliases").forGetter(SetPoolAliasesModifier::poolAliases), (App)Codec.BOOL.fieldOf("append").orElse((Object)true).forGetter(SetPoolAliasesModifier::append)).apply((Applicative)instance, SetPoolAliasesModifier::new)).validate(SetPoolAliasesModifier::validate);

    private static DataResult<SetPoolAliasesModifier> validate(SetPoolAliasesModifier modifier) {
        for (class_6880 holder : modifier.structures) {
            class_3195 structure = (class_3195)holder.comp_349();
            if (structure instanceof class_5434 || structure instanceof AlternateJigsawStructure) continue;
            return DataResult.error(() -> "Target structure for pool alias additions should be a jigsaw structure");
        }
        return DataResult.success((Object)modifier);
    }

    @Override
    public Modifier.ModifierPhase getPhase() {
        return this.append ? Modifier.ModifierPhase.REPLACE : Modifier.ModifierPhase.ADD;
    }

    @Override
    public void applyModifier() {
        this.structures.method_40239().map(class_6880::comp_349).forEach(this::applyModifier);
    }

    private void applyModifier(class_3195 structure) {
        if (structure instanceof AlternateJigsawStructure) {
            AlternateJigsawStructure alternateJigsaw = (AlternateJigsawStructure)structure;
            alternateJigsaw.setPoolAliases(this.poolAliases, this.append);
        } else {
            ArrayList<class_8889> mergedAliases = new ArrayList<class_8889>();
            if (this.append) {
                mergedAliases.addAll(((JigsawStructureAccessor)structure).getPoolAliases());
            }
            mergedAliases.addAll(this.poolAliases);
            ((JigsawStructureAccessor)structure).setPoolAliases(mergedAliases);
        }
    }

    @Override
    public MapCodec<? extends Modifier> codec() {
        return CODEC;
    }
}

