/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer;

import com.mojang.brigadier.CommandDispatcher;
import de.maxhenkel.admiral.MinecraftAdmiral;
import de.maxhenkel.admiral.permissions.PermissionManager;
import de.maxhenkel.audioplayer.AudioCache;
import de.maxhenkel.audioplayer.AudioManager;
import de.maxhenkel.audioplayer.AudioPlayerPermissionManager;
import de.maxhenkel.audioplayer.FileNameManager;
import de.maxhenkel.audioplayer.VolumeOverrideManager;
import de.maxhenkel.audioplayer.command.ApplyCommands;
import de.maxhenkel.audioplayer.command.PlayCommands;
import de.maxhenkel.audioplayer.command.UploadCommands;
import de.maxhenkel.audioplayer.command.UtilityCommands;
import de.maxhenkel.audioplayer.command.VolumeCommands;
import de.maxhenkel.audioplayer.config.ServerConfig;
import de.maxhenkel.audioplayer.config.WebServerConfig;
import de.maxhenkel.audioplayer.configbuilder.ConfigBuilder;
import de.maxhenkel.audioplayer.webserver.WebServerEvents;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_7157;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AudioPlayer
implements ModInitializer {
    public static final String MODID = "audioplayer";
    public static final Logger LOGGER = LogManager.getLogger((String)"audioplayer");
    public static ServerConfig SERVER_CONFIG;
    public static WebServerConfig WEB_SERVER_CONFIG;
    public static AudioCache AUDIO_CACHE;
    public static ScheduledExecutorService SCHEDULED_EXECUTOR;

    public void onInitialize() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> MinecraftAdmiral.builder((CommandDispatcher)dispatcher, (class_7157)registryAccess).addCommandClasses(new Class[]{UploadCommands.class, ApplyCommands.class, UtilityCommands.class, VolumeCommands.class, PlayCommands.class}).setPermissionManager((PermissionManager)AudioPlayerPermissionManager.INSTANCE).build());
        VolumeOverrideManager.init();
        FileNameManager.init();
        Path configFolder = FabricLoader.getInstance().getConfigDir().resolve(MODID);
        SERVER_CONFIG = ConfigBuilder.builder(ServerConfig::new).path(configFolder.resolve("audioplayer-server.properties")).build();
        WEB_SERVER_CONFIG = AudioPlayer.SERVER_CONFIG.runWebServer.get() != false ? ConfigBuilder.builder(WebServerConfig::new).path(configFolder.resolve("webserver.properties")).build() : ConfigBuilder.builder(WebServerConfig::new).build();
        try {
            Files.createDirectories(AudioManager.getUploadFolder(), new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to create upload folder", (Throwable)e);
        }
        AUDIO_CACHE = new AudioCache(AudioPlayer.SERVER_CONFIG.cacheSize.get());
        ServerLifecycleEvents.SERVER_STARTED.register(WebServerEvents::onServerStarted);
        ServerLifecycleEvents.SERVER_STOPPING.register(WebServerEvents::onServerStopped);
    }

    static {
        SCHEDULED_EXECUTOR = Executors.newScheduledThreadPool(1, r -> {
            Thread thread = new Thread(r, "AudioPlayerExecutor");
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler((t, e) -> LOGGER.error("Uncaught exception in thread {}", (Object)t.getName(), (Object)e));
            return thread;
        });
    }
}

