/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.maxhenkel.audioplayer.AudioManager;
import de.maxhenkel.audioplayer.AudioPlayer;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.UUID;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.minecraft.server.MinecraftServer;

public class Filebin {
    public static final String USER_AGENT = "AudioPlayer/curl";

    public static void downloadSound(MinecraftServer server, UUID sound) throws IOException, InterruptedException, UnsupportedAudioFileException, URISyntaxException {
        String url = Filebin.getBin(sound);
        try (HttpClient client = HttpClient.newHttpClient();){
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Accept", "application/json").header("User-Agent", USER_AGENT).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new IOException("%s responded with status %s".formatted(url, response.statusCode()));
            }
            JsonElement json = JsonParser.parseString((String)response.body());
            if (!(json instanceof JsonObject)) {
                throw new IOException("Invalid response");
            }
            JsonObject object = (JsonObject)json;
            JsonElement filesElement = object.get("files");
            if (filesElement == null) {
                throw new IOException("No files uploaded");
            }
            if (!(filesElement instanceof JsonArray)) {
                throw new IOException("No files uploaded");
            }
            JsonArray files = (JsonArray)filesElement;
            for (JsonElement element : files) {
                if (!(element instanceof JsonObject)) continue;
                JsonObject file = (JsonObject)element;
                String contentType = file.get("content-type").getAsString();
                if (!contentType.equals("audio/wav") && !contentType.equals("audio/mpeg")) continue;
                long size = file.get("bytes").getAsLong();
                if (size > AudioPlayer.SERVER_CONFIG.maxUploadSize.get()) {
                    throw new IOException("Maximum file size exceeded (%sMB>%sMB)".formatted(Math.round((float)size / 1000000.0f), Math.round(AudioPlayer.SERVER_CONFIG.maxUploadSize.get().floatValue() / 1000000.0f)));
                }
                String filename = file.get("filename").getAsString();
                AudioManager.saveSound(server, sound, url + "/" + new URI(null, null, filename, null).toASCIIString());
                Filebin.deleteBin(url);
                return;
            }
            throw new IOException("No mp3 or wav files uploaded");
        }
    }

    public static void deleteBin(String url) {
        try (HttpClient client = HttpClient.newHttpClient();){
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Accept", "application/json").header("User-Agent", USER_AGENT).DELETE().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new IOException("%s responded with status %s".formatted(url, response.statusCode()));
            }
        }
        catch (Exception e) {
            AudioPlayer.LOGGER.warn("Failed to delete bin '{}'", (Object)url, (Object)e);
        }
    }

    public static String getBin(UUID sound) {
        Object filebinUrl = AudioPlayer.SERVER_CONFIG.filebinUrl.get();
        if (!((String)filebinUrl).endsWith("/")) {
            filebinUrl = (String)filebinUrl + "/";
        }
        return (String)filebinUrl + String.valueOf(sound);
    }
}

