/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting;

import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.predicate.ConnectionDirection;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.data.ConnectingTextureLayout;
import com.supermartijn642.fusion.model.types.connecting.ConnectingModelQuad;
import com.supermartijn642.fusion.model.types.connecting.OrientedMutableQuad;
import com.supermartijn642.fusion.model.types.connecting.SurroundingBlockCache;
import com.supermartijn642.fusion.texture.types.connecting.ConnectingTextureSprite;
import com.supermartijn642.fusion.texture.types.connecting.TextureConnections;
import com.supermartijn642.fusion.texture.types.connecting.layouts.ConnectingTextureLayoutHandler;
import com.supermartijn642.fusion.texture.types.continuous.ContinuousTextureSprite;
import com.supermartijn642.fusion.texture.types.continuous.ContinuousTextureType;
import com.supermartijn642.fusion.texture.types.random.RandomTextureSprite;
import com.supermartijn642.fusion.texture.types.random.RandomTextureType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_290;
import net.minecraft.class_296;
import net.minecraft.class_5819;
import net.minecraft.class_765;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;

public class ConnectingBakedModel
implements class_1087 {
    private static final int VERTEX_SIZE;
    private static final int VERTEX_UV_OFFSET;
    private static final int VERTEX_POSITION_OFFSET;
    private static final int[][] DEFAULT_TEXTURE_ROTATIONS_UP;
    private static final int[][] DEFAULT_TEXTURE_ROTATIONS_RIGHT;
    private final Mesh blockMesh;
    private final Mesh itemMesh;
    private final List<QuadPredicates> predicates;
    private final List<class_1058> sprites;
    private final boolean hasSpecialQuads;
    private final boolean hasAmbientOcclusion;
    private final boolean isGui3d;
    private final boolean usesBlockLight;
    private final class_1058 particleIcon;
    private final class_809 transforms;
    private final class_806 overrides;

    private static float[] getUV(class_777 quad, int vertexIndex) {
        int offset = vertexIndex * VERTEX_SIZE + VERTEX_UV_OFFSET;
        return new float[]{Float.intBitsToFloat(quad.method_3357()[offset]), Float.intBitsToFloat(quad.method_3357()[offset + 1])};
    }

    private static float[] getPosition(class_777 quad, int vertexIndex) {
        int offset = vertexIndex * VERTEX_SIZE + VERTEX_POSITION_OFFSET;
        return new float[]{Float.intBitsToFloat(quad.method_3357()[offset]), Float.intBitsToFloat(quad.method_3357()[offset + 1]), Float.intBitsToFloat(quad.method_3357()[offset + 2])};
    }

    public ConnectingBakedModel(List<ConnectingModelQuad> quads, boolean hasAmbientOcclusion, boolean isGui3d, boolean usesBlockLight, class_1058 particleIcon, class_809 transforms, class_806 overrides) {
        int auxiliaryQuadCount;
        this.hasAmbientOcclusion = hasAmbientOcclusion;
        this.isGui3d = isGui3d;
        this.usesBlockLight = usesBlockLight;
        this.particleIcon = particleIcon;
        this.transforms = transforms;
        this.overrides = overrides;
        MeshBuilder builder = RendererAccess.INSTANCE.getRenderer().meshBuilder();
        QuadEmitter emitter = builder.getEmitter();
        HashMap<QuadPredicates, Integer> predicates = new HashMap<QuadPredicates, Integer>();
        HashMap<class_1058, Integer> sprites = new HashMap<class_1058, Integer>();
        boolean hasSpecialQuads = false;
        for (ConnectingModelQuad quad : quads) {
            Integer tag = null;
            auxiliaryQuadCount = 0;
            if (quad.hasConnectingTexture()) {
                class_2350 direction = quad.bakedQuad().method_3358();
                TextureOrientation orientation = ConnectingBakedModel.findOrientation(quad.bakedQuad());
                ConnectionPredicate predicate = quad.connectionPredicate();
                auxiliaryQuadCount = ConnectingTextureLayoutHandler.get(quad.getLayout()).getAuxiliaryQuadCount();
                int predicateIndex = predicates.computeIfAbsent(new QuadPredicates(direction, orientation, predicate), o -> predicates.size());
                int spriteIndex = sprites.computeIfAbsent(quad.bakedQuad().method_35788(), o -> sprites.size());
                tag = 1 | spriteIndex << 4 | predicateIndex << 12;
            }
            if (quad.textureType() == DefaultTextureTypes.RANDOM || quad.textureType() == DefaultTextureTypes.CONTINUOUS) {
                int type = quad.textureType() == DefaultTextureTypes.RANDOM ? 2 : 3;
                int spriteIndex = sprites.computeIfAbsent(quad.bakedQuad().method_35788(), o -> sprites.size());
                tag = type | spriteIndex << 4;
                hasSpecialQuads = true;
            }
            RenderMaterial material = FusionClient.getRenderTypeMaterial(hasAmbientOcclusion, quad.renderType(), quad.emissive());
            for (int quadIndex = 0; quadIndex < auxiliaryQuadCount + 1; ++quadIndex) {
                emitter.fromVanilla(quad.bakedQuad(), material, quad.cullDirection());
                if (quad.lightEmission() != null) {
                    for (int i = 0; i < 4; ++i) {
                        int sky = Math.max(quad.lightEmission(), class_765.method_24187((int)emitter.lightmap(i)));
                        int block = Math.max(quad.lightEmission(), class_765.method_24186((int)emitter.lightmap(i)));
                        emitter.lightmap(i, class_765.method_23687((int)sky, (int)block));
                    }
                }
                if (tag != null && quadIndex > 0) {
                    emitter.tag(tag | quadIndex << 20);
                } else if (tag != null) {
                    emitter.tag(tag.intValue());
                }
                emitter.emit();
            }
        }
        this.blockMesh = builder.build();
        this.predicates = predicates.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).toList();
        this.sprites = sprites.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).toList();
        this.hasSpecialQuads = hasSpecialQuads;
        emitter = builder.getEmitter();
        OrientedMutableQuad mutableQuad = new OrientedMutableQuad();
        for (ConnectingModelQuad quad : quads) {
            auxiliaryQuadCount = 0;
            ConnectingTextureLayoutHandler layoutHandler = null;
            if (quad.hasConnectingTexture()) {
                layoutHandler = ConnectingTextureLayoutHandler.get(quad.getLayout());
                auxiliaryQuadCount = ConnectingTextureLayoutHandler.get(quad.getLayout()).getAuxiliaryQuadCount();
            }
            RenderMaterial material = FusionClient.getRenderTypeMaterial(null, null, quad.emissive());
            for (int quadIndex = 0; quadIndex < auxiliaryQuadCount + 1; ++quadIndex) {
                emitter.fromVanilla(quad.bakedQuad(), material, quad.cullDirection());
                if (quad.lightEmission() != null) {
                    for (int i = 0; i < 4; ++i) {
                        int sky = Math.max(quad.lightEmission(), class_765.method_24187((int)emitter.lightmap(i)));
                        int block = Math.max(quad.lightEmission(), class_765.method_24186((int)emitter.lightmap(i)));
                        emitter.lightmap(i, class_765.method_23687((int)sky, (int)block));
                    }
                }
                if (layoutHandler != null) {
                    mutableQuad.set((MutableQuadView)emitter);
                    mutableQuad.set(TextureOrientation.NORMAL_0.vertexIndexPermutation);
                    boolean keepQuad = layoutHandler.processItemQuad(quadIndex, mutableQuad, (ConnectingTextureSprite)quad.bakedQuad().method_35788());
                    if (!keepQuad) continue;
                }
                emitter.emit();
            }
        }
        this.itemMesh = builder.build();
    }

    private static TextureOrientation findOrientation(class_777 quad) {
        double angle1to3;
        float[][] uvs = new float[][]{ConnectingBakedModel.getUV(quad, 0), ConnectingBakedModel.getUV(quad, 1), ConnectingBakedModel.getUV(quad, 2), ConnectingBakedModel.getUV(quad, 3)};
        double angle1to2 = Math.atan2(uvs[1][1] - uvs[0][1], uvs[1][0] - uvs[0][0]);
        boolean textureFlipped = (angle1to2 - (angle1to3 = Math.atan2(uvs[2][1] - uvs[0][1], uvs[2][0] - uvs[0][0])) + Math.PI * 4) % (Math.PI * 2) < Math.PI;
        int topLeftMostIndex = 0;
        for (int i = 1; i < 4; ++i) {
            float[] current = uvs[i];
            float[] best = uvs[topLeftMostIndex];
            if (!(current[0] + current[1] < best[0] + best[1])) continue;
            topLeftMostIndex = i;
        }
        int textureRotation = textureFlipped ? topLeftMostIndex : (4 - topLeftMostIndex) % 4;
        float[][] positions3d = new float[][]{ConnectingBakedModel.getPosition(quad, 0), ConnectingBakedModel.getPosition(quad, 1), ConnectingBakedModel.getPosition(quad, 2), ConnectingBakedModel.getPosition(quad, 3)};
        float[][] pos = new float[4][2];
        class_2350 direction = quad.method_3358();
        for (int i = 0; i < 4; ++i) {
            if (direction == class_2350.field_11033) {
                pos[i][0] = positions3d[i][0];
                pos[i][1] = -positions3d[i][2];
                continue;
            }
            if (direction == class_2350.field_11036) {
                pos[i][0] = positions3d[i][0];
                pos[i][1] = positions3d[i][2];
                continue;
            }
            if (direction == class_2350.field_11043) {
                pos[i][0] = -positions3d[i][0];
                pos[i][1] = -positions3d[i][1];
                continue;
            }
            if (direction == class_2350.field_11035) {
                pos[i][0] = positions3d[i][0];
                pos[i][1] = -positions3d[i][1];
                continue;
            }
            if (direction == class_2350.field_11039) {
                pos[i][0] = positions3d[i][2];
                pos[i][1] = -positions3d[i][1];
                continue;
            }
            if (direction != class_2350.field_11034) continue;
            pos[i][0] = -positions3d[i][2];
            pos[i][1] = -positions3d[i][1];
        }
        angle1to2 = Math.atan2(pos[1][1] - pos[0][1], pos[1][0] - pos[0][0]);
        boolean quadFlipped = (angle1to2 - (angle1to3 = Math.atan2(pos[2][1] - pos[0][1], pos[2][0] - pos[0][0])) + Math.PI * 4) % (Math.PI * 2) < Math.PI;
        topLeftMostIndex = 0;
        for (int i = 1; i < 4; ++i) {
            float[] current = pos[i];
            float[] best = pos[topLeftMostIndex];
            if (!(current[0] + current[1] < best[0] + best[1])) continue;
            topLeftMostIndex = i;
        }
        int quadRotation = textureFlipped ? topLeftMostIndex : 4 - topLeftMostIndex;
        boolean flipped = textureFlipped ^ quadFlipped;
        int rotation = quadFlipped ? (4 - textureRotation + quadRotation) % 4 : (textureRotation + quadRotation) % 4;
        return TextureOrientation.of(flipped, rotation);
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 direction, class_5819 random) {
        return List.of();
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        boolean processConnectingTextures;
        boolean bl = processConnectingTextures = blockView != null && pos != null && !this.predicates.isEmpty();
        if (!processConnectingTextures && !this.hasSpecialQuads) {
            this.blockMesh.outputTo(context.getEmitter());
            return;
        }
        boolean[] culledFaces = new boolean[]{context.isFaceCulled(class_2350.field_11033), context.isFaceCulled(class_2350.field_11036), context.isFaceCulled(class_2350.field_11043), context.isFaceCulled(class_2350.field_11035), context.isFaceCulled(class_2350.field_11039), context.isFaceCulled(class_2350.field_11034)};
        OrientedMutableQuad mutableQuad = new OrientedMutableQuad();
        if (this.hasSpecialQuads) {
            context.pushTransform(quad -> {
                if (quad.tag() != 0) {
                    class_2350 cullFace = quad.cullFace();
                    if (cullFace != null && culledFaces[cullFace.ordinal()]) {
                        return false;
                    }
                    int tag = quad.tag();
                    int type = quad.tag() & 0xF;
                    int spriteIndex = tag >> 4 & 0xFF;
                    class_1058 sprite = this.sprites.get(spriteIndex);
                    quad.tag((int)Math.floor((sprite.field_5269 + sprite.field_5270) / 2.0f * 65535.0f) | (int)Math.floor((sprite.field_5267 + sprite.field_5268) / 2.0f * 65535.0f) << 16);
                    if (type == 2) {
                        mutableQuad.set(quad);
                        mutableQuad.resetPermutation();
                        RandomTextureType.processQuad(mutableQuad, pos, quad.nominalFace(), randomSupplier, (RandomTextureSprite)sprite);
                        return true;
                    }
                    if (type == 3) {
                        mutableQuad.set(quad);
                        mutableQuad.resetPermutation();
                        ContinuousTextureType.processQuad(mutableQuad, pos, quad.nominalFace(), (ContinuousTextureSprite)sprite);
                        return true;
                    }
                }
                return true;
            });
        }
        if (processConnectingTextures) {
            TextureConnections[] connectionsCache = new TextureConnections[this.predicates.size()];
            SurroundingBlockCache blockCache = new SurroundingBlockCache(blockView, pos, state);
            context.pushTransform(quad -> {
                if (quad.tag() != 0) {
                    class_2350 cullFace = quad.cullFace();
                    if (cullFace != null && culledFaces[cullFace.ordinal()]) {
                        return false;
                    }
                    int tag = quad.tag();
                    int type = tag & 0xF;
                    int spriteIndex = tag >> 4 & 0xFF;
                    int predicateIndex = tag >> 12 & 0xFF;
                    int quadIndex = tag >> 20 & 0xF;
                    if (type != 1) {
                        return true;
                    }
                    QuadPredicates predicate = this.predicates.get(predicateIndex);
                    TextureConnections connections = connectionsCache[predicateIndex];
                    if (connections == null) {
                        connections = connectionsCache[predicateIndex] = ConnectingBakedModel.computeConnections(predicate, blockCache);
                    }
                    class_1058 sprite = this.sprites.get(spriteIndex);
                    ConnectingTextureLayout layout = ((ConnectingTextureSprite)sprite).data().getLayout();
                    quad.tag((int)Math.floor((sprite.field_5269 + sprite.field_5270) / 2.0f * 65535.0f) | (int)Math.floor((sprite.field_5267 + sprite.field_5268) / 2.0f * 65535.0f) << 16);
                    mutableQuad.set(quad);
                    mutableQuad.set(predicate.orientation.vertexIndexPermutation);
                    return ConnectingTextureLayoutHandler.get(layout).processBlockQuad(quadIndex, mutableQuad, (ConnectingTextureSprite)sprite, connections);
                }
                return true;
            });
        }
        this.blockMesh.outputTo(context.getEmitter());
        if (this.hasSpecialQuads) {
            context.popTransform();
        }
        if (processConnectingTextures) {
            context.popTransform();
        }
    }

    private static TextureConnections computeConnections(QuadPredicates predicates, SurroundingBlockCache blocks) {
        ConnectionPredicate predicate = predicates.predicate;
        class_2350 face = predicates.direction;
        TextureOrientation orientation = predicates.orientation;
        int[] up = orientation.transformWorldVector(DEFAULT_TEXTURE_ROTATIONS_UP[face.ordinal()], face);
        int[] right = orientation.transformWorldVector(DEFAULT_TEXTURE_ROTATIONS_RIGHT[face.ordinal()], face);
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        boolean connectTop = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[0], up[0], up[1], up[2], mutablePos);
        boolean connectTopRight = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[1], up[0] + right[0], up[1] + right[1], up[2] + right[2], mutablePos);
        boolean connectRight = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[2], right[0], right[1], right[2], mutablePos);
        boolean connectBottomRight = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[3], -up[0] + right[0], -up[1] + right[1], -up[2] + right[2], mutablePos);
        boolean connectBottom = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[4], -up[0], -up[1], -up[2], mutablePos);
        boolean connectBottomLeft = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[5], -up[0] - right[0], -up[1] - right[1], -up[2] - right[2], mutablePos);
        boolean connectLeft = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[6], -right[0], -right[1], -right[2], mutablePos);
        boolean connectTopLeft = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[7], up[0] - right[0], up[1] - right[1], up[2] - right[2], mutablePos);
        return new TextureConnections(connectTop, connectTopRight, connectRight, connectBottomRight, connectBottom, connectBottomLeft, connectLeft, connectTopLeft);
    }

    private static boolean shouldConnect(ConnectionPredicate predicate, SurroundingBlockCache blocks, class_2350 face, ConnectionDirection direction, int neighborX, int neighborY, int neighborZ, class_2338.class_2339 mutablePos) {
        class_1920 level = blocks.getLevel();
        class_2338 position = blocks.getRealPos();
        class_2680 self = blocks.getCenter();
        class_2680 neighborState = blocks.getState(neighborX, neighborY, neighborZ);
        mutablePos.method_10103(position.method_10263() + neighborX, position.method_10264() + neighborY, position.method_10260() + neighborZ);
        class_2680 selfAppearance = self.getAppearance(level, position, face, neighborState, (class_2338)mutablePos);
        class_2680 otherStateAppearance = neighborState.getAppearance(level, (class_2338)mutablePos, face, self, position);
        class_2680 stateInFront = blocks.getState(neighborX + face.method_10148(), neighborY + face.method_10164(), neighborZ + face.method_10165());
        return predicate.shouldConnect((class_1922)level, position, face, selfAppearance, otherStateAppearance, stateInFront, direction);
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        this.itemMesh.outputTo(context.getEmitter());
    }

    public boolean method_4708() {
        return this.hasAmbientOcclusion;
    }

    public boolean method_4712() {
        return this.isGui3d;
    }

    public boolean method_24304() {
        return this.usesBlockLight;
    }

    public boolean method_4713() {
        return false;
    }

    public class_1058 method_4711() {
        return this.particleIcon;
    }

    public class_809 method_4709() {
        return this.transforms;
    }

    public class_806 method_4710() {
        return this.overrides;
    }

    static {
        DEFAULT_TEXTURE_ROTATIONS_UP = new int[6][];
        DEFAULT_TEXTURE_ROTATIONS_RIGHT = new int[6][];
        VERTEX_SIZE = class_290.field_1590.method_1362() / 4;
        VERTEX_UV_OFFSET = class_290.field_1590.method_60835(class_296.field_52110) / 4;
        VERTEX_POSITION_OFFSET = class_290.field_1590.method_60835(class_296.field_52107) / 4;
        for (class_2350 direction : class_2350.values()) {
            int upX = 0;
            int upY = 0;
            int upZ = 0;
            int rightX = 0;
            int rightY = 0;
            int rightZ = 0;
            if (direction == class_2350.field_11033) {
                upZ = 1;
                rightX = 1;
            } else if (direction == class_2350.field_11036) {
                upZ = -1;
                rightX = 1;
            } else if (direction == class_2350.field_11043) {
                upY = 1;
                rightX = -1;
            } else if (direction == class_2350.field_11035) {
                upY = 1;
                rightX = 1;
            } else if (direction == class_2350.field_11039) {
                upY = 1;
                rightZ = 1;
            } else if (direction == class_2350.field_11034) {
                upY = 1;
                rightZ = -1;
            }
            ConnectingBakedModel.DEFAULT_TEXTURE_ROTATIONS_UP[direction.ordinal()] = new int[]{upX, upY, upZ};
            ConnectingBakedModel.DEFAULT_TEXTURE_ROTATIONS_RIGHT[direction.ordinal()] = new int[]{rightX, rightY, rightZ};
        }
    }

    private static enum TextureOrientation {
        NORMAL_0(false, 0),
        NORMAL_90(false, 1),
        NORMAL_180(false, 2),
        NORMAL_270(false, 3),
        FLIPPED_0(true, 0),
        FLIPPED_90(false, 1),
        FLIPPED_180(true, 2),
        FLIPPED_270(true, 3);

        public final boolean flipped;
        public final int rotations;
        public final ConnectionDirection[] worldToTexture;
        public final int[] vertexIndexPermutation;

        public static TextureOrientation of(boolean flipped, int rotations) {
            return TextureOrientation.values()[flipped ? 4 + rotations : rotations];
        }

        private TextureOrientation(boolean flipped, int rotations) {
            this.flipped = flipped;
            this.rotations = rotations;
            this.worldToTexture = ConnectionDirection.values();
            this.vertexIndexPermutation = new int[]{0, 3, 2, 1};
            if (flipped) {
                this.worldToTexture[ConnectionDirection.TOP.ordinal()] = ConnectionDirection.LEFT;
                this.worldToTexture[ConnectionDirection.TOP_RIGHT.ordinal()] = ConnectionDirection.BOTTOM_LEFT;
                this.worldToTexture[ConnectionDirection.RIGHT.ordinal()] = ConnectionDirection.BOTTOM;
                this.worldToTexture[ConnectionDirection.LEFT.ordinal()] = ConnectionDirection.TOP;
                this.worldToTexture[ConnectionDirection.BOTTOM_LEFT.ordinal()] = ConnectionDirection.TOP_RIGHT;
                this.worldToTexture[ConnectionDirection.BOTTOM.ordinal()] = ConnectionDirection.RIGHT;
                this.vertexIndexPermutation[1] = 1;
                this.vertexIndexPermutation[3] = 3;
            }
            if (rotations != 0) {
                ConnectionDirection[] old = Arrays.copyOf(this.worldToTexture, this.worldToTexture.length);
                for (int i = 0; i < 8; ++i) {
                    this.worldToTexture[i] = old[(i - rotations * 2 + 8) % 8];
                }
                int[] old2 = Arrays.copyOf(this.vertexIndexPermutation, this.vertexIndexPermutation.length);
                for (int i = 0; i < 4; ++i) {
                    this.vertexIndexPermutation[i] = old2[(i - rotations + 4) % 4];
                }
            }
        }

        public int[] transformWorldVector(int[] vector, class_2350 face) {
            boolean positive;
            if (!this.flipped && this.rotations == 0) {
                return vector;
            }
            int[] newVector = Arrays.copyOf(vector, vector.length);
            class_2350.class_2351 axis = face.method_10166();
            boolean bl = positive = face.method_10171() == class_2350.class_2352.field_11056;
            if (this.flipped) {
                if (face.method_10166() == class_2350.class_2351.field_11048) {
                    newVector[1] = positive ? vector[2] : -vector[2];
                    int n = newVector[2] = positive ? vector[1] : -vector[1];
                }
                if (face.method_10166() == class_2350.class_2351.field_11052) {
                    newVector[0] = positive ? vector[2] : -vector[2];
                    int n = newVector[2] = positive ? vector[0] : -vector[0];
                }
                if (face.method_10166() == class_2350.class_2351.field_11051) {
                    newVector[0] = positive ? vector[1] : -vector[1];
                    int n = newVector[1] = positive ? vector[0] : -vector[0];
                }
            }
            if (this.rotations > 0) {
                if (this.rotations == 2) {
                    if (axis != class_2350.class_2351.field_11048) {
                        newVector[0] = -newVector[0];
                    }
                    if (axis != class_2350.class_2351.field_11052) {
                        newVector[1] = -newVector[1];
                    }
                    if (axis != class_2350.class_2351.field_11051) {
                        newVector[2] = -newVector[2];
                    }
                } else {
                    int oldX = newVector[0];
                    int oldY = newVector[1];
                    if (axis != class_2350.class_2351.field_11048) {
                        newVector[0] = (positive ^ this.rotations == 3 ? 1 : -1) * (axis == class_2350.class_2351.field_11052 ? -newVector[2] : newVector[1]);
                    }
                    if (axis != class_2350.class_2351.field_11052) {
                        newVector[1] = (positive ^ this.rotations == 3 ? 1 : -1) * (axis == class_2350.class_2351.field_11051 ? -oldX : newVector[2]);
                    }
                    if (axis != class_2350.class_2351.field_11051) {
                        newVector[2] = (positive ^ this.rotations == 3 ? 1 : -1) * (axis == class_2350.class_2351.field_11048 ? -oldY : oldX);
                    }
                }
            }
            return newVector;
        }
    }

    private static class QuadPredicates {
        public final class_2350 direction;
        public final TextureOrientation orientation;
        public final ConnectionPredicate predicate;

        private QuadPredicates(class_2350 direction, TextureOrientation orientation, ConnectionPredicate predicate) {
            this.direction = direction;
            this.orientation = orientation;
            this.predicate = predicate;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof QuadPredicates)) {
                return false;
            }
            QuadPredicates that = (QuadPredicates)o;
            return this.direction == that.direction && this.orientation == that.orientation && this.predicate.equals(that.predicate);
        }

        public int hashCode() {
            int result = this.direction.hashCode();
            result = 31 * result + this.orientation.hashCode();
            result = 31 * result + this.predicate.hashCode();
            return result;
        }
    }
}

