/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.server;

import net.minecraft.server.MinecraftServer;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.ServerUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.midohra.server.PlayerManager;
import net.pitan76.mcpitanlib.midohra.world.ServerWorld;

public class MCServer {
    private final MinecraftServer server;

    protected MCServer(MinecraftServer server) {
        this.server = server;
    }

    public static MCServer of(MinecraftServer server) {
        return new MCServer(server);
    }

    public MinecraftServer getRaw() {
        return this.server;
    }

    public MinecraftServer toMinecraft() {
        return this.getRaw();
    }

    public String getIP() {
        return ServerUtil.getIP(this.server);
    }

    public int getPort() {
        return ServerUtil.getPort(this.server);
    }

    public String getMotd() {
        return ServerUtil.getMotd(this.server);
    }

    public String getServerModName() {
        return ServerUtil.getServerModName(this.server);
    }

    public int getMaxPlayerCount() {
        return ServerUtil.getMaxPlayerCount(this.server);
    }

    public int getCurrentPlayerCount() {
        return ServerUtil.getCurrentPlayerCount(this.server);
    }

    public boolean isOnlineMode() {
        return ServerUtil.isOnlineMode(this.server);
    }

    public boolean isServerRunning() {
        return ServerUtil.isServerRunning(this.server);
    }

    public boolean isServerDedicated() {
        return ServerUtil.isServerDedicated(this.server);
    }

    public boolean isSingleplayer() {
        return ServerUtil.isSingleplayer(this.server);
    }

    public PlayerManager getPlayerManager() {
        return PlayerManager.of(ServerUtil.getPlayerManager(this.server));
    }

    public ServerWorld getWorld(CompatIdentifier id) {
        return ServerWorld.of(WorldUtil.getWorld(this.server, id));
    }

    public ServerWorld getOverworld() {
        return ServerWorld.of(WorldUtil.getOverworld(this.server));
    }

    public ServerWorld getNether() {
        return ServerWorld.of(WorldUtil.getNether(this.server));
    }

    public ServerWorld getEnd() {
        return ServerWorld.of(WorldUtil.getEnd(this.server));
    }
}

