/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.placeable_book;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HSLColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HSVColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.supplementaries.client.renderers.color.ColorHelper;
import net.minecraft.class_2073;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

public record BookType(class_2960 id, HSVColor color, float hueShift, boolean hasGlint, float enchantPower, boolean isHorizontal, float chance, class_2073 predicate) {
    public static Codec<BookType> makeNamedCodec(class_2960 myId) {
        return RecordCodecBuilder.create(instance -> instance.group((App)ColorUtils.CODEC.xmap(c -> new RGBColor(c.intValue()).asHSV(), h -> h.asRGB().toInt()).fieldOf("color").forGetter(BookType::color), (App)Codec.FLOAT.optionalFieldOf("hue_angle").forGetter(b -> Optional.of(Float.valueOf(b.hueShift))), (App)Codec.BOOL.optionalFieldOf("hasGlint", (Object)false).forGetter(BookType::hasGlint), (App)Codec.FLOAT.optionalFieldOf("enchantPower", (Object)Float.valueOf(0.0f)).forGetter(BookType::enchantPower), (App)Codec.BOOL.optionalFieldOf("is_horizontal", (Object)false).forGetter(BookType::isHorizontal), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(BookType::chance), (App)class_2073.field_45754.fieldOf("predicate").forGetter(BookType::predicate)).apply((Applicative)instance, (color, hueAngle, hasGlint, enchPower, isVertical, chance, itemPredicate) -> {
            float hueShift = hueAngle.orElseGet(() -> Float.valueOf(BookType.getAllowedHueShift(color))).floatValue();
            return new BookType(myId, (HSVColor)color, hueShift, (boolean)hasGlint, enchPower.floatValue(), (boolean)isVertical, chance.floatValue(), (class_2073)itemPredicate);
        }));
    }

    private static float getAllowedHueShift(HSVColor color) {
        float v = color.value();
        float minAngle = 0.19444445f;
        float addAngle = 0.18055555f;
        return minAngle + addAngle * (1.0f - v);
    }

    private static float getLegacyAllowedHueShift(HSLColor color) {
        float l = color.lightness();
        float s = ColorHelper.normalizeHSLSaturation(color.saturation(), l);
        float minAngle = 0.25f;
        float addAngle = 0.18055555f;
        float distLightSq = 2.0f;
        float distDarkSq = s * s + l * l;
        float distSq = Math.min(1.0f, Math.min(distDarkSq, distLightSq));
        return minAngle + (1.0f - distSq) * addAngle;
    }

    public boolean looksGoodNextTo(BookType other) {
        float diff = Math.abs(class_3532.method_15381((float)(this.color.hue() * 360.0f), (float)(other.color.hue() * 360.0f)) / 360.0f);
        return diff < (other.hueShift + this.hueShift) / 2.0f;
    }
}

