/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.map_data;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.LABColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1011;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_22;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2397;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_324;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_3620;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6539;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class ColoredMapHandler {
    protected static int DITHERING = 1;
    public static final CustomMapData.Type<Patch, ColorData> COLOR_DATA = MapDataRegistry.registerCustomMapSavedData((class_2960)Supplementaries.res("color_data"), ColorData::new, Patch.STREAM_CODEC);
    private static final Object2IntOpenHashMap<class_2248> BLOCK_IDS_CACHE = new Object2IntOpenHashMap();
    private static final Int2ObjectOpenHashMap<class_2248> IDS_TO_BLOCK_CACHE = new Int2ObjectOpenHashMap();
    private static final Object2IntOpenHashMap<class_6880<class_1959>> BIOME_IDS_CACHE = new Object2IntOpenHashMap();
    private static final Int2ObjectOpenHashMap<class_6880<class_1959>> IDS_TO_BIOME_CACHE = new Int2ObjectOpenHashMap();
    private static final Map<Pair<BlockAndBiome, Integer>, Integer> GLOBAL_COLOR_CACHE = new Object2IntOpenHashMap();
    private static final int[] IND2COLOR_BUFFER = new int[1024];

    public static void init() {
    }

    public static ColorData getColorData(class_22 data) {
        return (ColorData)COLOR_DATA.get(data);
    }

    @Nullable
    public static class_2248 getSimilarColoredBlock(class_2248 block) {
        class_6880.class_6883 blockReference = block.method_40142();
        if (blockReference.method_40220(ModTags.NOT_TINTED_ON_MAPS)) {
            return null;
        }
        if (blockReference.method_40220(ModTags.TINTED_ON_MAPS_GC)) {
            if (block instanceof class_2261) {
                return class_2246.field_10479;
            }
            return class_2246.field_10219;
        }
        if (blockReference.method_40220(ModTags.TINTED_ON_MAPS_FC) || block instanceof class_2397) {
            return class_2246.field_10503;
        }
        if (blockReference.method_40220(ModTags.TINTED_ON_MAPS_WC)) {
            return class_2246.field_10382;
        }
        if (blockReference.method_40220(ModTags.TINTED_ON_MAPS_GENERIC)) {
            return block;
        }
        return null;
    }

    public static void onResourceReload() {
        GLOBAL_COLOR_CACHE.clear();
        System.arraycopy(new int[1024], 0, IND2COLOR_BUFFER, 0, 1024);
    }

    public static void clearIdCache() {
        IDS_TO_BLOCK_CACHE.clear();
        BLOCK_IDS_CACHE.clear();
        IDS_TO_BIOME_CACHE.clear();
        BIOME_IDS_CACHE.clear();
    }

    private static int getBlockId(class_2248 block) {
        return BLOCK_IDS_CACHE.computeIntIfAbsent((Object)block, arg_0 -> ((class_7922)class_7923.field_41175).method_10206(arg_0));
    }

    private static class_2248 getBlockFromId(int id) {
        return (class_2248)IDS_TO_BLOCK_CACHE.computeIfAbsent(id, arg_0 -> ((class_7922)class_7923.field_41175).method_10200(arg_0));
    }

    private static int getBiomeId(class_6880<class_1959> biome, class_5455 registryAccess) {
        return BIOME_IDS_CACHE.computeIntIfAbsent(biome, r -> {
            class_2378 biomeReg = registryAccess.method_30530(class_7924.field_41236);
            return biomeReg.method_10206((Object)((class_1959)r.comp_349()));
        });
    }

    private static class_6880<class_1959> getBiomeFromId(int id, class_5455 registryAccess) {
        return (class_6880)IDS_TO_BIOME_CACHE.computeIfAbsent(id, r -> {
            class_2378 biomeReg = registryAccess.method_30530(class_7924.field_41236);
            return (class_6880)biomeReg.method_40265(r).orElseThrow();
        });
    }

    public static class ColorData
    implements CustomMapData<Counter, Patch>,
    class_1920 {
        public static final int BIOME_SIZE = 4;
        public static final String MIN_X = "min_x";
        public static final String MAX_X = "max_x";
        public static final String MIN_Z = "min_z";
        private byte[][] data = null;
        private final List<class_6880<class_1959>> biomesIndexesPalette = new ArrayList<class_6880<class_1959>>();
        private final List<class_2248> blockIndexesPalette = new ArrayList<class_2248>();
        private BlockAndBiome lastEntryHack;

        @Nullable
        private BlockAndBiome getEntry(int x, int z) {
            if (this.data == null) {
                return null;
            }
            if (x < 0 || x >= 128 || z < 0 || z >= 128) {
                return null;
            }
            if (this.data[x] != null) {
                int paletteIndex = this.paletteIndex(x, z);
                return this.unpackPaletteIndex(paletteIndex);
            }
            return null;
        }

        @Nullable
        private BlockAndBiome unpackPaletteIndex(int packed) {
            if (packed == 0) {
                return null;
            }
            int bi = --packed & 0xF;
            int bli = packed >> 4;
            if (bi >= this.blockIndexesPalette.size() || bli >= this.biomesIndexesPalette.size()) {
                return null;
            }
            return BlockAndBiome.of(this.blockIndexesPalette.get(bi), this.biomesIndexesPalette.get(bli));
        }

        private byte packPaletteIndex(BlockAndBiome entry) {
            int blockIndex = this.blockIndexesPalette.indexOf(entry.block);
            int biomeIndex = this.biomesIndexesPalette.indexOf(entry.biome);
            return (byte)((blockIndex & 0xF | biomeIndex << 4) + 1);
        }

        private int paletteIndex(int x, int z) {
            if (this.data == null || this.data[x] == null) {
                return 0;
            }
            return Byte.toUnsignedInt(this.data[x][z]);
        }

        private void addEntry(class_22 md, int x, int z, BlockAndBiome entry) {
            boolean changedBiome;
            boolean changedBlock;
            class_2248 block = entry.block;
            if (!this.blockIndexesPalette.contains(block)) {
                if (this.blockIndexesPalette.size() >= 16) {
                    return;
                }
                this.blockIndexesPalette.add(block);
                changedBlock = true;
            } else {
                changedBlock = false;
            }
            class_6880<class_1959> biome = entry.biome;
            if (!this.biomesIndexesPalette.contains(biome)) {
                if (this.biomesIndexesPalette.size() >= 16) {
                    return;
                }
                this.biomesIndexesPalette.add(biome);
                changedBiome = true;
            } else {
                changedBiome = false;
            }
            if (this.data == null) {
                this.data = new byte[128][];
            }
            if (this.data[x] == null) {
                this.data[x] = new byte[128];
            }
            this.data[x][z] = this.packPaletteIndex(entry);
            this.setDirty(md, counter -> counter.markDirty(x, z, changedBiome, changedBlock));
        }

        public void load(class_2487 tag, class_7225.class_7874 provider) {
            byte i;
            int j;
            if (tag.method_10545("palette")) {
                class_2487 t = tag.method_10562("palette");
                int minX = 0;
                int maxX = 127;
                int minZ = 0;
                for (int x = minX; x <= maxX; ++x) {
                    byte[] rowData = t.method_10547("pos_" + x);
                    if (this.data == null) {
                        this.data = new byte[128][];
                    }
                    if (this.data[x] == null) {
                        this.data[x] = new byte[128];
                    }
                    System.arraycopy(rowData, 0, this.data[x], minZ, rowData.length);
                }
            }
            if (tag.method_10545("biomes")) {
                this.biomesIndexesPalette.clear();
                class_2499 biomes = tag.method_10554("biomes", 10);
                for (j = 0; j < biomes.size(); ++j) {
                    class_2487 c = biomes.method_10602(j);
                    i = c.method_10571("index");
                    String id = c.method_10558("id");
                    try {
                        class_5321 resourceKey = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60654((String)id));
                        provider.method_46762(class_7924.field_41236).method_46746(resourceKey).ifPresent(b -> this.biomesIndexesPalette.add(i, (class_6880<class_1959>)b));
                        continue;
                    }
                    catch (Exception error) {
                        Supplementaries.error();
                    }
                }
            }
            if (tag.method_10545("blocks")) {
                this.blockIndexesPalette.clear();
                class_2499 blocks = tag.method_10554("blocks", 10);
                for (j = 0; j < blocks.size(); ++j) {
                    class_2487 c = blocks.method_10602(j);
                    i = c.method_10571("index");
                    String id = c.method_10558("id");
                    this.blockIndexesPalette.add(i, (class_2248)class_7923.field_41175.method_10223(class_2960.method_60654((String)id)));
                }
            }
        }

        public void save(class_2487 tag, class_7225.class_7874 registries) {
            if (this.data != null) {
                this.clearUnusedPalette();
                class_2487 t = new class_2487();
                for (int x = 0; x <= 127; ++x) {
                    if (this.data[x] == null) continue;
                    byte[] rowData = new byte[128];
                    System.arraycopy(this.data[x], 0, rowData, 0, rowData.length);
                    t.method_10570("pos_" + x, rowData);
                }
                tag.method_10566("palette", (class_2520)t);
                if (!this.biomesIndexesPalette.isEmpty()) {
                    class_2499 biomesList = new class_2499();
                    for (int i = 0; i < this.biomesIndexesPalette.size(); ++i) {
                        class_2487 biomeTag = new class_2487();
                        biomeTag.method_10567("index", (byte)i);
                        biomeTag.method_10582("id", this.biomesIndexesPalette.get(i).toString());
                        biomesList.add((Object)biomeTag);
                    }
                    tag.method_10566("biomes", (class_2520)biomesList);
                }
                if (!this.blockIndexesPalette.isEmpty()) {
                    class_2499 blocksList = new class_2499();
                    for (int i = 0; i < this.blockIndexesPalette.size(); ++i) {
                        class_2487 blockTag = new class_2487();
                        blockTag.method_10567("index", (byte)i);
                        blockTag.method_10582("id", Utils.getID((class_2248)this.blockIndexesPalette.get(i)).toString());
                        blocksList.add((Object)blockTag);
                    }
                    tag.method_10566("blocks", (class_2520)blocksList);
                }
            }
        }

        private void clearUnusedPalette() {
        }

        public Patch createUpdatePatch(Counter dc) {
            int minX = dc.minDirtyX;
            int maxX = dc.maxDirtyX;
            int minZ = dc.minDirtyZ;
            int maxZ = dc.maxDirtyZ;
            boolean pos = dc.posDirty;
            boolean block = dc.blockDirty;
            boolean biome = dc.biomesDirty;
            Int2ObjectArrayMap positions = null;
            if (pos && this.data != null && (minX != maxX || minZ != maxZ)) {
                positions = new Int2ObjectArrayMap();
                for (int x = minX; x <= maxX; ++x) {
                    if (this.data[x] == null) continue;
                    byte[] rowData = new byte[maxZ - minZ + 1];
                    System.arraycopy(this.data[x], minZ, rowData, 0, rowData.length);
                    positions.put(x, (Object)rowData);
                }
            }
            return new Patch(minX, maxX, minZ, Optional.ofNullable(positions), biome ? Optional.of(this.biomesIndexesPalette) : Optional.empty(), block ? Optional.of(this.blockIndexesPalette) : Optional.empty());
        }

        public void applyUpdatePatch(Patch patch) {
            if (patch.positions.isPresent()) {
                Int2ObjectArrayMap<byte[]> positions = patch.positions.get();
                int minX = patch.minX;
                int maxX = patch.maxX;
                int minZ = patch.minZ;
                for (int x = minX; x <= maxX; ++x) {
                    byte[] rowData;
                    if (this.data == null) {
                        this.data = new byte[128][];
                    }
                    if (this.data[x] == null) {
                        this.data[x] = new byte[128];
                    }
                    if ((rowData = (byte[])positions.get(x)) != null) {
                        System.arraycopy(rowData, 0, this.data[x], minZ, rowData.length);
                        continue;
                    }
                    Supplementaries.error();
                    Supplementaries.LOGGER.error("Null row data in color data");
                }
            }
            if (patch.biomes.isPresent()) {
                this.biomesIndexesPalette.clear();
                this.biomesIndexesPalette.addAll((Collection<class_6880<class_1959>>)patch.biomes.get());
            }
            if (patch.blocks.isPresent()) {
                this.blockIndexesPalette.clear();
                this.blockIndexesPalette.addAll((Collection<class_2248>)patch.blocks.get());
            }
        }

        public boolean persistOnCopyOrLock() {
            return false;
        }

        public CustomMapData.Type<Patch, ?> getType() {
            return COLOR_DATA;
        }

        public Counter createDirtyCounter() {
            return new Counter();
        }

        public void markColored(int x, int z, class_2248 block, class_1937 level, class_2338 pos, class_22 data) {
            class_2248 simplifiedBlock = ColoredMapHandler.getSimilarColoredBlock(block);
            if (simplifiedBlock != null) {
                boolean odd = x % 2 == 0 ^ z % 2 == 1;
                pos = pos.method_10069(odd ? DITHERING : -DITHERING, 0, odd ? DITHERING : -DITHERING);
                class_6880 biome = level.method_23753(pos);
                BlockAndBiome pair = BlockAndBiome.of(simplifiedBlock, (class_6880<class_1959>)biome);
                if (!Objects.equals(this.getEntry(x, z), pair)) {
                    this.addEntry(data, x, z, pair);
                }
            } else if (this.data != null && this.data[x] != null && this.data[x][z] != 0) {
                this.data[x][z] = 0;
                this.setDirty(data, counter -> counter.markDirty(x, z, false, false));
                for (byte b : this.data[x]) {
                    if (b == 0) continue;
                    return;
                }
                this.data[x] = null;
            }
        }

        @Nullable
        public class_2586 method_8321(class_2338 pos) {
            return null;
        }

        public class_2680 method_8320(class_2338 pos) {
            BlockAndBiome entry = this.getEntry(pos.method_10263(), pos.method_10260());
            return entry == null ? class_2246.field_10124.method_9564() : entry.block.method_9564();
        }

        public class_3610 method_8316(class_2338 pos) {
            return this.method_8320(pos).method_26227();
        }

        public int method_31605() {
            return 0;
        }

        public int method_31607() {
            return 0;
        }

        @Environment(value=EnvType.CLIENT)
        public void processTexture(class_1011 texture, int startX, int startY, byte[] colors) {
            if (!ClientConfigs.Tweaks.COLORED_MAPS.get().booleanValue() || this.data == null) {
                return;
            }
            boolean tallGrass = ClientConfigs.Tweaks.TALL_GRASS_COLOR_CHANGE.get();
            boolean accurateConfig = ClientConfigs.Tweaks.ACCURATE_COLORED_MAPS.get();
            if (!accurateConfig) {
                Arrays.fill(IND2COLOR_BUFFER, 0);
            }
            class_324 blockColors = class_310.method_1551().method_1505();
            for (int x = 0; x < 128; ++x) {
                for (int z = 0; z < 128; ++z) {
                    int alreadyKnownColor;
                    int index = this.paletteIndex(x, z);
                    if (index == 0) continue;
                    int newTint = -1;
                    int k = x + z * 128;
                    byte packedId = colors[k];
                    int brightnessInd = packedId & 3;
                    if (!accurateConfig && (alreadyKnownColor = IND2COLOR_BUFFER[index + brightnessInd * 256]) != 0) {
                        newTint = alreadyKnownColor;
                    }
                    if (newTint == -1) {
                        BlockAndBiome e;
                        this.lastEntryHack = e = this.getEntry(x, z);
                        if (e == null) continue;
                        class_2248 block = e.block;
                        if (accurateConfig) {
                            class_2338 pos = new class_2338(x, 64, z);
                            int tint = blockColors.method_1697(block.method_9564(), (class_1920)this, pos, 0);
                            if (tint != -1) {
                                newTint = ColorData.postProcessTint(tallGrass, packedId, block, tint);
                            }
                        } else {
                            ColoredMapHandler.IND2COLOR_BUFFER[index + brightnessInd * 256] = newTint = GLOBAL_COLOR_CACHE.computeIfAbsent((Pair<BlockAndBiome, Integer>)Pair.of((Object)e, (Object)brightnessInd), n -> {
                                class_2338 pos = new class_2338(0, 64, 0);
                                int tint = blockColors.method_1697(block.method_9564(), (class_1920)this, pos, 0);
                                return ColorData.postProcessTint(tallGrass, packedId, block, tint);
                            }).intValue();
                        }
                    }
                    if (newTint == -1) continue;
                    texture.method_4305(startX + x, startY + z, newTint);
                }
            }
        }

        private static int postProcessTint(boolean tg, byte packedId, class_2248 block, int tint) {
            float lumIncrease = 1.3f;
            class_3620 mapColor = class_3620.method_38479((int)((packedId & 0xFF) >> 2));
            if (mapColor == class_3620.field_16019) {
                lumIncrease = 2.0f;
            } else if (mapColor == class_3620.field_16004 && block instanceof class_2261 && tg) {
                packedId = class_3620.field_15999.method_38481(class_3620.class_6594.method_38484((int)(packedId & 3)));
            }
            int color = class_3620.method_38480((int)packedId);
            tint = ColorUtils.swapFormat((int)tint);
            RGBColor tintColor = new RGBColor(tint);
            LABColor c = new RGBColor(color).asLAB();
            RGBColor gray = c.multiply(lumIncrease, 0.0f, 0.0f, 1.0f).asRGB();
            return gray.multiply(tintColor.red(), tintColor.green(), tintColor.blue(), 1.0f).asHSL().multiply(1.0f, 1.3f, 1.0f, 1.0f).asRGB().toInt();
        }

        public float method_24852(class_2350 direction, boolean shade) {
            return 0.0f;
        }

        public class_3568 method_22336() {
            return ClientRegistry.getLightEngine();
        }

        public int method_23752(class_2338 pos, class_6539 colorResolver) {
            if (this.lastEntryHack != null) {
                if (pos == null || colorResolver == null) {
                    throw new IllegalStateException("Block position of Color resolvers were null. How? " + String.valueOf(pos) + String.valueOf(colorResolver));
                }
                int x = pos.method_10263();
                int z = pos.method_10260();
                class_1959 b = (class_1959)this.lastEntryHack.biome.comp_349();
                boolean odd = x % 2 == 0 ^ z % 2 == 1;
                pos = pos.method_10069(odd ? DITHERING : -DITHERING, 0, odd ? DITHERING : -DITHERING);
                return colorResolver.getColor(b, (double)pos.method_10263() + 0.5, (double)pos.method_10260() + 0.5);
            }
            return 0;
        }

        public void clear() {
            this.data = null;
            this.biomesIndexesPalette.clear();
            this.blockIndexesPalette.clear();
        }
    }

    public record Patch(int minX, int maxX, int minZ, Optional<Int2ObjectArrayMap<byte[]>> positions, Optional<List<class_6880<class_1959>>> biomes, Optional<List<class_2248>> blocks) {
        public static final class_9139<class_9129, Patch> STREAM_CODEC = new class_9139<class_9129, Patch>(){

            public Patch decode(class_9129 buf) {
                int minX = 0;
                int maxX = 0;
                int minZ = 0;
                boolean hasPositions = buf.readBoolean();
                Int2ObjectArrayMap positions = null;
                if (hasPositions) {
                    minX = buf.readInt();
                    maxX = buf.readInt();
                    minZ = buf.readInt();
                    int size = buf.method_10816();
                    positions = new Int2ObjectArrayMap(size);
                    for (int i = 0; i < size; ++i) {
                        int x = buf.method_10816();
                        byte[] rowData = buf.method_10795();
                        if (rowData == null) {
                            Supplementaries.error();
                            boolean bl = true;
                            continue;
                        }
                        positions.put(x, (Object)rowData);
                    }
                }
                boolean hasBiomes = buf.readBoolean();
                ArrayList<class_6880<class_1959>> biomes = null;
                if (hasBiomes) {
                    int size = buf.method_10816();
                    biomes = new ArrayList<class_6880<class_1959>>(size);
                    for (int i = 0; i < size; ++i) {
                        int id = buf.method_10816();
                        biomes.add(ColoredMapHandler.getBiomeFromId(id, buf.method_56349()));
                    }
                }
                boolean hasBlocks = buf.readBoolean();
                ArrayList<class_2248> blocks = null;
                if (hasBlocks) {
                    int size = buf.method_10816();
                    blocks = new ArrayList<class_2248>(size);
                    for (int i = 0; i < size; ++i) {
                        int id = buf.method_10816();
                        blocks.add(ColoredMapHandler.getBlockFromId(id));
                    }
                }
                return new Patch(minX, maxX, minZ, Optional.ofNullable(positions), Optional.ofNullable(biomes), Optional.ofNullable(blocks));
            }

            public void encode(class_9129 buf, Patch patch) {
                if (patch.positions.isPresent()) {
                    buf.method_52964(true);
                    buf.method_53002(patch.minX);
                    buf.method_53002(patch.maxX);
                    buf.method_53002(patch.minZ);
                    Int2ObjectArrayMap<byte[]> positions = patch.positions.get();
                    buf.method_10804(positions.size());
                    for (Int2ObjectMap.Entry entry : positions.int2ObjectEntrySet()) {
                        buf.method_10804(entry.getIntKey());
                        byte[] rowData = (byte[])entry.getValue();
                        buf.method_10813(rowData);
                    }
                } else {
                    buf.method_52964(false);
                }
                if (patch.biomes.isPresent()) {
                    buf.method_52964(true);
                    List<class_6880<class_1959>> biomes = patch.biomes.get();
                    buf.method_10804(biomes.size());
                    for (class_6880<class_1959> biome : biomes) {
                        int id = ColoredMapHandler.getBiomeId(biome, buf.method_56349());
                        buf.method_10804(id);
                    }
                } else {
                    buf.method_52964(false);
                }
                if (patch.blocks.isPresent()) {
                    buf.method_52964(true);
                    List<class_2248> blocks = patch.blocks.get();
                    buf.method_10804(blocks.size());
                    for (class_2248 block : blocks) {
                        int id = ColoredMapHandler.getBlockId(block);
                        buf.method_10804(id);
                    }
                } else {
                    buf.method_52964(false);
                }
            }
        };
    }

    public record BlockAndBiome(class_2248 block, class_6880<class_1959> biome) {
        public static BlockAndBiome of(class_2248 block, class_6880<class_1959> biome) {
            return new BlockAndBiome(block, biome);
        }
    }

    public static class Counter
    implements CustomMapData.DirtyCounter {
        private int minDirtyX = 0;
        private int maxDirtyX = 127;
        private int minDirtyZ = 0;
        private int maxDirtyZ = 127;
        private boolean posDirty = true;
        private boolean blockDirty = true;
        private boolean biomesDirty = true;

        public void markDirty(int x, int z, boolean changedBiome, boolean changedBlock) {
            if (changedBiome) {
                this.biomesDirty = true;
            }
            if (changedBlock) {
                this.blockDirty = true;
            }
            if (this.posDirty) {
                this.minDirtyX = Math.min(this.minDirtyX, x);
                this.minDirtyZ = Math.min(this.minDirtyZ, z);
                this.maxDirtyX = Math.max(this.maxDirtyX, x);
                this.maxDirtyZ = Math.max(this.maxDirtyZ, z);
            } else {
                this.posDirty = true;
                this.minDirtyX = x;
                this.minDirtyZ = z;
                this.maxDirtyX = x;
                this.maxDirtyZ = z;
            }
        }

        public boolean isDirty() {
            return this.posDirty || this.biomesDirty || this.blockDirty;
        }

        public void clearDirty() {
            this.biomesDirty = false;
            this.blockDirty = false;
            this.posDirty = false;
            this.minDirtyX = 0;
            this.minDirtyZ = 0;
            this.maxDirtyX = 0;
            this.maxDirtyZ = 0;
        }
    }
}

