/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.loot.modifier;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.loot.modifier.ILootModifier;
import com.blamejared.crafttweaker.api.util.random.Percentaged;
import com.blamejared.crafttweaker.natives.loot.ExpandLootContext;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_5819;
import net.minecraft.class_7924;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.loot.modifier.CommonLootModifiers")
@Document(value="vanilla/api/loot/modifier/CommonLootModifiers")
public final class CommonLootModifiers {
    private static final ILootModifier LOOT_CLEARING_MODIFIER = (loot, context) -> new ArrayList();

    @ZenCodeType.Method
    public static ILootModifier add(IItemStack stack) {
        if (stack.isEmpty()) {
            return ILootModifier.DEFAULT;
        }
        return (loot, context) -> {
            loot.add(stack.copy());
            return loot;
        };
    }

    @ZenCodeType.Method
    public static ILootModifier addAll(IItemStack ... stacks) {
        return CommonLootModifiers.chaining(Arrays.stream(stacks).map(CommonLootModifiers::add));
    }

    @ZenCodeType.Method
    public static ILootModifier addWithChance(Percentaged<IItemStack> stack) {
        if (CommonLootModifiers.isInvalidChance(stack)) {
            return ILootModifier.DEFAULT;
        }
        return (loot, context) -> {
            IItemStack picked = CommonLootModifiers.pickStackBasedOnChance(context.method_294(), stack);
            if (picked != null) {
                loot.add(picked);
            }
            return loot;
        };
    }

    @SafeVarargs
    @ZenCodeType.Method
    public static ILootModifier addAllWithChance(Percentaged<IItemStack> ... stacks) {
        return CommonLootModifiers.chaining(Arrays.stream(stacks).map(CommonLootModifiers::addWithChance));
    }

    @ZenCodeType.Method
    public static ILootModifier addWithOreDropsBonus(class_1887 enchantment, IItemStack stack) {
        if (stack.isEmpty()) {
            return ILootModifier.DEFAULT;
        }
        return (loot, context) -> {
            IItemStack tool = ExpandLootContext.getTool(context);
            if (tool == null || tool.getInternal() == null || tool.isEmpty()) {
                loot.add(stack.copy());
            } else {
                int enchantmentLevel = class_1890.method_8225(Services.REGISTRY.holderOrThrow(class_7924.field_41265, enchantment), (class_1799)tool.getInternal());
                int oldAmount = stack.amount();
                int newAmount = enchantmentLevel <= 0 ? oldAmount : oldAmount * Math.max(0, context.method_294().method_43048(enchantmentLevel + 2) - 1) + 1;
                loot.add(stack.copy().withAmount(newAmount));
            }
            return loot;
        };
    }

    @ZenCodeType.Method
    public static ILootModifier addWithBinomialBonus(class_1887 enchantment, int extra, float p, IItemStack stack) {
        if (stack.isEmpty()) {
            return ILootModifier.DEFAULT;
        }
        return (loot, context) -> {
            IItemStack tool = ExpandLootContext.getTool(context);
            if (tool == null || tool.getInternal() == null || tool.isEmpty()) {
                loot.add(stack.copy());
            } else {
                int enchantmentLevel = class_1890.method_8225(Services.REGISTRY.holderOrThrow(class_7924.field_41265, enchantment), (class_1799)tool.getInternal());
                if (enchantmentLevel <= 0) {
                    loot.add(stack.copy());
                } else {
                    class_5819 source = context.method_294();
                    int oldAmount = stack.amount();
                    int additional = 0;
                    int s = enchantmentLevel + extra;
                    for (int i = 0; i < s; ++i) {
                        if (!(source.method_43057() < p)) continue;
                        ++additional;
                    }
                    int newAmount = oldAmount + additional;
                    loot.add(stack.copy().withAmount(newAmount));
                }
            }
            return loot;
        };
    }

    @ZenCodeType.Method
    public static ILootModifier addWithUniformBonus(class_1887 enchantment, int multiplier, IItemStack stack) {
        if (stack.isEmpty()) {
            return ILootModifier.DEFAULT;
        }
        return (loot, context) -> {
            IItemStack tool = ExpandLootContext.getTool(context);
            if (tool == null || tool.getInternal() == null || tool.isEmpty()) {
                loot.add(stack.copy());
            } else {
                int enchantmentLevel = class_1890.method_8225(Services.REGISTRY.holderOrThrow(class_7924.field_41265, enchantment), (class_1799)tool.getInternal());
                if (enchantmentLevel <= 0) {
                    loot.add(stack.copy());
                } else {
                    int oldAmount = stack.amount();
                    int newAmount = oldAmount + context.method_294().method_43048(multiplier * enchantmentLevel + 1);
                    loot.add(stack.copy().withAmount(newAmount));
                }
            }
            return loot;
        };
    }

    @ZenCodeType.Method
    public static ILootModifier addAllWithOreDropsBonus(class_1887 enchantment, IItemStack ... stacks) {
        return CommonLootModifiers.chaining(Arrays.stream(stacks).map(it -> CommonLootModifiers.addWithOreDropsBonus(enchantment, it)));
    }

    @ZenCodeType.Method
    public static ILootModifier addAllWithBinomialBonus(class_1887 enchantment, int extra, float p, IItemStack ... stacks) {
        return CommonLootModifiers.chaining(Arrays.stream(stacks).map(it -> CommonLootModifiers.addWithBinomialBonus(enchantment, extra, p, it)));
    }

    @ZenCodeType.Method
    public static ILootModifier addAllWithUniformBonus(class_1887 enchantment, int multiplier, IItemStack ... stacks) {
        return CommonLootModifiers.chaining(Arrays.stream(stacks).map(it -> CommonLootModifiers.addWithUniformBonus(enchantment, multiplier, it)));
    }

    @ZenCodeType.Method
    public static ILootModifier addWithRandomAmount(IItemStack stack, int min, int max) {
        if (stack.isEmpty() || max < min) {
            return ILootModifier.DEFAULT;
        }
        return (loot, context) -> {
            int amount = context.method_294().method_43051(min, max);
            loot.add(stack.copy().withAmount(amount));
            return loot;
        };
    }

    @ZenCodeType.Method
    public static ILootModifier replaceWith(IIngredient target, IItemStack replacement) {
        if (target.isEmpty()) {
            return ILootModifier.DEFAULT;
        }
        if (replacement.isEmpty()) {
            return CommonLootModifiers.remove(target);
        }
        return (loot, context) -> {
            boolean hasFound = false;
            ArrayList<IItemStack> newList = null;
            for (IItemStack iItemStack : loot) {
                IItemStack other;
                if (hasFound) {
                    if (target.matches(iItemStack)) {
                        newList.add(replacement.copy());
                        continue;
                    }
                    newList.add(iItemStack);
                    continue;
                }
                if (!target.matches(iItemStack)) continue;
                hasFound = true;
                newList = new ArrayList<IItemStack>();
                Iterator<Object> iterator = loot.iterator();
                while (iterator.hasNext() && (other = (IItemStack)iterator.next()) != iItemStack) {
                    newList.add(other);
                }
                newList.add(replacement.copy());
            }
            return newList == null ? loot : newList;
        };
    }

    @ZenCodeType.Method
    public static ILootModifier replaceAllWith(Map<IIngredient, IItemStack> replacementMap) {
        return CommonLootModifiers.chaining(replacementMap.entrySet().stream().map(it -> CommonLootModifiers.replaceWith((IIngredient)it.getKey(), (IItemStack)it.getValue())));
    }

    @ZenCodeType.Method
    public static ILootModifier replaceStackWith(IIngredientWithAmount target, IItemStack replacement) {
        IIngredient ingredient = target.ingredient();
        int amount = target.amount();
        if (ingredient.isEmpty()) {
            return ILootModifier.DEFAULT;
        }
        if (amount <= 0) {
            return ILootModifier.DEFAULT;
        }
        if (replacement.isEmpty()) {
            return CommonLootModifiers.remove(target.ingredient());
        }
        return (loot, context) -> {
            boolean hasFound = false;
            ArrayList<IItemStack> newList = null;
            for (IItemStack iItemStack : loot) {
                IItemStack other;
                int oldAmount;
                int stackAmount;
                if (hasFound) {
                    if (ingredient.matches(iItemStack) && (stackAmount = iItemStack.amount()) >= amount) {
                        int newAmount22 = stackAmount / amount;
                        oldAmount = stackAmount % amount;
                        newList.add(replacement.copy().withAmount(newAmount22));
                        if (oldAmount <= 0) continue;
                        newList.add(iItemStack.withAmount(oldAmount));
                        continue;
                    }
                    newList.add(iItemStack);
                    continue;
                }
                if (!ingredient.matches(iItemStack) || (stackAmount = iItemStack.amount()) < amount) continue;
                hasFound = true;
                newList = new ArrayList<IItemStack>();
                Iterator<Object> newAmount22 = loot.iterator();
                while (newAmount22.hasNext() && iItemStack != (other = (IItemStack)newAmount22.next())) {
                    newList.add(other);
                }
                int newAmount = stackAmount / amount;
                oldAmount = stackAmount % amount;
                newList.add(replacement.copy().withAmount(newAmount));
                if (oldAmount <= 0) continue;
                newList.add(iItemStack.withAmount(oldAmount));
            }
            return newList == null ? loot : newList;
        };
    }

    @ZenCodeType.Method
    public static ILootModifier replaceAllStacksWith(Map<IIngredientWithAmount, IItemStack> replacementMap) {
        return CommonLootModifiers.chaining(replacementMap.entrySet().stream().map(it -> CommonLootModifiers.replaceStackWith((IIngredientWithAmount)it.getKey(), (IItemStack)it.getValue())));
    }

    @ZenCodeType.Method
    public static ILootModifier remove(IIngredient target) {
        if (target.isEmpty()) {
            return ILootModifier.DEFAULT;
        }
        return (loot, context) -> {
            loot.removeIf(target::matches);
            return loot;
        };
    }

    @ZenCodeType.Method
    public static ILootModifier removeExactly(IIngredientWithAmount target) {
        IIngredient ingredient = target.ingredient();
        int amount = target.amount();
        if (ingredient.isEmpty() || amount <= 0) {
            return ILootModifier.DEFAULT;
        }
        return (loot, context) -> {
            int rollingAmount = amount;
            ListIterator iterator = loot.listIterator();
            while (iterator.hasNext()) {
                IItemStack stack = (IItemStack)iterator.next();
                if (!ingredient.matches(stack)) continue;
                int stackQuantity = stack.amount();
                if ((rollingAmount -= stackQuantity) >= 0) {
                    iterator.remove();
                } else {
                    stack.asMutable().withAmount(-rollingAmount);
                }
                if (rollingAmount > 0) continue;
                break;
            }
            return loot;
        };
    }

    @ZenCodeType.Method
    public static ILootModifier removeAll(IIngredient ... targets) {
        return CommonLootModifiers.chaining(Arrays.stream(targets).map(CommonLootModifiers::remove));
    }

    @ZenCodeType.Method
    public static ILootModifier removeExactlyAll(IIngredientWithAmount ... targets) {
        return CommonLootModifiers.chaining(Arrays.stream(targets).map(CommonLootModifiers::removeExactly));
    }

    @ZenCodeType.Method
    public static ILootModifier clearLoot() {
        return LOOT_CLEARING_MODIFIER;
    }

    @ZenCodeType.Method
    public static ILootModifier chaining(ILootModifier ... modifiers) {
        return CommonLootModifiers.chaining(Arrays.stream(modifiers));
    }

    @ZenCodeType.Method
    public static ILootModifier clearing(ILootModifier ... modifiers) {
        return CommonLootModifiers.chaining(Stream.concat(Stream.of(CommonLootModifiers.clearLoot()), Arrays.stream(modifiers)));
    }

    private static boolean isInvalidChance(Percentaged<IItemStack> stack) {
        return stack.getData().isEmpty() || stack.getPercentage() <= 0.0;
    }

    private static IItemStack pickStackBasedOnChance(class_5819 random, Percentaged<IItemStack> stack) {
        return random.method_43058() <= stack.getPercentage() ? stack.getData().copy() : null;
    }

    private static ILootModifier chaining(Stream<ILootModifier> chain) {
        return chain.reduce(ILootModifier.DEFAULT, (first, second) -> {
            if (first == ILootModifier.DEFAULT) {
                return second;
            }
            if (second == ILootModifier.DEFAULT) {
                return first;
            }
            return (loot, context) -> second.modify(first.modify(loot, context), context);
        });
    }
}

