/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.command.type;

import com.blamejared.crafttweaker.api.bracket.custom.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.api.command.argument.RecipeTypeArgument;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.plugin.ICommandRegistrationHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandlerRegistry;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import com.blamejared.crafttweaker.mixin.common.access.recipe.AccessRecipeManager;
import com.mojang.brigadier.arguments.ArgumentType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import net.minecraft.class_8786;

public final class RecipeCommands {
    private RecipeCommands() {
    }

    public static void registerCommands(ICommandRegistrationHandler handler) {
        handler.registerRootCommand("recipes", class_2561.method_43471((String)"crafttweaker.command.description.recipes"), builder -> builder.executes(context -> RecipeCommands.dumpRecipes((class_2168)context.getSource())));
        handler.registerSubCommand("recipes", "hand", class_2561.method_43471((String)"crafttweaker.command.description.recipes.hand"), builder -> builder.executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = source.method_9207();
            return RecipeCommands.dumpHand(source, player.method_6047());
        }));
        handler.registerSubCommand("recipes", "inventory", class_2561.method_43471((String)"crafttweaker.command.description.recipes.inventory"), builder -> builder.executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = source.method_9207();
            ArrayList<class_1799> stacks = new ArrayList<class_1799>();
            IntStream.range(0, player.method_31548().method_5439()).mapToObj(arg_0 -> ((class_1661)player.method_31548()).method_5438(arg_0)).filter(itemStack -> !itemStack.method_7960()).forEach(itemStack -> {
                if (stacks.stream().noneMatch(stack -> class_1799.method_7984((class_1799)itemStack, (class_1799)stack))) {
                    stacks.add((class_1799)itemStack);
                }
            });
            return RecipeCommands.dump(source, stacks);
        }));
        handler.registerSubCommand("recipes", "manager", class_2561.method_43471((String)"crafttweaker.command.description.recipes.manager"), builder -> builder.then(class_2170.method_9244((String)"type", (ArgumentType)RecipeTypeArgument.get()).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            return RecipeCommands.dumpRecipes(source, (IRecipeManager)context.getArgument("type", IRecipeManager.class));
        })));
    }

    private static int dumpRecipes(class_2168 source) {
        CommandUtilities.COMMAND_LOGGER.info("Dumping all recipes!");
        RecipeCommands.dumpRecipes(source, (class_3956<?> it) -> true);
        CommandUtilities.openLogFile(source, (class_2561)class_2561.method_43469((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(class_2561.method_43471((String)"crafttweaker.command.misc.recipes.list")), CommandUtilities.getFormattedLogFile()}).method_27692(class_124.field_1060));
        return 1;
    }

    private static int dumpRecipes(class_2168 source, IRecipeManager<?> manager) {
        CommandUtilities.COMMAND_LOGGER.info("Dumping recipes for manager " + manager.getCommandString() + "!");
        class_3956<?> type = manager.getRecipeType();
        RecipeCommands.dumpRecipes(source, (class_3956<?> it) -> Objects.equals(it, type));
        CommandUtilities.openLogFile(source, (class_2561)class_2561.method_43469((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(class_2561.method_43471((String)"crafttweaker.command.misc.recipes.list")), CommandUtilities.getFormattedLogFile()}).method_27692(class_124.field_1060));
        return 1;
    }

    private static int dumpHand(class_2168 source, class_1799 stack) {
        return RecipeCommands.dump(source, List.of(stack));
    }

    private static int dump(class_2168 source, List<class_1799> stacks) {
        for (class_1799 stack : stacks) {
            if (stack.method_7960()) {
                CommandUtilities.send(source, (class_2561)class_2561.method_43471((String)"crafttweaker.command.recipes.hand.empty").method_27692(class_124.field_1061));
                return 1;
            }
            IItemStack workingStack = IItemStack.of(stack.method_7972()).withAmount(1);
            CommandUtilities.COMMAND_LOGGER.info("Dumping all recipes that output {}!", (Object)ItemStackUtil.getCommandString(workingStack.getInternal()));
            ((AccessRecipeManager)source.method_9225().method_8433()).crafttweaker$getByType().asMap().forEach((recipeType, recipes) -> RecipeCommands.dumpRecipe(recipeType, recipes, it -> workingStack.matches(IItemStack.of(AccessibleElementsProvider.get().registryAccess(arg_0 -> ((class_1860)it.comp_1933()).method_8110(arg_0)))), true));
        }
        CommandUtilities.openLogFile(source, (class_2561)class_2561.method_43469((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(class_2561.method_43471((String)"crafttweaker.command.misc.recipes.list")), CommandUtilities.getFormattedLogFile()}).method_27692(class_124.field_1060));
        return 1;
    }

    private static void dumpRecipes(class_2168 source, Predicate<class_3956<?>> typeFilter) {
        ((AccessRecipeManager)source.method_9225().method_8433()).crafttweaker$getByType().asMap().entrySet().stream().filter(it -> typeFilter.test((class_3956)it.getKey())).forEach(it -> RecipeCommands.dumpRecipe((class_3956)it.getKey(), (Collection)it.getValue(), recipe -> true, false));
    }

    private static void dumpRecipe(class_3956<?> type, Collection<class_8786<?>> recipes, Predicate<class_8786<?>> filter, boolean hideEmpty) {
        IRecipeManager<class_1860<?>> manager = RecipeTypeBracketHandler.getOrDefault(type);
        if (manager == null) {
            return;
        }
        String dumpResult = recipes.stream().filter(filter).sorted(Comparator.comparing(RecipeCommands::serializer).thenComparing(class_8786::comp_1932)).map(it -> RecipeCommands.dump((IRecipeManager)GenericUtil.uncheck(manager), it)).collect(Collectors.joining("\n  "));
        if (hideEmpty && dumpResult.isEmpty()) {
            return;
        }
        CommandUtilities.COMMAND_LOGGER.info("Recipe type: '{}'\n  {}\n", (Object)manager.getCommandString(), (Object)(dumpResult.isEmpty() ? "No recipe found" : dumpResult));
    }

    private static class_2960 serializer(class_8786<?> recipe) {
        return Objects.requireNonNull(class_7923.field_41189.method_10221((Object)recipe.comp_1933().method_8119()));
    }

    private static <T extends class_1860<?>> String dump(IRecipeManager<? super T> manager, class_8786<T> recipe) {
        return IRecipeHandlerRegistry.getHandlerFor(recipe).dumpToCommandString(manager, AccessibleElementsProvider.get().registryAccess(), recipe);
    }
}

