/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.dataproviders;

import fi.dy.masa.servux.Reference;
import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.dataproviders.DataProviderBase;
import fi.dy.masa.servux.dataproviders.HudDataProvider;
import fi.dy.masa.servux.dataproviders.IDataProvider;
import fi.dy.masa.servux.network.IPluginServerPlayHandler;
import fi.dy.masa.servux.network.ServerPlayHandler;
import fi.dy.masa.servux.network.packet.ServuxStructuresHandler;
import fi.dy.masa.servux.network.packet.ServuxStructuresPacket;
import fi.dy.masa.servux.settings.IServuxSetting;
import fi.dy.masa.servux.settings.ServuxBoolSetting;
import fi.dy.masa.servux.settings.ServuxIntSetting;
import fi.dy.masa.servux.settings.ServuxStringListSetting;
import fi.dy.masa.servux.util.PlayerDimensionPosition;
import fi.dy.masa.servux.util.Timeout;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3449;
import net.minecraft.class_3695;
import net.minecraft.class_6625;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class StructureDataProvider
extends DataProviderBase {
    public static final StructureDataProvider INSTANCE = new StructureDataProvider();
    protected static final ServuxStructuresHandler<ServuxStructuresPacket.Payload> HANDLER = ServuxStructuresHandler.getInstance();
    protected final Map<UUID, PlayerDimensionPosition> registeredPlayers = new HashMap<UUID, PlayerDimensionPosition>();
    protected final Map<UUID, Map<class_1923, Timeout>> timeouts = new HashMap<UUID, Map<class_1923, Timeout>>();
    protected final class_2487 metadata = new class_2487();
    protected int retainDistance;
    private ServuxIntSetting permissionLevel = new ServuxIntSetting((IDataProvider)this, "permission_level", 0, 4, 0);
    private ServuxBoolSetting structureBlacklistEnabled = new ServuxBoolSetting(this, "structures_blacklist_enabled", false);
    private ServuxBoolSetting structureWhitelistEnabled = new ServuxBoolSetting(this, "structures_whitelist_enabled", false);
    private ServuxStringListSetting structureBlacklist = new ServuxStringListSetting(this, "structures_blacklist", List.of("minecraft:buried_treasure"));
    private ServuxStringListSetting structureWhitelist = new ServuxStringListSetting(this, "structures_whitelist", List.of());
    private ServuxIntSetting updateInterval = new ServuxIntSetting((IDataProvider)this, "update_interval", 40, 1200, 1);
    private ServuxIntSetting timeout = new ServuxIntSetting((IDataProvider)this, "timeout", 600, 1200, 40);
    private ServuxBoolSetting shareWeatherStatus = new ServuxBoolSetting(this, "share_weather_status", false);
    private ServuxIntSetting weatherPermissionLevel = new ServuxIntSetting((IDataProvider)this, "weather_permission_level", 0, 4, 0);
    private ServuxBoolSetting shareSeed = new ServuxBoolSetting(this, "share_seed", false);
    private ServuxIntSetting seedPermissionLevel = new ServuxIntSetting((IDataProvider)this, "seed_permission_level", 2, 4, 0);
    private List<IServuxSetting<?>> settings = List.of(this.permissionLevel, this.structureBlacklistEnabled, this.structureWhitelistEnabled, this.structureBlacklist, this.structureWhitelist, this.updateInterval, this.timeout, this.shareWeatherStatus, this.weatherPermissionLevel, this.shareSeed, this.seedPermissionLevel);
    private class_2338 spawnPos = class_2338.field_10980;
    private int spawnChunkRadius = -1;
    private long worldSeed = 0L;
    private int weatherTime = -1;
    private boolean isRaining;
    private boolean isThundering;
    private long lastTick;
    private long lastWeatherTick;
    private boolean refreshSpawnMetadata;
    private boolean refreshWeatherData;

    protected StructureDataProvider() {
        super("structure_bounding_boxes", ServuxStructuresHandler.CHANNEL_ID, 2, 0, "servux.provider.structure_bounding_boxes", "Structure Bounding Boxes data for structures such as Witch Huts, Ocean Monuments, Nether Fortresses etc.");
        this.metadata.method_10582("name", this.getName());
        this.metadata.method_10582("id", this.getNetworkChannel().toString());
        this.metadata.method_10569("version", this.getProtocolVersion());
        this.metadata.method_10582("servux", Reference.MOD_STRING);
        this.metadata.method_10569("timeout", ((Integer)this.timeout.getValue()).intValue());
        this.metadata.method_10569("spawnPosX", this.getSpawnPos().method_10263());
        this.metadata.method_10569("spawnPosY", this.getSpawnPos().method_10264());
        this.metadata.method_10569("spawnPosZ", this.getSpawnPos().method_10260());
        this.metadata.method_10569("spawnChunkRadius", this.getSpawnChunkRadius());
    }

    @Override
    public List<IServuxSetting<?>> getSettings() {
        return this.settings;
    }

    @Override
    public void registerHandler() {
        ServerPlayHandler.getInstance().registerServerPlayHandler(HANDLER);
        if (!this.isRegistered()) {
            HANDLER.registerPlayPayload(ServuxStructuresPacket.Payload.ID, ServuxStructuresPacket.Payload.CODEC, 3);
            this.setRegistered(true);
        }
        HANDLER.registerPlayReceiver(ServuxStructuresPacket.Payload.ID, (ServerPlayNetworking.PlayPayloadHandler<ServuxStructuresPacket.Payload>)((ServerPlayNetworking.PlayPayloadHandler)HANDLER::receivePlayPayload));
    }

    @Override
    public void unregisterHandler() {
        HANDLER.unregisterPlayReceiver();
        ServerPlayHandler.getInstance().unregisterServerPlayHandler(HANDLER);
    }

    public IPluginServerPlayHandler<ServuxStructuresPacket.Payload> getPacketHandler() {
        return HANDLER;
    }

    @Override
    public boolean shouldTick() {
        return this.enabled;
    }

    @Override
    public void tick(MinecraftServer server, int tickCounter, class_3695 profiler) {
        if (tickCounter % (Integer)this.updateInterval.getValue() == 0) {
            profiler.method_15396(this.getName());
            List playerList = server.method_3760().method_14571();
            this.retainDistance = server.method_3760().method_14568() + 2;
            this.lastTick = tickCounter;
            int radius = this.getSpawnChunkRadius();
            int rule = server.method_3767().method_8356(class_1928.field_48374);
            if (radius != rule) {
                this.setSpawnChunkRadius(rule);
            }
            if (this.worldSeed == 0L) {
                this.checkWorldSeed(server);
            } else if (!((Boolean)this.shareSeed.getValue()).booleanValue()) {
                this.setWorldSeed(0L);
            }
            profiler.method_15405(this.getName() + "_players");
            for (class_3222 player : playerList) {
                UUID uuid = player.method_5667();
                if (this.shouldRefreshWeatherData()) {
                    this.refreshWeatherData(player, null);
                }
                if (this.shouldRefreshSpawnMetadata()) {
                    this.refreshSpawnMetadata(player, null);
                }
                if (!this.registeredPlayers.containsKey(uuid)) continue;
                if (!this.hasPermission(player)) {
                    this.unregister(player);
                    continue;
                }
                this.checkForDimensionChange(player);
                this.refreshTrackedChunks(player, tickCounter);
            }
            this.checkForInvalidPlayers(server);
            if (this.shouldRefreshWeatherData()) {
                this.lastWeatherTick = tickCounter;
                this.setRefreshWeatherDataComplete();
            }
            if (this.shouldRefreshSpawnMetadata()) {
                this.setRefreshSpawnMetadataComplete();
            }
            profiler.method_15407();
        }
    }

    @Deprecated(forRemoval=true)
    public void tickWeather(int clearTime, int rainTime, boolean isThunder) {
        if (rainTime > 1) {
            if (isThunder) {
                this.isThundering = true;
                this.isRaining = false;
            } else {
                this.isThundering = false;
                this.isRaining = true;
            }
            this.weatherTime = rainTime;
            if (this.lastTick - this.lastWeatherTick > (long)this.getTickInterval()) {
                this.refreshWeatherData = true;
            }
        } else if (clearTime > 0 && (this.isRaining || this.isThundering)) {
            this.isThundering = false;
            this.isRaining = false;
            this.weatherTime = clearTime;
            this.refreshWeatherData = true;
        } else {
            this.weatherTime = clearTime;
            if (this.lastTick - this.lastWeatherTick > (long)(this.getTickInterval() * 4)) {
                this.refreshWeatherData = true;
            }
        }
    }

    public void checkForInvalidPlayers(MinecraftServer server) {
        if (!this.registeredPlayers.isEmpty()) {
            Iterator<UUID> iter = this.registeredPlayers.keySet().iterator();
            while (iter.hasNext()) {
                UUID uuid = iter.next();
                if (server.method_3760().method_14602(uuid) != null) continue;
                this.timeouts.remove(uuid);
                iter.remove();
            }
        }
    }

    public void onStartedWatchingChunk(class_3222 player, class_2818 chunk) {
        UUID uuid = player.method_5667();
        if (this.registeredPlayers.containsKey(uuid)) {
            this.addChunkTimeoutIfHasReferences(uuid, chunk, player.method_5682().method_3780());
        }
    }

    public boolean register(class_3222 player) {
        boolean registered = false;
        MinecraftServer server = player.method_5682();
        UUID uuid = player.method_5667();
        if (!this.hasPermission(player)) {
            Servux.debugLog("structure_bounding_boxes: Denying access for player {}, Insufficient Permissions", player.method_5477().method_54160());
            return registered;
        }
        if (!this.registeredPlayers.containsKey(uuid)) {
            this.registeredPlayers.put(uuid, new PlayerDimensionPosition((class_1657)player));
            int tickCounter = server.method_3780();
            class_3244 handler = player.field_13987;
            if (handler != null) {
                class_2487 nbt = new class_2487();
                nbt.method_10543(this.metadata);
                if (!this.hasPermissionsForSeed(player) && nbt.method_10545("worldSeed")) {
                    nbt.method_10551("worldSeed");
                }
                Servux.debugLog("structure_bounding_boxes: sending Metadata to player {}", player.method_5477().method_54160());
                HANDLER.sendPlayPayload(handler, new ServuxStructuresPacket.Payload(new ServuxStructuresPacket(ServuxStructuresPacket.Type.PACKET_S2C_METADATA, nbt)));
                this.refreshWeatherData(player, null);
                this.initialSyncStructuresToPlayerWithinRange(player, player.method_5682().method_3760().method_14568() + 2, tickCounter);
            }
            registered = true;
        }
        return registered;
    }

    public boolean unregister(class_3222 player) {
        HANDLER.resetFailures(this.getNetworkChannel(), player);
        return this.registeredPlayers.remove(player.method_5667()) != null;
    }

    protected void initialSyncStructuresToPlayerWithinRange(class_3222 player, int chunkRadius, int tickCounter) {
        UUID uuid = player.method_5667();
        class_1923 center = player.method_14232().method_18692();
        Map<class_3195, LongSet> references = this.getStructureReferencesWithinRange(player.method_51469(), center, chunkRadius);
        this.timeouts.remove(uuid);
        this.registeredPlayers.computeIfAbsent(uuid, u -> new PlayerDimensionPosition((class_1657)player)).setPosition((class_1657)player);
        this.sendStructures(player, references, tickCounter);
    }

    protected void addChunkTimeoutIfHasReferences(UUID uuid, class_2818 chunk, int tickCounter) {
        class_1923 pos = chunk.method_12004();
        if (this.chunkHasStructureReferences(pos.field_9181, pos.field_9180, chunk.method_12200())) {
            Map map = this.timeouts.computeIfAbsent(uuid, u -> new HashMap());
            map.computeIfAbsent(pos, p -> new Timeout(tickCounter - (Integer)this.timeout.getValue()));
        }
    }

    protected void checkForDimensionChange(class_3222 player) {
        UUID uuid = player.method_5667();
        PlayerDimensionPosition playerPos = this.registeredPlayers.get(uuid);
        if (playerPos == null || playerPos.dimensionChanged((class_1657)player)) {
            this.timeouts.remove(uuid);
            this.registeredPlayers.computeIfAbsent(uuid, u -> new PlayerDimensionPosition((class_1657)player)).setPosition((class_1657)player);
        }
    }

    protected void addOrRefreshTimeouts(UUID uuid, Map<class_3195, LongSet> references, int tickCounter) {
        Map map = this.timeouts.computeIfAbsent(uuid, u -> new HashMap());
        for (LongSet chunks : references.values()) {
            for (Long chunkPosLong : chunks) {
                class_1923 pos = new class_1923(chunkPosLong.longValue());
                map.computeIfAbsent(pos, p -> new Timeout(tickCounter)).setLastSync(tickCounter);
            }
        }
    }

    protected void refreshTrackedChunks(class_3222 player, int tickCounter) {
        UUID uuid = player.method_5667();
        Map<class_1923, Timeout> map = this.timeouts.get(uuid);
        if (map != null) {
            this.sendAndRefreshExpiredStructures(player, map, tickCounter);
        }
    }

    protected boolean isOutOfRange(class_1923 pos, class_1923 center) {
        int chunkRadius = this.retainDistance;
        return Math.abs(pos.field_9181 - center.field_9181) > chunkRadius || Math.abs(pos.field_9180 - center.field_9180) > chunkRadius;
    }

    protected void sendAndRefreshExpiredStructures(class_3222 player, Map<class_1923, Timeout> map, int tickCounter) {
        HashSet<class_1923> positionsToUpdate = new HashSet<class_1923>();
        for (Map.Entry<class_1923, Timeout> entry : map.entrySet()) {
            Timeout timeout = entry.getValue();
            if (!timeout.needsUpdate(tickCounter, (Integer)this.timeout.getValue())) continue;
            positionsToUpdate.add(entry.getKey());
        }
        if (!positionsToUpdate.isEmpty()) {
            class_3218 world = player.method_51469();
            class_1923 center = player.method_14232().method_18692();
            HashMap<class_3195, LongSet> references = new HashMap<class_3195, LongSet>();
            for (class_1923 pos : positionsToUpdate) {
                if (this.isOutOfRange(pos, center)) {
                    map.remove(pos);
                    continue;
                }
                this.getStructureReferencesFromChunk(pos.field_9181, pos.field_9180, (class_1937)world, references);
                Timeout timeout = map.get(pos);
                if (timeout == null) continue;
                timeout.setLastSync(tickCounter);
            }
            if (!references.isEmpty()) {
                this.sendStructures(player, references, tickCounter);
            }
        }
    }

    protected void getStructureReferencesFromChunk(int chunkX, int chunkZ, class_1937 world, Map<class_3195, LongSet> references) {
        if (!world.method_8393(chunkX, chunkZ)) {
            return;
        }
        class_2791 chunk = world.method_8402(chunkX, chunkZ, class_2806.field_16423, false);
        if (chunk == null) {
            return;
        }
        for (Map.Entry entry : chunk.method_12179().entrySet()) {
            class_3195 feature = (class_3195)entry.getKey();
            LongSet startChunks = (LongSet)entry.getValue();
            if (startChunks.isEmpty()) continue;
            references.merge(feature, startChunks, (oldSet, entrySet) -> {
                LongOpenHashSet newSet = new LongOpenHashSet((LongCollection)oldSet);
                newSet.addAll((LongCollection)entrySet);
                return newSet;
            });
        }
    }

    protected boolean chunkHasStructureReferences(int chunkX, int chunkZ, class_1937 world) {
        if (!world.method_8393(chunkX, chunkZ)) {
            return false;
        }
        class_2791 chunk = world.method_8402(chunkX, chunkZ, class_2806.field_16423, false);
        if (chunk == null) {
            return false;
        }
        for (Map.Entry entry : chunk.method_12179().entrySet()) {
            if (((LongSet)entry.getValue()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected Map<class_1923, class_3449> getStructureStartsFromReferences(class_3218 world, Map<class_3195, LongSet> references) {
        HashMap<class_1923, class_3449> starts = new HashMap<class_1923, class_3449>();
        for (Map.Entry<class_3195, LongSet> entry : references.entrySet()) {
            class_3195 structure = entry.getKey();
            LongSet startChunks = entry.getValue();
            LongIterator iter = startChunks.iterator();
            while (iter.hasNext()) {
                class_3449 start;
                class_2791 chunk;
                class_1923 pos = new class_1923(iter.nextLong());
                if (!world.method_8393(pos.field_9181, pos.field_9180) || (chunk = world.method_8402(pos.field_9181, pos.field_9180, class_2806.field_16423, false)) == null || (start = chunk.method_12181(structure)) == null) continue;
                starts.put(pos, start);
            }
        }
        return starts;
    }

    protected Map<class_3195, LongSet> getStructureReferencesWithinRange(class_3218 world, class_1923 center, int chunkRadius) {
        HashMap<class_3195, LongSet> references = new HashMap<class_3195, LongSet>();
        for (int cx = center.field_9181 - chunkRadius; cx <= center.field_9181 + chunkRadius; ++cx) {
            for (int cz = center.field_9180 - chunkRadius; cz <= center.field_9180 + chunkRadius; ++cz) {
                this.getStructureReferencesFromChunk(cx, cz, (class_1937)world, references);
            }
        }
        return references;
    }

    protected void sendStructures(class_3222 player, Map<class_3195, LongSet> references, int tickCounter) {
        class_3218 world = player.method_51469();
        Map<class_1923, class_3449> starts = this.getStructureStartsFromReferences(world, references);
        if (!starts.isEmpty()) {
            this.addOrRefreshTimeouts(player.method_5667(), references, tickCounter);
            class_2499 structureList = this.getStructureList(starts, world);
            if (this.registeredPlayers.containsKey(player.method_5667())) {
                class_2487 nbt = new class_2487();
                nbt.method_10566("Structures", (class_2520)structureList.method_10612());
                HANDLER.encodeStructuresPacket(player, new ServuxStructuresPacket(ServuxStructuresPacket.Type.PACKET_S2C_STRUCTURE_DATA_START, nbt));
            }
        }
    }

    protected class_2499 getStructureList(Map<class_1923, class_3449> structures, class_3218 world) {
        class_2499 list = new class_2499();
        class_6625 ctx = class_6625.method_38713((class_3218)world);
        for (Map.Entry<class_1923, class_3449> entry : structures.entrySet()) {
            class_2960 structureType = class_7923.field_41147.method_10221((Object)entry.getValue().method_16656().method_41618());
            if (!this.shouldSendStructure(structureType)) continue;
            class_1923 pos = entry.getKey();
            list.add((Object)entry.getValue().method_14972(ctx, pos));
        }
        return list;
    }

    protected boolean shouldSendStructure(class_2960 identifier) {
        if (((Boolean)this.structureWhitelistEnabled.getValue()).booleanValue()) {
            return ((List)this.structureWhitelist.getValue()).contains(identifier.toString());
        }
        if (((Boolean)this.structureBlacklistEnabled.getValue()).booleanValue()) {
            return !((List)this.structureBlacklist.getValue()).contains(identifier.toString());
        }
        return true;
    }

    @Deprecated(forRemoval=true)
    public void refreshSpawnMetadata(class_3222 player, @Nullable class_2487 data) {
        class_2487 nbt = new class_2487();
        class_2338 spawnPos = HudDataProvider.INSTANCE.getSpawnPos();
        nbt.method_10582("id", this.getNetworkChannel().toString());
        nbt.method_10582("servux", Reference.MOD_STRING);
        nbt.method_10569("spawnPosX", spawnPos.method_10263());
        nbt.method_10569("spawnPosY", spawnPos.method_10264());
        nbt.method_10569("spawnPosZ", spawnPos.method_10260());
        nbt.method_10569("spawnChunkRadius", HudDataProvider.INSTANCE.getSpawnChunkRadius());
        if (((Boolean)this.shareSeed.getValue()).booleanValue() && this.hasPermissionsForSeed(player)) {
            nbt.method_10544("worldSeed", HudDataProvider.INSTANCE.getWorldSeed());
        }
        HANDLER.encodeStructuresPacket(player, new ServuxStructuresPacket(ServuxStructuresPacket.Type.PACKET_S2C_SPAWN_METADATA, nbt));
    }

    @Deprecated(forRemoval=true)
    public void refreshWeatherData(class_3222 player, @Nullable class_2487 data) {
        class_2487 nbt = new class_2487();
        if (!this.hasPermissionsForWeather(player)) {
            return;
        }
        nbt.method_10543(HudDataProvider.INSTANCE.cloneWeatherData());
        nbt.method_10582("id", this.getNetworkChannel().toString());
        nbt.method_10582("servux", Reference.MOD_STRING);
        HANDLER.encodeStructuresPacket(player, new ServuxStructuresPacket(ServuxStructuresPacket.Type.PACKET_S2C_WEATHER_DATA, nbt));
    }

    @Deprecated(forRemoval=true)
    public class_2338 getSpawnPos() {
        if (this.spawnPos == null) {
            this.setSpawnPos(class_2338.field_10980);
        }
        return HudDataProvider.INSTANCE.getSpawnPos();
    }

    @Deprecated(forRemoval=true)
    public void setSpawnPos(class_2338 spawnPos) {
        if (!this.spawnPos.equals((Object)spawnPos)) {
            this.metadata.method_10551("spawnPosX");
            this.metadata.method_10551("spawnPosY");
            this.metadata.method_10551("spawnPosZ");
            this.metadata.method_10569("spawnPosX", spawnPos.method_10263());
            this.metadata.method_10569("spawnPosY", spawnPos.method_10264());
            this.metadata.method_10569("spawnPosZ", spawnPos.method_10260());
            this.refreshSpawnMetadata = true;
            Servux.debugLog("setSpawnPos(): updating World Spawn [{}] -> [{}]", this.spawnPos.method_23854(), spawnPos.method_23854());
        }
        this.spawnPos = spawnPos;
    }

    @Deprecated(forRemoval=true)
    public int getSpawnChunkRadius() {
        if (this.spawnChunkRadius < 0) {
            this.spawnChunkRadius = 2;
        }
        return HudDataProvider.INSTANCE.getSpawnChunkRadius();
    }

    @Deprecated(forRemoval=true)
    public void setSpawnChunkRadius(int radius) {
        if (this.spawnChunkRadius != radius) {
            this.metadata.method_10551("spawnChunkRadius");
            this.metadata.method_10569("spawnChunkRadius", radius);
            this.refreshSpawnMetadata = true;
            Servux.debugLog("setSpawnPos(): updating Spawn Chunk Radius [{}] -> [{}]", this.spawnChunkRadius, radius);
        }
        this.spawnChunkRadius = radius;
    }

    @Deprecated(forRemoval=true)
    public boolean shouldRefreshSpawnMetadata() {
        return this.refreshSpawnMetadata;
    }

    @Deprecated(forRemoval=true)
    public void setRefreshSpawnMetadataComplete() {
        this.refreshSpawnMetadata = false;
        Servux.debugLog("setRefreshSpawnMetadataComplete()", new Object[0]);
    }

    @Deprecated(forRemoval=true)
    public boolean shouldRefreshWeatherData() {
        return this.refreshWeatherData;
    }

    @Deprecated(forRemoval=true)
    public void setRefreshWeatherDataComplete() {
        this.refreshWeatherData = false;
    }

    @Deprecated(forRemoval=true)
    public long getWorldSeed() {
        return HudDataProvider.INSTANCE.getWorldSeed();
    }

    @Deprecated(forRemoval=true)
    public void setWorldSeed(long seed) {
        if (this.worldSeed != seed) {
            if (((Boolean)this.shareSeed.getValue()).booleanValue()) {
                this.metadata.method_10551("worldSeed");
                this.metadata.method_10544("worldSeed", seed);
                this.refreshSpawnMetadata = true;
            }
            Servux.debugLog("setWorldSeed(): updating World Seed [{}] -> [{}]", this.worldSeed, seed);
        }
        this.worldSeed = seed;
    }

    @Deprecated(forRemoval=true)
    public void checkWorldSeed(MinecraftServer server) {
        class_3218 world;
        if (((Boolean)this.shareSeed.getValue()).booleanValue() && (world = server.method_30002()) != null) {
            this.setWorldSeed(world.method_8412());
        }
    }

    @Deprecated(forRemoval=true)
    public boolean hasPermissionsForWeather(class_3222 player) {
        return Permissions.check((class_1297)player, (String)(this.permNode + ".weather"), (int)((Integer)this.weatherPermissionLevel.getValue()));
    }

    @Deprecated(forRemoval=true)
    public boolean hasPermissionsForSeed(class_3222 player) {
        return Permissions.check((class_1297)player, (String)(this.permNode + ".seed"), (int)((Integer)this.seedPermissionLevel.getValue()));
    }

    @Override
    public boolean hasPermission(class_3222 player) {
        return Permissions.check((class_1297)player, (String)this.permNode, (int)((Integer)this.permissionLevel.getValue()));
    }

    @Override
    public void onTickEndPre() {
    }

    @Override
    public void onTickEndPost() {
    }
}

